/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvGreeter;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.logging.Logging;

public class LimitedRangeGreeter
implements EndpointListener,
RdvGreeter {
    private static final Logger LOG = Logger.getLogger(LimitedRangeGreeter.class.getName());
    private final LimitedRangeWalk walk;
    private final EndpointService endpoint;

    public LimitedRangeGreeter(LimitedRangeWalk walk) {
        this.walk = walk;
        this.endpoint = walk.getPeerGroup().getEndpointService();
        if (!this.endpoint.addIncomingMessageListener(this, walk.getWalkServiceName(), walk.getWalkServiceParam())) {
            throw new IllegalStateException("Could not register endpoint listener for greeter.");
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Listening on " + walk.getWalkServiceName() + "/" + walk.getWalkServiceParam());
        }
    }

    public synchronized void stop() {
        this.endpoint.removeIncomingMessageListener(this.walk.getWalkServiceName(), this.walk.getWalkServiceParam());
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block8: {
            LimitedRangeRdvMsg rdvMsg;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Processing " + message + " from " + srcAddr);
            }
            if (null == (rdvMsg = LimitedRangeWalk.getRdvMessage(message))) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Limited Range Greeter received invalid " + message + ". Dropping it.");
                }
                return;
            }
            if (rdvMsg.getTTL() <= 0) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("No TTL remaining for " + message + ". Dropping it.");
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Limited Range Greeter calling listener");
            }
            try {
                this.walk.getListener().processIncomingMessage(message, srcAddr, dstAddr);
            }
            catch (Throwable ignored) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block8;
                LOG.log(Level.SEVERE, "Uncaught Throwable in listener (" + this.walk.getListener() + ")", ignored);
            }
        }
    }

    public void replyMessage(Message msg, Message reply) throws IOException {
        LimitedRangeRdvMsg rdvMsg = LimitedRangeWalk.getRdvMessage(msg);
        if (rdvMsg == null) {
            throw new IOException("LimitedRangeWalker was not able to send message: not from this greeter");
        }
        PeerViewElement pve = this.walk.getPeerView().getPeerViewElement(rdvMsg.getSrcPeerID());
        if (null == pve) {
            throw new IOException("LimitedRangeWalker was not able to send message: no pve");
        }
        if (!pve.sendMessage(msg, rdvMsg.getSrcSvcName(), rdvMsg.getSrcSvcParams())) {
            throw new IOException("LimitedRangeWalker was not able to send message: send failed");
        }
    }
}

