/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.protocol.PipeAdvertisement;

public class PipeAdv
extends PipeAdvertisement {
    private static final Logger LOG = Logger.getLogger(PipeAdv.class.getName());
    private static final String[] INDEX_FIELDS = new String[]{"Name", "Id"};

    private PipeAdv() {
    }

    private PipeAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PipeAdv.getAdvertisementType()) && !PipeAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem);
        }
        if (null == this.getPipeID() || this.getPipeID().equals(ID.nullID)) {
            throw new IllegalArgumentException("Bad pipe ID in advertisement");
        }
        if (null == this.getType() || 0 == this.getType().length()) {
            throw new IllegalArgumentException("Bad pipe type in advertisement");
        }
    }

    public String getAdvType() {
        return PipeAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if ("Desc".equals(elem.getName())) {
            this.setDesc(elem);
            return true;
        }
        String value = elem.getTextValue();
        if (null == value || 0 == value.trim().length()) {
            return false;
        }
        value = value.trim();
        if ("Id".equals(elem.getName())) {
            try {
                URI pipeID = new URI(value);
                this.setPipeID(IDFactory.fromURI(pipeID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID is not a pipe ID");
            }
            return true;
        }
        if ("Name".equals(elem.getName())) {
            this.setName(value);
            return true;
        }
        if ("Type".equals(elem.getName())) {
            this.setType(value);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument desc;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        ID itsID = this.getPipeID();
        if (null == itsID || itsID.equals(ID.nullID)) {
            throw new IllegalStateException("Pipe has no assigned ID");
        }
        Object e = adv.createElement("Id", itsID.toString());
        adv.appendChild(e);
        if (null == this.getType() || 0 == this.getType().length()) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Pipe type not set. Defaulting to JxtaUnicast.\n This default is deprecated. Please set the pipe type in your code.");
            }
            this.setType("JxtaUnicast");
        }
        e = adv.createElement("Type", this.getType());
        adv.appendChild(e);
        if (this.getName() != null) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public static final class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PipeAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PipeAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new PipeAdv((XMLElement)root);
        }
    }
}

