/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.logging.Logging;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;

public class SecureInputPipeImpl
extends InputPipeImpl {
    private static final Logger LOG = Logger.getLogger(SecureInputPipeImpl.class.getName());

    SecureInputPipeImpl(PipeResolver pipeResolver, PipeAdvertisement adv) throws IOException {
        this(pipeResolver, adv, null);
    }

    SecureInputPipeImpl(PipeResolver r, PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        super(r, adv, listener);
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        Object fromTLS = msg.getMessageProperty(TlsTransport.class);
        if (null != fromTLS) {
            super.processIncomingMessage(msg, srcAddr, dstAddr);
        } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("processIncomingMessage : Discarding " + msg + " because it did not come from TLS");
        }
    }
}

