/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.cbjx.CbJxDefs;
import net.jxta.impl.endpoint.mcast.McastTransport;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.JxtaLoader;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;

public class Platform
extends StdPeerGroup {
    private static final transient Logger LOG = Logger.getLogger(Platform.class.getName());

    public Platform() throws PeerGroupException {
        throw new JxtaError("Zero params constructor is no longer supported for World PeerGroup class.");
    }

    public Platform(ConfigParams config, URI storeHome) {
        this.jxtaHome = storeHome;
        this.setConfigAdvertisement(config);
    }

    protected synchronized void initFirst(PeerGroup nullParent, ID assignedID, Advertisement impl) throws PeerGroupException {
        ModuleImplAdvertisement implAdv;
        block9: {
            if (this.initComplete) {
                LOG.severe("You cannot initialize more than one World PeerGroup!");
                throw new PeerGroupException("You cannot initialize more than one World PeerGroup!");
            }
            if (nullParent != null) {
                LOG.severe("World PeerGroup cannot be instantiated with a parent group!");
                throw new PeerGroupException("World PeerGroup cannot be instantiated with a parent group!");
            }
            implAdv = (ModuleImplAdvertisement)impl;
            if (null == implAdv) {
                try {
                    implAdv = Platform.mkWorldPeerGroupImplAdv();
                }
                catch (Throwable e) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Fatal Error making World PeerGroup Impl Adv", e);
                    }
                    throw new PeerGroupException("Fatal Error making World PeerGroup Impl Adv", e);
                }
            }
            if (null != this.jxtaHome) {
                try {
                    URL downloadablesURL = this.jxtaHome.resolve("Downloaded/").toURL();
                    Platform.getJxtaLoader().addURL(downloadablesURL);
                }
                catch (MalformedURLException badPath) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block9;
                    LOG.warning("Could not install path for downloadables into JXTA Class Loader.");
                }
            }
        }
        super.initFirst(null, PeerGroupID.worldPeerGroupID, implAdv);
    }

    protected synchronized void initLast() throws PeerGroupException {
        super.initLast();
        try {
            this.publishGroup("World PeerGroup", "Standard World PeerGroup Reference Implementation");
        }
        catch (IOException e) {
            throw new PeerGroupException("Failed to publish World PeerGroup Advertisement", e);
        }
    }

    private static ModuleImplAdvertisement mkWorldPeerGroupImplAdv() throws Exception {
        JxtaLoader loader = Platform.getJxtaLoader();
        ModuleImplAdvertisement worldGroupDef = loader.findModuleImplAdvertisement(PeerGroup.refPlatformSpecID);
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        paramAdv.addService(PeerGroup.endpointClassID, PeerGroup.refEndpointSpecID);
        paramAdv.addService(PeerGroup.resolverClassID, PeerGroup.refResolverSpecID);
        paramAdv.addService(PeerGroup.membershipClassID, PeerGroup.refMembershipSpecID);
        paramAdv.addService(PeerGroup.accessClassID, PeerGroup.refAccessSpecID);
        paramAdv.addService(PeerGroup.discoveryClassID, PeerGroup.refDiscoverySpecID);
        paramAdv.addService(PeerGroup.rendezvousClassID, PeerGroup.refRendezvousSpecID);
        paramAdv.addService(PeerGroup.peerinfoClassID, PeerGroup.refPeerinfoSpecID);
        paramAdv.addProto(PeerGroup.tcpProtoClassID, PeerGroup.refTcpProtoSpecID);
        paramAdv.addProto(PeerGroup.httpProtoClassID, PeerGroup.refHttpProtoSpecID);
        paramAdv.addProto(McastTransport.MCAST_TRANSPORT_CLASSID, McastTransport.MCAST_TRANSPORT_SPECID);
        worldGroupDef.setParam((XMLDocument)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        return worldGroupDef;
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() {
        JxtaLoader loader = Platform.getJxtaLoader();
        ModuleImplAdvertisement implAdv = loader.findModuleImplAdvertisement(PeerGroup.refNetPeerGroupSpecID);
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        paramAdv.addService(PeerGroup.endpointClassID, PeerGroup.refEndpointSpecID);
        paramAdv.addService(PeerGroup.resolverClassID, PeerGroup.refResolverSpecID);
        paramAdv.addService(PeerGroup.membershipClassID, PSEMembershipService.pseMembershipSpecID);
        paramAdv.addService(PeerGroup.accessClassID, PeerGroup.refAccessSpecID);
        paramAdv.addService(PeerGroup.discoveryClassID, PeerGroup.refDiscoverySpecID);
        paramAdv.addService(PeerGroup.rendezvousClassID, PeerGroup.refRendezvousSpecID);
        paramAdv.addService(PeerGroup.pipeClassID, PeerGroup.refPipeSpecID);
        paramAdv.addService(PeerGroup.peerinfoClassID, PeerGroup.refPeerinfoSpecID);
        paramAdv.addService(PeerGroup.proxyClassID, PeerGroup.refProxySpecID);
        paramAdv.addProto(PeerGroup.routerProtoClassID, PeerGroup.refRouterProtoSpecID);
        paramAdv.addProto(PeerGroup.tlsProtoClassID, PeerGroup.refTlsProtoSpecID);
        paramAdv.addProto(CbJxDefs.msgtptClassID, CbJxDefs.cbjxMsgTransportSpecID);
        paramAdv.addProto(PeerGroup.relayProtoClassID, PeerGroup.refRelayProtoSpecID);
        ModuleImplAdvertisement moduleAdv = loader.findModuleImplAdvertisement(PeerGroup.refShellSpecID);
        if (null != moduleAdv) {
            paramAdv.addApp(PeerGroup.applicationClassID, moduleAdv);
        }
        XMLElement paramElement = (XMLElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        return implAdv;
    }

    public URI getStoreHome() {
        return this.jxtaHome;
    }
}

