/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.exception.ConfiguratorException;
import net.jxta.exception.JxtaError;
import net.jxta.impl.peergroup.AutomaticConfigurator;
import net.jxta.impl.peergroup.ConfigDialog;
import net.jxta.impl.peergroup.IncompleteConfigurationException;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;

public class DefaultConfigurator
extends AutomaticConfigurator {
    private static final transient Logger LOG = Logger.getLogger(DefaultConfigurator.class.getName());

    public DefaultConfigurator(URI jxtaHome) throws ConfiguratorException {
        super(jxtaHome);
    }

    public boolean isReconfigure() {
        if (!"file".equalsIgnoreCase(this.jxtaHome.getScheme())) {
            return false;
        }
        File jxtaHomeDir = new File(this.jxtaHome);
        try {
            File file = new File(jxtaHomeDir, "reconf");
            boolean forceReconfig = file.exists();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("force reconfig : " + forceReconfig);
            }
            return forceReconfig;
        }
        catch (Exception ex1) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Could not check 'reconf' file. Assuming it exists.", ex1);
            }
            if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                LOG.config("Reconfig required - error getting 'reconf' file");
            }
            return true;
        }
    }

    public void setReconfigure(boolean reconfigure) {
        block7: {
            if (!"file".equalsIgnoreCase(this.jxtaHome.getScheme())) {
                return;
            }
            File jxtaHomeDir = new File(this.jxtaHome);
            File f = new File(jxtaHomeDir, "reconf");
            if (reconfigure) {
                try {
                    f.createNewFile();
                }
                catch (IOException ex1) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Could not create 'reconf' file", ex1);
                        LOG.severe("Create the file 'reconf' by hand before retrying.");
                    }
                    break block7;
                }
            }
            try {
                f.delete();
            }
            catch (Exception ex1) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block7;
                LOG.log(Level.SEVERE, "Could not remove 'reconf' file", ex1);
                LOG.severe("Delete the file 'reconf' by hand before retrying.");
            }
        }
    }

    public PlatformConfig getPlatformConfig() throws ConfiguratorException {
        boolean needsConfig;
        block20: {
            needsConfig = this.isReconfigure();
            if (needsConfig && Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                LOG.config("Reconfig requested - Forced reconfigure");
            }
            try {
                PSEConfigAdv pseConfig;
                super.getPlatformConfig();
                XMLDocument security = (XMLDocument)this.advertisement.getServiceParam(PeerGroup.membershipClassID);
                if (null == security) {
                    needsConfig = true;
                    if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
                        LOG.config("Reconfig requested - No security info");
                    }
                    break block20;
                }
                Advertisement adv = null;
                try {
                    adv = AdvertisementFactory.newAdvertisement(security);
                }
                catch (NoSuchElementException notAnAdv) {
                }
                catch (IllegalArgumentException badAdv) {
                    // empty catch block
                }
                needsConfig = adv instanceof PSEConfigAdv ? (needsConfig |= null == (pseConfig = (PSEConfigAdv)adv).getCertificate()) : true;
            }
            catch (IncompleteConfigurationException configBad) {
                needsConfig = true;
            }
        }
        if (needsConfig) {
            this.setReconfigure(true);
            try {
                if (EventQueue.isDispatchThread()) {
                    LOG.severe("The JXTA AWT Configuration Dialog cannot be run from the event dispatch thread. It's modal nature is fundamentally incompatible with running on the event dispatch thread. Either change to a different Configurator via PeerGroupFactory.setConfiguratorClass() or start JXTA from the application main Thread before starting your GUI via invokeLater().");
                    System.exit(1);
                }
                ConfigDialog configUI = new ConfigDialog(this.advertisement);
                configUI.untilDone();
                this.setReconfigure(false);
            }
            catch (Throwable t) {
                if (t instanceof JxtaError) {
                    throw (JxtaError)t;
                }
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Could not initialize graphical config dialog", t);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    while (in.ready()) {
                        in.readLine();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                System.err.flush();
                System.out.flush();
                System.out.println("The window-based configurator does not seem to be usable.");
                System.out.print("Do you want to stop and edit the current configuration ? [no]: ");
                System.out.flush();
                String answer = "no";
                try {
                    answer = in.readLine();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if ("yes".equalsIgnoreCase(answer)) {
                    this.save();
                    System.out.println("Exiting; edit the file \"" + this.configFile.getPath() + "\", remove the file \"reconf\", and then launch JXTA again.");
                    throw new JxtaError("Manual Configuration Requested");
                }
                System.out.println("Attempting to continue using the current configuration.");
            }
        }
        return this.advertisement;
    }
}

