/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.meter;

import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.meter.ServiceMonitorImpl;
import net.jxta.meter.ServiceMonitor;
import net.jxta.meter.ServiceMonitorFilter;

public class ServiceMonitorPulseInfo {
    public static final int NOT_PULSING = -1;
    private MonitorManager monitorManager;
    ServiceMonitor serviceMonitor;
    private LinkedList<RegisteredServiceMonitorFilter> registeredServiceMonitorFilters = new LinkedList();
    private int pulseRateIndex = -1;
    private long pulseRate = -1L;
    private int[] filtersPerRate;
    private boolean pulsing;

    public ServiceMonitorPulseInfo() {
    }

    ServiceMonitorPulseInfo(MonitorManager monitorManager, ServiceMonitor serviceMonitor) {
        this.monitorManager = monitorManager;
        this.serviceMonitor = serviceMonitor;
        this.filtersPerRate = new int[monitorManager.getReportRatesCount()];
    }

    public ServiceMonitor getServiceMonitor() {
        return this.serviceMonitor;
    }

    public int getPulseRateIndex() {
        return this.pulseRateIndex;
    }

    public long getPulseRate() {
        return this.pulseRate;
    }

    public boolean isPulsing() {
        return this.pulsing;
    }

    public boolean isEvenPulseForRateIndex(int pulseRateIndex) {
        return this.monitorManager.isEvenPulseForRateIndex(pulseRateIndex);
    }

    public boolean isRegisteredFilterForRate(int pulseRateIndex) {
        return this.filtersPerRate[pulseRateIndex] != 0;
    }

    void registerServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter, int reportRateIndex, long reportRate) {
        RegisteredServiceMonitorFilter registeredServiceMonitorFilter = new RegisteredServiceMonitorFilter(serviceMonitorFilter, reportRateIndex);
        this.registeredServiceMonitorFilters.add(registeredServiceMonitorFilter);
        int n = reportRateIndex;
        this.filtersPerRate[n] = this.filtersPerRate[n] + 1;
        if (this.pulseRateIndex == -1 || reportRateIndex < this.pulseRateIndex) {
            int oldPulseRateIndex = this.pulseRateIndex;
            this.pulseRateIndex = reportRateIndex;
            this.pulseRate = reportRate;
            this.pulsing = true;
            if (this.serviceMonitor instanceof ServiceMonitorImpl) {
                ((ServiceMonitorImpl)this.serviceMonitor).resetPulseRate(this, oldPulseRateIndex);
            }
        }
        boolean newRate = this.filtersPerRate[reportRateIndex] == 1;
        this.serviceMonitor.serviceMonitorFilterRegistered(serviceMonitorFilter, reportRateIndex, reportRate, newRate);
    }

    boolean deregisterServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter, int reportRateIndex, long reportRate) {
        boolean removed = false;
        Iterator i = this.registeredServiceMonitorFilters.iterator();
        while (i.hasNext()) {
            RegisteredServiceMonitorFilter registeredMonitorFilter = (RegisteredServiceMonitorFilter)i.next();
            if (registeredMonitorFilter.serviceMonitorFilter != serviceMonitorFilter || registeredMonitorFilter.reportRateIndex != reportRateIndex) continue;
            i.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return false;
        }
        int n = reportRateIndex;
        this.filtersPerRate[n] = this.filtersPerRate[n] - 1;
        this.serviceMonitor.serviceMonitorFilterDeregistered(serviceMonitorFilter, reportRateIndex, reportRate, this.filtersPerRate[reportRateIndex] == 0);
        if (this.filtersPerRate[reportRateIndex] == 0 && reportRateIndex == this.pulseRateIndex) {
            int newPulseRateIndex = -1;
            for (int i2 = this.pulseRateIndex; i2 < this.filtersPerRate.length; ++i2) {
                if (this.filtersPerRate[i2] == 0) continue;
                newPulseRateIndex = i2;
                break;
            }
            int oldPulserRateIndex = this.pulseRateIndex;
            this.pulseRateIndex = newPulseRateIndex;
            if (newPulseRateIndex != -1) {
                this.pulseRate = this.monitorManager.getReportRate(this.pulseRateIndex);
                this.pulsing = true;
            } else {
                this.pulseRate = -1L;
                this.pulsing = false;
            }
            if (this.serviceMonitor instanceof ServiceMonitorImpl) {
                ((ServiceMonitorImpl)this.serviceMonitor).resetPulseRate(this, oldPulserRateIndex);
            }
        }
        return removed;
    }

    private class RegisteredServiceMonitorFilter {
        ServiceMonitorFilter serviceMonitorFilter;
        int reportRateIndex;

        RegisteredServiceMonitorFilter(ServiceMonitorFilter serviceMonitorFilter, int reportRateIndex) {
            this.serviceMonitorFilter = serviceMonitorFilter;
            this.reportRateIndex = reportRateIndex;
        }
    }
}

