/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;
import net.jxta.impl.util.BASE64InputStream;
import net.jxta.impl.util.BASE64OutputStream;

public class BinaryID
implements Serializable {
    private static final transient Logger LOG = Logger.getLogger(BinaryID.class.getName());
    public static String UUIDEncoded = "uuid";
    public static final int flagsSize = 1;
    public static final byte flagPeerGroupID = 97;
    public static final byte flagPeerID = 98;
    public static final byte flagPipeID = 99;
    public static final byte flagModuleClassID = 100;
    public static final byte flagModuleClassRoleID = 101;
    public static final byte flagModuleSpecID = 102;
    public static final byte flagCodatID = 103;
    public static final byte flagGenericID = 122;
    public static final int flagsOffset = 0;
    public static final int dataOffset = 1;
    private static final byte[] nullID = new byte[]{0};
    public static final BinaryID nullBinaryID = new BinaryID(122, nullID, true);
    protected String encodedValue = null;

    public BinaryID() {
        this.encodedValue = BinaryID.nullBinaryID.encodedValue;
    }

    public BinaryID(byte id) {
        this(id, nullID, true);
    }

    protected BinaryID(String encodedValue) {
        this.encodedValue = encodedValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BinaryID(byte type, byte[] data, boolean lengthIncluded) {
        if (lengthIncluded && data.length < 256 && data.length > 1) {
            if (data[0] != data.length - 1) throw new RuntimeException("Length of data section is " + (data.length - 1) + " but byte zero says length is:" + data[0] + ".");
            try {
                StringWriter base64 = new StringWriter();
                BASE64OutputStream encoder = new BASE64OutputStream(base64);
                encoder.write(data);
                encoder.close();
                this.encodedValue = (char)type + base64.toString();
                return;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to encode binary value.", e);
                throw new RuntimeException("Unable to encode binary value.");
            }
        } else if (!lengthIncluded && data.length > 0) {
            byte[] temp = new byte[data.length + 1];
            temp[0] = (byte)data.length;
            System.arraycopy(data, 0, temp, 1, data.length);
            try {
                StringWriter base64 = new StringWriter();
                BASE64OutputStream encoder = new BASE64OutputStream(base64);
                encoder.write(temp);
                encoder.close();
                this.encodedValue = (char)type + base64.toString();
                return;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to encode binary value.", e);
                throw new RuntimeException("Unable to encode binary value.");
            }
        } else {
            if (lengthIncluded && (data.length > 256 || data.length == 0)) {
                throw new RuntimeException("Length of 'data' is " + data.length + " must be >0 and less or equal to 256.");
            }
            if (lengthIncluded || data.length <= 255) return;
            throw new RuntimeException("Length of 'data' is " + data.length + "  must be less than 256. ");
        }
    }

    public byte[] toByteArray() {
        try {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BASE64InputStream decoder = new BASE64InputStream(new StringReader(this.encodedValue.substring(1)));
            while (-1 != (c = decoder.read())) {
                bos.write(c);
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to decode binary value.", e);
            throw new RuntimeException("Unable to encode binary value.");
        }
    }

    public byte[] toSizeIncludedByteArray() {
        byte[] data = this.toByteArray();
        byte[] temp = new byte[data.length - 1];
        System.arraycopy(data, 1, temp, 0, temp.length);
        return temp;
    }

    public String encodedValue() {
        return this.encodedValue;
    }

    public int hashCode() {
        return this.encodedValue.hashCode();
    }

    public boolean equals(Object target) {
        boolean result = false;
        if (target == this) {
            result = true;
        } else if (target == null) {
            result = false;
        } else if (target instanceof BinaryID) {
            result = this.encodedValue().equals(((BinaryID)target).encodedValue());
            LOG.fine("((BinaryID)target).encodedValue():" + ((BinaryID)target).encodedValue());
        } else if (target instanceof ID && (ID)target == ID.nullID && nullBinaryID.encodedValue().equals(this.encodedValue())) {
            result = true;
        }
        return result;
    }

    public byte type() {
        return (byte)this.encodedValue.charAt(0);
    }

    public String toString() {
        return this.encodedValue;
    }

    public String getID() {
        return this.encodedValue;
    }
}

