/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JTlsInputStream
extends InputStream {
    private static final Logger LOG = Logger.getLogger(JTlsInputStream.class.getName());
    private static final boolean DEBUGIO = false;
    private static int MAXQUEUESIZE = 25;
    private TlsConn conn;
    private volatile boolean closed = false;
    private boolean closing = false;
    private long timeout = 120000L;
    private JTlsRecord jtrec = null;
    private volatile int sequenceNumber = 0;
    private final Vector<IQElt> inputQueue = new Vector(MAXQUEUESIZE);

    public JTlsInputStream(TlsConn conn, long timeout) {
        this.timeout = timeout;
        this.conn = conn;
        this.jtrec = new JTlsRecord();
        this.sequenceNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
        Vector<IQElt> vector = this.inputQueue;
        synchronized (vector) {
            this.inputQueue.clear();
            this.inputQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() throws IOException {
        Vector<IQElt> vector = this.inputQueue;
        synchronized (vector) {
            this.closing = true;
            this.inputQueue.notifyAll();
        }
    }

    @Override
    public int read() throws IOException {
        int len;
        if (this.closed) {
            return -1;
        }
        byte[] a = new byte[1];
        while ((len = this.local_read(a, 0, 1)) >= 0) {
            if (len <= 0) continue;
            return a[0] & 0xFF;
        }
        this.close();
        return -1;
    }

    @Override
    public int read(byte[] a, int offset, int length) throws IOException {
        if (this.closed) {
            return -1;
        }
        if (0 == length) {
            return 0;
        }
        int i = this.local_read(a, offset, length);
        if (i == -1) {
            this.close();
        }
        return i;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getMaxIQSize() {
        return MAXQUEUESIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendACK(int seqnAck) {
        ArrayList<Integer> selectedAckList = new ArrayList<Integer>();
        Vector<IQElt> vector = this.inputQueue;
        synchronized (vector) {
            Iterator<IQElt> eachInQueue = this.inputQueue.iterator();
            while (eachInQueue.hasNext() && selectedAckList.size() < MAXQUEUESIZE) {
                IQElt anIQElt = eachInQueue.next();
                if (anIQElt.seqnum <= seqnAck) continue;
                selectedAckList.add(new Integer(anIQElt.seqnum));
            }
        }
        this.sendACK(seqnAck, selectedAckList);
    }

    private void sendACK(int seqnAck, List<Integer> sackList) {
        block4: {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((1 + sackList.size()) * 4);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeInt(seqnAck);
                for (int aSack : sackList) {
                    dos.writeInt(aSack);
                }
                dos.close();
                bos.close();
                Message ACKMsg = new Message();
                ByteArrayMessageElement elt = new ByteArrayMessageElement("TLSACK", JTlsDefs.ACKS, bos.toByteArray(), null);
                ACKMsg.addMessageElement("jxtatls", elt);
                this.conn.sendToRemoteTls(ACKMsg);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SENT ACK, seqn#" + seqnAck + " and " + sackList.size() + " SACKs ");
                }
            }
            catch (IOException e) {
                if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) break block4;
                LOG.log(Level.INFO, "sendACK caught IOException:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueIncomingMessage(Message msg) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Queue Incoming Message begins for " + msg);
        }
        long startEnqueue = TimeUtils.timeNow();
        Message.ElementIterator e = msg.getMessageElements("jxtatls", JTlsDefs.BLOCKS);
        while (!this.closed && !this.closing && e.hasNext()) {
            MessageElement elt = e.next();
            e.remove();
            int msgSeqn = 0;
            try {
                msgSeqn = Integer.parseInt(elt.getElementName());
            }
            catch (NumberFormatException n) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Discarding element (" + elt.getElementName() + ") Not one of ours.");
                continue;
            }
            IQElt newElt = new IQElt();
            newElt.seqnum = msgSeqn;
            newElt.elt = elt;
            newElt.ackd = false;
            if (newElt.seqnum <= this.sequenceNumber) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
                LOG.fine("RCVD OLD MESSAGE : Discard seqn#" + newElt.seqnum + " now at seqn#" + this.sequenceNumber);
                break;
            }
            Vector<IQElt> vector = this.inputQueue;
            synchronized (vector) {
                if (this.closing || this.closed) {
                    return;
                }
                int insertIndex = this.inputQueue.size();
                boolean duplicate = false;
                for (int j = 0; j < this.inputQueue.size(); ++j) {
                    IQElt iq = this.inputQueue.elementAt(j);
                    if (newElt.seqnum < iq.seqnum) {
                        insertIndex = j;
                        break;
                    }
                    if (newElt.seqnum != iq.seqnum) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("RCVD OLD MESSAGE : Discard duplicate msg, seqn#" + newElt.seqnum);
                    }
                    newElt = null;
                    break;
                }
                this.inputQueue.add(insertIndex, newElt);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Enqueued msg with seqn#" + newElt.seqnum + " at index " + insertIndex);
                }
                this.inputQueue.notifyAll();
                newElt = null;
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startEnqueue);
            LOG.fine("Queue Incoming Message for " + msg + " completed in " + waited + " msec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageElement dequeueMessage(int desiredSeqn) throws IOException {
        IQElt iQ = null;
        long startDequeue = TimeUtils.timeNow();
        long whenToTimeout = startDequeue + this.timeout;
        int wct = 0;
        long nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
        Vector<IQElt> vector = this.inputQueue;
        synchronized (vector) {
            while (!this.closed) {
                if (this.inputQueue.size() == 0) {
                    if (this.closing) {
                        return null;
                    }
                    try {
                        ++wct;
                        this.inputQueue.wait(1000L);
                        if (whenToTimeout < TimeUtils.timeNow()) {
                            throw new SocketTimeoutException("Read timeout reached");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                    continue;
                }
                iQ = this.inputQueue.elementAt(0);
                if (iQ.seqnum < desiredSeqn) {
                    this.inputQueue.remove(0);
                    this.sendACK(iQ.seqnum);
                    continue;
                }
                if (iQ.seqnum != desiredSeqn) {
                    if (TimeUtils.toRelativeTimeMillis(nextRetransRequest) < 0L) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Trigger retransmission. Wanted seqn#" + desiredSeqn + " found seqn#" + iQ.seqnum);
                        }
                        this.sendACK(desiredSeqn - 1);
                        nextRetransRequest = TimeUtils.toAbsoluteTimeMillis(1000L);
                    }
                    try {
                        ++wct;
                        this.inputQueue.wait(1000L);
                        if (whenToTimeout >= TimeUtils.timeNow()) continue;
                        throw new SocketTimeoutException("Read timeout reached");
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("IO interrupted ");
                    }
                }
                this.inputQueue.remove(0);
                break;
            }
        }
        nextRetransRequest = 0L;
        this.sendACK(desiredSeqn);
        if (null == iQ) {
            return null;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            long waited = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), startDequeue);
            LOG.info("DEQUEUED seqn#" + iQ.seqnum + " in " + waited + " msec on input queue");
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE) && wct > 0) {
                LOG.fine("DEQUEUE waited " + wct + " times on input queue");
            }
        }
        return iQ.elt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int local_read(byte[] a, int offset, int length) throws IOException {
        JTlsRecord jTlsRecord = this.jtrec;
        synchronized (jTlsRecord) {
            int res;
            if (this.jtrec.size == 0L || this.jtrec.nextByte == this.jtrec.size) {
                this.jtrec.resetRecord();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("local_read: getting next data block at seqn#" + (this.sequenceNumber + 1));
                }
                MessageElement elt = null;
                try {
                    elt = this.dequeueMessage(this.sequenceNumber + 1);
                }
                catch (SocketTimeoutException ste) {
                    return 0;
                }
                if (null == elt) {
                    return -1;
                }
                ++this.sequenceNumber;
                this.jtrec.size = elt.getByteLength();
                this.jtrec.tlsRecord = elt.getStream();
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("local_read: new seqn#" + this.sequenceNumber + ", bytes = " + this.jtrec.size);
                }
            }
            long left = this.jtrec.size - this.jtrec.nextByte;
            int copyLen = (int)Math.min((long)length, left);
            int copied = 0;
            while ((res = this.jtrec.tlsRecord.read(a, offset + copied, copyLen - copied)) >= 0 && (copied += res) < copyLen) {
            }
            this.jtrec.nextByte += (long)copied;
            return copied;
        }
    }

    private static class IQElt {
        int seqnum;
        MessageElement elt;
        boolean ackd;

        private IQElt() {
        }
    }

    private static class JTlsRecord {
        public InputStream tlsRecord = null;
        public long nextByte = 0L;
        public long size = 0L;

        public void resetRecord() {
            if (null != this.tlsRecord) {
                try {
                    this.tlsRecord.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.tlsRecord = null;
            this.nextByte = 0L;
            this.size = 0L;
        }
    }
}

