/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.endpoint.router.BadRoute;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.RouteQuery;
import net.jxta.impl.protocol.RouteResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.SrdiMessage;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RouteResolver
implements Module,
QueryHandler,
SrdiHandler,
Srdi.SrdiInterface {
    private static final transient Logger LOG = Logger.getLogger(RouteResolver.class.getName());
    public static final String routerSName = "EndpointRouter";
    private static final String srdiIndexerFileName = "routerSrdi";
    private static final int NACKROUTE_QUERYID = -1;
    private static final long BADROUTE_EXPIRATION = 120000L;
    private static final boolean USE_ROUTE_RESOLVER_DEFAULT = true;
    private boolean useRouteResolver = true;
    private PeerGroup group = null;
    private ResolverService resolver = null;
    private MembershipService membership = null;
    private EndpointRouter router = null;
    private EndpointAddress localPeerAddr = null;
    private ID localPeerId = null;
    private RouteCM routeCM = null;
    private static final AtomicInteger qid = new AtomicInteger(0);
    private SrdiIndex srdiIndex = null;
    private Srdi srdi = null;
    CurrentCredential currentCredential;
    final CredentialListener membershipCredListener = new CredentialListener();

    RouteResolver(EndpointRouter router) {
        this.router = router;
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        Enumeration param;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        ConfigParams confAdv = group.getConfigAdvertisement();
        XMLElement paramBlock = null;
        if (confAdv != null) {
            paramBlock = (XMLElement)((Object)confAdv.getServiceParam(assignedID));
        }
        if (paramBlock != null && (param = paramBlock.getChildren("useRouteResolver")).hasMoreElements()) {
            this.useRouteResolver = Boolean.getBoolean(((XMLElement)param.nextElement()).getTextValue());
        }
        this.group = group;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = EndpointRouter.pid2addr(group.getPeerID());
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Router Transport Resolver : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration:");
            configInfo.append("\n\t\tUse Route Resolver : ").append(this.useRouteResolver());
            LOG.config(configInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startApp(String[] arg) {
        this.resolver = this.group.getResolverService();
        if (null == this.resolver) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Endpoint Router start stalled until resolver service available");
            }
            return 2;
        }
        this.membership = this.group.getMembershipService();
        if (null == this.membership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Endpoint Router start stalled until membership service available");
            }
            return 2;
        }
        this.resolver.registerHandler(routerSName, this);
        this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
        this.srdi = new Srdi(this.group, routerSName, this, this.srdiIndex, 0L, 0L);
        this.resolver.registerSrdiHandler(routerSName, this);
        RouteResolver routeResolver = this;
        synchronized (routeResolver) {
            block10: {
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.currentCredential = null;
                    Credential credential = this.membership.getDefaultCredential();
                    if (null != credential) {
                        XMLDocument credentialDoc = (XMLDocument)credential.getDocument(MimeMediaType.XMLUTF8);
                        this.currentCredential = new CurrentCredential(credential, credentialDoc);
                    }
                }
                catch (Exception all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                    LOG.log(Level.WARNING, "could not get default credential", all);
                }
            }
        }
        this.routeCM = this.router.getRouteCM();
        return 0;
    }

    @Override
    public void stopApp() {
        this.resolver.unregisterHandler(routerSName);
        this.resolver.unregisterSrdiHandler(routerSName);
        this.srdiIndex.stop();
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.currentCredential = null;
        this.resolver = null;
        this.srdi = null;
        this.membership = null;
    }

    boolean useRouteResolver() {
        return this.useRouteResolver;
    }

    void enableRouteResolver(boolean enable) {
        this.useRouteResolver = enable;
    }

    protected void findRoute(EndpointAddress peer) {
        block20: {
            RouteAdvertisement myRoute = this.router.getMyLocalRoute();
            if (myRoute == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Cannot issue a find route if we don't know our own route");
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Find route for peer = " + peer);
            }
            try {
                CurrentCredential current;
                RouteQuery doc;
                BadRoute badRoute = this.router.getBadRoute(peer);
                if (badRoute != null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("findRoute sends query: known bad Hops" + badRoute);
                    }
                    doc = new RouteQuery(EndpointRouter.addr2pid(peer), myRoute, badRoute.getBadHops());
                } else {
                    doc = new RouteQuery(EndpointRouter.addr2pid(peer), myRoute, null);
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sending query for peer : " + peer);
                }
                XMLDocument credentialDoc = null != (current = this.currentCredential) ? current.credentialDoc : null;
                ResolverQuery query = new ResolverQuery(routerSName, credentialDoc, this.localPeerId.toString(), doc.toString(), qid.incrementAndGet());
                if (this.group.isRendezvous() && this.srdiIndex != null) {
                    List<PeerID> results = this.srdiIndex.query("route", "DstPID", EndpointRouter.addr2pid(peer).toString(), 10);
                    if (results != null && !results.isEmpty()) {
                        List<PeerID> clean = this.cleanupAnyEdges(query.getSrcPeer(), results);
                        if (!clean.isEmpty()) {
                            query.incrementHopCount();
                            this.srdi.forwardQuery(clean, query, 1);
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("found an srdi entry forwarding query to SRDI peer");
                            }
                            return;
                        }
                    } else {
                        PeerID destPeer = this.srdi.getReplicaPeer(EndpointRouter.addr2pid(peer).toString());
                        if (destPeer != null && !destPeer.equals(this.localPeerId)) {
                            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("processQuery srdiIndex DHT forward :" + destPeer);
                            }
                            this.srdi.forwardQuery(destPeer, (ResolverQueryMsg)query);
                            return;
                        }
                        LOG.fine("processQuery srdiIndex DHT forward resulted in no op");
                    }
                }
                this.resolver = this.group.getResolverService();
                if (this.resolver != null) {
                    this.resolver.sendQuery(null, query);
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("find route query sent");
                    }
                } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("cannot get the resolver service");
                }
            }
            catch (Exception ee) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block20;
                LOG.log(Level.WARNING, "Exception in findRoute", ee);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processResponse(ResolverResponseMsg response) {
        block16: {
            if (!this.useRouteResolver) {
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("processResponse got a response");
            }
            RouteResponse doc = null;
            try {
                StringReader ip = new StringReader(response.getResponse());
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
                doc = new RouteResponse(asDoc);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING) return;
                if (!LOG.isLoggable(Level.WARNING)) return;
                LOG.log(Level.WARNING, "malformed response - discard", e);
                return;
            }
            RouteAdvertisement dstRoute = doc.getDestRoute();
            RouteAdvertisement srcRoute = doc.getSrcRoute();
            int queryId = response.getQueryId();
            EndpointAddress routingPeer = EndpointRouter.pid2addr(srcRoute.getDestPeerID());
            EndpointAddress destPeer = EndpointRouter.pid2addr(dstRoute.getDestPeerID());
            if (queryId == -1) {
                AccessPointAdvertisement badHop = dstRoute.nextHop(EndpointRouter.addr2pid(routingPeer));
                PeerID badPeer = badHop != null ? badHop.getPeerID() : dstRoute.getDestPeerID();
                this.processBadRoute(badPeer, dstRoute);
                return;
            }
            if (!this.router.isLocalRoute(EndpointRouter.pid2addr(srcRoute.getDestPeerID())) && !this.router.isRoutedRoute(srcRoute.getDestPeerID())) {
                this.router.updateRouteAdv(srcRoute);
            }
            if (destPeer.equals(routingPeer)) {
                if (!Logging.SHOW_FINE) return;
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.fine("learn route directly from the destination");
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("learn route:" + routingPeer);
            }
            try {
                RouteAdvertisement candidateRoute = RouteAdvertisement.newRoute(EndpointRouter.addr2pid(destPeer), EndpointRouter.addr2pid(routingPeer), (Vector)dstRoute.getVectorHops().clone());
                RouteAdvertisement.cleanupLoop(candidateRoute, (PeerID)this.localPeerId);
                if (candidateRoute.size() == 0) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Route response outdated: NACK responder");
                    }
                    this.generateNACKRoute(EndpointRouter.addr2pid(routingPeer), EndpointRouter.addr2pid(destPeer), dstRoute.getVectorHops());
                    return;
                }
                EndpointAddress candidateRouter = EndpointRouter.pid2addr(candidateRoute.getFirstHop().getPeerID());
                if (this.router.ensureLocalRoute(candidateRouter, null) == null) {
                    RouteAdvertisement routeToRouter = this.router.getRoute(candidateRouter, false);
                    if (routeToRouter == null) {
                        if (!Logging.SHOW_FINE) return;
                        if (!LOG.isLoggable(Level.FINE)) return;
                        LOG.fine("Route response useless: no route to next router hop");
                        return;
                    }
                    if (!RouteAdvertisement.stichRoute(candidateRoute, routeToRouter, (PeerID)this.localPeerId)) {
                        if (!Logging.SHOW_FINE) return;
                        if (!LOG.isLoggable(Level.FINE)) return;
                        LOG.fine("Route response error stiching route response");
                        return;
                    }
                    this.router.setRoute(candidateRoute, false);
                } else {
                    this.router.setRoute(candidateRoute, false);
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block16;
                LOG.log(Level.WARNING, "Failure building response route", ex);
                LOG.warning("               bad dstRoute: " + dstRoute.display());
            }
        }
        if (!Logging.SHOW_FINE) return;
        if (!LOG.isLoggable(Level.FINE)) return;
        LOG.fine("finish process route response successfully");
    }

    private void processBadRoute(PeerID badHop, RouteAdvertisement dest) {
        block17: {
            EndpointAddress addr = EndpointRouter.pid2addr(dest.getDestPeerID());
            if (addr == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("remove bad route has a bad route info - discard");
                }
                return;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("remove bad route info for dest " + dest.display());
                if (badHop != null) {
                    LOG.fine("remove bad route bad hop " + badHop);
                }
            }
            try {
                BadRoute badRoute;
                RouteAdvertisement currentRoute = this.router.getRoute(addr, false);
                if (currentRoute == null) {
                    return;
                }
                if (!currentRoute.equals(dest)) {
                    if (badHop == null) {
                        return;
                    }
                    if (badHop.equals(EndpointRouter.addr2pid(addr))) {
                        if (!currentRoute.containsHop(badHop)) {
                            return;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("current route is bad because it contains known bad hop" + badHop);
                        }
                    } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("current route is bad because it contains known bad destination" + badHop);
                    }
                }
                if ((badRoute = this.router.getBadRoute(addr)) != null) {
                    if (badRoute.getExpiration() <= TimeUtils.timeNow()) {
                        badRoute.setExpiration(TimeUtils.toAbsoluteTimeMillis(120000L));
                    }
                    if (badHop != null) {
                        badRoute.addBadHop(badHop);
                        badRoute.setExpiration(TimeUtils.toAbsoluteTimeMillis(120000L));
                    }
                    this.router.setBadRoute(addr, badRoute);
                    return;
                }
                Set<PeerID> badHops = badHop != null ? Collections.singleton(badHop) : Collections.emptySet();
                badRoute = new BadRoute(dest, TimeUtils.toAbsoluteTimeMillis(120000L), badHops);
                this.router.setBadRoute(addr, badRoute);
                this.routeCM.flushRoute(EndpointRouter.addr2pid(addr));
                this.router.removeRoute(EndpointRouter.addr2pid(addr));
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block17;
                LOG.log(Level.WARNING, "exception during bad route removal", ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public int processQuery(ResolverQueryMsg query) {
        RouteAdvertisement route;
        RouteQuery routeQuery;
        if (!this.useRouteResolver) {
            return 0;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("processQuery starts");
        }
        try {
            StringReader ip = new StringReader(query.getQuery());
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
            routeQuery = new RouteQuery(asDoc);
        }
        catch (RuntimeException e) {
            if (!Logging.SHOW_FINE) return 0;
            if (!LOG.isLoggable(Level.FINE)) return 0;
            LOG.log(Level.FINE, "Malformed Route query ", e);
            return 0;
        }
        catch (IOException e) {
            if (!Logging.SHOW_FINE) return 0;
            if (!LOG.isLoggable(Level.FINE)) return 0;
            LOG.log(Level.FINE, "Malformed Route query ", e);
            return 0;
        }
        PeerID pId = routeQuery.getDestPeerID();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Looking for route to " + pId);
        }
        RouteAdvertisement srcRoute = routeQuery.getSrcRoute();
        Set<PeerID> badHops = routeQuery.getBadHops();
        if (Logging.SHOW_FINER && LOG.isLoggable(Level.FINER)) {
            StringBuilder badHopsDump = new StringBuilder("bad Hops :\n");
            for (PeerID aBadHop : badHops) {
                badHopsDump.append('\t').append(aBadHop);
            }
            LOG.finer(badHopsDump.toString());
        }
        if (srcRoute == null) {
            if (!Logging.SHOW_FINE) return 0;
            if (!LOG.isLoggable(Level.FINE)) return 0;
            LOG.fine("No src Route in route query - discard ");
            return 0;
        }
        if (!srcRoute.getDestPeerID().equals(this.localPeerId)) {
            try {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Publishing sender route info " + srcRoute.getDestPeerID());
                }
                if (!this.router.isLocalRoute(EndpointRouter.pid2addr(srcRoute.getDestPeerID())) && !this.router.isRoutedRoute(srcRoute.getDestPeerID())) {
                    this.routeCM.publishRoute(srcRoute);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_FINE) return 0;
                if (!LOG.isLoggable(Level.FINE)) return 0;
                LOG.log(Level.FINE, "Could not publish Route Adv from query - discard", e);
                return 0;
            }
        }
        if (pId == null) {
            if (!Logging.SHOW_FINE) return 0;
            if (!LOG.isLoggable(Level.FINE)) return 0;
            LOG.fine("Malformed route query request, no PeerId - discard");
            return 0;
        }
        EndpointAddress qReqAddr = EndpointRouter.pid2addr(pId);
        boolean found = false;
        if (qReqAddr.equals(this.localPeerAddr)) {
            found = true;
            route = this.router.getMyLocalRoute();
        } else if (this.router.isLocalRoute(qReqAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Peer has direct route to destination ");
            }
            found = true;
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            route.setDest(ap);
        } else {
            route = this.router.getRoute(qReqAddr, false);
            if (route != null) {
                found = true;
                for (PeerID aBadHop : badHops) {
                    if (EndpointRouter.addr2pid(qReqAddr).equals(aBadHop)) {
                        this.processBadRoute(aBadHop, route);
                        found = false;
                        break;
                    }
                    if (!route.containsHop(aBadHop)) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Peer has bad route due to " + aBadHop);
                    }
                    this.processBadRoute(aBadHop, route);
                    found = false;
                    break;
                }
            }
        }
        if (!found) {
            List<PeerID> results;
            if (!this.group.isRendezvous()) {
                if (!Logging.SHOW_FINE) return 0;
                if (!LOG.isLoggable(Level.FINE)) return 0;
                LOG.fine("discard query forwarding as not a rendezvous");
                return 0;
            }
            if (query.getHopCount() < 2 && (results = this.srdiIndex.query("route", "DstPID", pId.toString(), 10)).size() > 0) {
                List<PeerID> clean;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("processQuery srdiIndex lookup match :" + results.size());
                }
                if ((clean = this.cleanupAnyEdges(query.getSrcPeer(), results)).size() > 0) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("found an srdi entry forwarding query to SRDI peer");
                    }
                    query.incrementHopCount();
                    this.srdi.forwardQuery(clean, query, 1);
                    return 0;
                }
            }
            if (!Logging.SHOW_FINE) return -1;
            if (!LOG.isLoggable(Level.FINE)) return -1;
            LOG.fine("did not find a route or SRDI index");
            return -1;
        }
        try {
            RouteAdvertisement myRoute;
            if (route == null) {
                if (!Logging.SHOW_FINE) return 0;
                if (!LOG.isLoggable(Level.FINE)) return 0;
                LOG.fine("we should have had a route at this point");
                return 0;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("we have a route build route response" + route.display());
            }
            if ((myRoute = this.router.getMyLocalRoute()) == null) {
                return 0;
            }
            RouteResponse routeResponse = new RouteResponse();
            routeResponse.setDestRoute(route);
            routeResponse.setSrcRoute(myRoute);
            if (routeResponse == null) {
                if (!Logging.SHOW_FINE) return 0;
                if (!LOG.isLoggable(Level.FINE)) return 0;
                LOG.fine("error creating route response");
                return 0;
            }
            ResolverResponseMsg res = query.makeResponse();
            CurrentCredential current = this.currentCredential;
            if (null != current) {
                res.setCredential(current.credentialDoc);
            }
            res.setResponse(routeResponse.toString());
            this.resolver.sendResponse(query.getSrcPeer().toString(), res);
            return 0;
        }
        catch (Exception ee) {
            if (!Logging.SHOW_FINE) return 0;
            if (!LOG.isLoggable(Level.FINE)) return 0;
            LOG.log(Level.FINE, "processQuery: error while processing query ", ee);
            return 0;
        }
    }

    protected void generateNACKRoute(PeerID src, PeerID dest, Vector<AccessPointAdvertisement> origHops) {
        if (this.resolver == null) {
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("generate NACK Route response " + src);
        }
        if (this.router.isPendingRouteQuery(src)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("drop NACK due to pending route discovery " + src);
            }
            return;
        }
        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ap.setPeerID(dest);
        route.setDest(ap);
        route.setHops(origHops);
        RouteAdvertisement routeSrc = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement apSrc = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        apSrc.setPeerID((PeerID)this.localPeerId);
        routeSrc.setDest(apSrc);
        RouteResponse routeResponse = new RouteResponse();
        routeResponse.setDestRoute(route);
        routeResponse.setSrcRoute(routeSrc);
        ResolverResponse res = new ResolverResponse();
        res.setHandlerName(routerSName);
        CurrentCredential current = this.currentCredential;
        if (null != current) {
            res.setCredential(current.credentialDoc);
        }
        res.setQueryId(-1);
        res.setResponse(routeResponse.toString());
        this.resolver.sendResponse(src.toString(), res);
    }

    @Override
    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        if (!this.group.isRendezvous()) {
            return true;
        }
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received a SRDI messsage in group" + this.group.getPeerGroupName());
            }
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "corrupted SRDI message", e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        if (pid.equals(this.localPeerId)) {
            return false;
        }
        for (SrdiMessage.Entry entry : srdiMsg.getEntries()) {
            if (entry.key.equals(this.localPeerId.toString())) continue;
            String value = entry.value;
            if (value == null) {
                value = "";
            }
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), "DstPID", entry.key, pid, entry.expiration);
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [RouteAdvertisement.DEST_PID_TAG]" + " value [" + entry.key + "] exp [" + entry.expiration + "]");
        }
        return true;
    }

    @Override
    public void pushEntries(boolean all) {
        this.pushSrdi(null, all);
    }

    protected void pushSrdi(String peer, boolean all) {
        block5: {
            Vector<SrdiMessage.Entry> routeIx = new Vector<SrdiMessage.Entry>();
            Iterator<ID> each = this.router.getAllRoutedRouteAddresses();
            while (each.hasNext()) {
                ID pid = each.next();
                SrdiMessage.Entry entry = new SrdiMessage.Entry(pid.toString(), "", Long.MAX_VALUE);
                routeIx.addElement(entry);
            }
            try {
                if (routeIx.size() == 0) {
                    return;
                }
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", routeIx);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sending a SRDI messsage of [All=" + all + "] routes");
                }
                this.srdi.replicateEntries(srdiMsg);
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "SRDI Push failed", e);
            }
        }
    }

    protected void pushSrdi(ID peer, PeerID id) {
        block5: {
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, Long.MAX_VALUE);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("sending a router SRDI message add route " + id);
                }
                if (peer == null) {
                    PeerID destPeer = this.srdi.getReplicaPeer(id.toString());
                    peer = destPeer;
                }
                if (!this.localPeerId.equals(peer)) {
                    this.srdi.pushSrdi(peer, srdiMsg);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block5;
                LOG.log(Level.WARNING, "SRDI push failed", e);
            }
        }
    }

    protected void removeSrdi(String peer, PeerID id) {
        block4: {
            try {
                PeerID destPeer;
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, 0L);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("sending a router SRDI message delete route " + id);
                }
                if (peer == null && (destPeer = this.srdi.getReplicaPeer(id.toString())) != null && !destPeer.equals(this.localPeerId)) {
                    this.srdi.pushSrdi(destPeer, srdiMsg);
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block4;
                LOG.log(Level.FINE, "Removing srdi entry failed", e);
            }
        }
    }

    @Override
    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        this.removeSrdiIndex(peerid);
    }

    protected List<PeerID> cleanupAnyEdges(ID src, List<PeerID> results) {
        ArrayList<PeerID> clean = new ArrayList<PeerID>(results.size());
        Vector<PeerID> rpvId = this.srdi.getGlobalPeerView();
        for (PeerID pid : results) {
            if (src.equals(pid) || this.localPeerId.equals(pid)) continue;
            if (rpvId.contains(pid)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("valid rdv for SRDI forward " + pid);
                }
                clean.add(pid);
                continue;
            }
            this.srdiIndex.remove(pid);
        }
        return clean;
    }

    protected void removeSrdiIndex(PeerID pid) {
        this.srdiIndex.remove(pid);
    }

    private class CredentialListener
    implements PropertyChangeListener {
        CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New default credential event");
                }
                RouteResolver routeResolver = RouteResolver.this;
                synchronized (routeResolver) {
                    Credential cred = (Credential)evt.getNewValue();
                    if (null != cred) {
                        try {
                            XMLDocument credentialDoc = (XMLDocument)cred.getDocument(MimeMediaType.XMLUTF8);
                            RouteResolver.this.currentCredential = new CurrentCredential(cred, credentialDoc);
                        }
                        catch (Exception all) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Could not generate credential document", all);
                            }
                            RouteResolver.this.currentCredential = null;
                        }
                    } else {
                        RouteResolver.this.currentCredential = null;
                    }
                }
            }
        }
    }

    static final class CurrentCredential {
        final Credential credential;
        final XMLDocument credentialDoc;

        CurrentCredential(Credential credential, XMLDocument credentialDoc) {
            this.credential = credential;
            this.credentialDoc = credentialDoc;
        }
    }
}

