/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.relay.RelayServer;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

class RelayServerClient
implements Runnable {
    private static final Logger LOG = Logger.getLogger(RelayServerClient.class.getName());
    private static long stallTimeout = 0L;
    private final RelayServer server;
    private final String clientPeerId;
    private long leaseLength = 0L;
    private final EndpointAddress clientAddr;
    private volatile long expireTime = 0L;
    private boolean isClosed = false;
    private final BlockingQueue<Message> messageList;
    private final EndpointService endpoint;
    private Messenger messenger = null;
    private Thread thread = null;
    private boolean thread_idle = false;
    private Message outOfBandMessage = null;

    protected RelayServerClient(RelayServer server, String clientPeerId, long leaseLength, long stallTimeout, int clientQueueSize) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("new Client peerId=" + clientPeerId + " lease=" + leaseLength);
        }
        this.server = server;
        this.clientPeerId = clientPeerId;
        this.leaseLength = leaseLength;
        RelayServerClient.stallTimeout = stallTimeout;
        this.clientAddr = new EndpointAddress("jxta", clientPeerId, null, null);
        this.endpoint = server.getEndpointService();
        this.messageList = new ArrayBlockingQueue<Message>(clientQueueSize);
        this.renewLease();
    }

    protected void finalize() throws Throwable {
        this.closeClient();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("send queued messages to " + this.clientAddr);
        }
        try {
            int failedInARow = 0;
            while (true) {
                Messenger holdIt;
                Message message = null;
                RelayServerClient relayServerClient = this;
                synchronized (relayServerClient) {
                    if (this.messenger == null || this.messenger.isClosed()) {
                        long newExpireTime;
                        this.messenger = null;
                        if (!(this.outOfBandMessage == null && this.messageList.isEmpty() || this.expireTime <= (newExpireTime = TimeUtils.toAbsoluteTimeMillis(stallTimeout)))) {
                            this.expireTime = newExpireTime;
                        }
                        this.thread = null;
                        break;
                    }
                    if (this.outOfBandMessage != null) {
                        message = this.outOfBandMessage;
                        this.outOfBandMessage = null;
                    } else {
                        message = this.messageList.poll(0L, TimeUnit.MILLISECONDS);
                        if (message == null) {
                            try {
                                this.thread_idle = true;
                                this.wait(4000L);
                                if (this.outOfBandMessage != null) {
                                    message = this.outOfBandMessage;
                                    this.outOfBandMessage = null;
                                } else {
                                    message = this.messageList.poll(0L, TimeUnit.MILLISECONDS);
                                }
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            if (message == null) {
                                this.thread = null;
                                break;
                            }
                        }
                    }
                    holdIt = this.messenger;
                    this.thread_idle = false;
                }
                MessageElement dstAddressElement = message.getMessageElement("jxta", "EndpointDestinationAddress");
                if (null == dstAddressElement) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("message destination was not set");
                    continue;
                }
                EndpointAddress destAddr = new EndpointAddress(dstAddressElement.toString());
                try {
                    holdIt.sendMessageB(message, destAddr.getServiceName(), destAddr.getServiceParameter());
                    RelayServerClient relayServerClient2 = this;
                    synchronized (relayServerClient2) {
                        failedInARow = 0;
                        if (!this.isClosed) {
                            this.expireTime = TimeUtils.toAbsoluteTimeMillis(this.leaseLength);
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    RelayServerClient relayServerClient3 = this;
                    synchronized (relayServerClient3) {
                        if (++failedInARow >= 3) {
                            failedInARow = 0;
                            if (!this.isClosed) {
                                this.expireTime = TimeUtils.toAbsoluteTimeMillis(this.leaseLength);
                            }
                            continue;
                        }
                        if (this.outOfBandMessage == null) {
                            this.outOfBandMessage = message;
                        }
                    }
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.INFO, "closing messenger after exception :" + this.clientAddr, e);
                    }
                    holdIt.close();
                    continue;
                }
                break;
            }
        }
        catch (Throwable all) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
            }
        }
        finally {
            this.thread = null;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("stopped sending queued messages for " + this.clientAddr);
            }
        }
    }

    public String toString() {
        return this.clientPeerId + "," + this.messageList.size() + "," + (this.messenger == null ? "-m" : "+m") + "," + TimeUtils.toRelativeTimeMillis(this.expireTime, TimeUtils.timeNow());
    }

    protected int getQueueSize() {
        return this.messageList.size();
    }

    public long getLeaseRemaining() {
        return TimeUtils.toRelativeTimeMillis(this.expireTime, TimeUtils.timeNow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClient() {
        Messenger messengerToClose;
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Terminating client:\n\tclient=" + this.clientAddr + "\tnbMessages=" + this.messageList.size() + "\tmessenger=" + this.messenger + (this.messenger == null ? "" : "(c:" + this.messenger.isClosed() + ")") + "\tlease-left=" + TimeUtils.toRelativeTimeMillis(this.expireTime, TimeUtils.timeNow()) + "\tt=" + (this.thread != null));
            }
            messengerToClose = this.messenger;
            this.expireTime = 0L;
            this.messenger = null;
            this.messageList.clear();
        }
        this.server.removeClient(this.clientPeerId, this);
        if (messengerToClose != null) {
            messengerToClose.close();
        }
    }

    synchronized void flushQueue() {
        this.messageList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessenger(Messenger newMessenger) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("addMessenger() " + newMessenger);
        }
        if (newMessenger == null || newMessenger.isClosed()) {
            return false;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("messenger (" + this.messenger + ") thread=" + this.thread);
        }
        Messenger messengerToClose = newMessenger;
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (!this.isClosed) {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO) && this.messenger != null) {
                    LOG.info("closing messenger replaced by a new one : " + this.clientAddr);
                }
                messengerToClose = this.messenger;
                this.messenger = newMessenger;
                if (!(this.thread != null && !this.thread_idle || this.messageList.isEmpty() && this.outOfBandMessage == null)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("messageList.size() = " + this.messageList.size() + " client=" + this.clientAddr);
                    }
                    if (this.thread != null) {
                        this.notify();
                    } else {
                        this.thread = new Thread(this.server.group.getHomeThreadGroup(), this, "Draining queue to " + this.clientAddr);
                        this.thread.setDaemon(true);
                        this.thread.start();
                    }
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("messenger (" + this.messenger + ") thread=" + this.thread);
                }
            }
        }
        if (messengerToClose != null) {
            messengerToClose.close();
        }
        return true;
    }

    public boolean isExpired() {
        boolean isExpired;
        boolean bl = isExpired = TimeUtils.timeNow() > this.expireTime;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("isExpired() = " + isExpired + " client=" + this.clientAddr);
        }
        if (isExpired) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Closing expired client : " + this.clientAddr);
            }
            this.closeClient();
        }
        return isExpired;
    }

    public synchronized boolean renewLease() {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("renewLease() old expireTime = " + this.expireTime);
        }
        if (this.isClosed) {
            return false;
        }
        if (!this.messageList.isEmpty()) {
            return true;
        }
        this.expireTime = TimeUtils.toAbsoluteTimeMillis(this.leaseLength);
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("renewLease() new expireTime = " + this.expireTime);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessage(Message message, boolean outOfBand) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("queueMessage (" + this.messageList.size() + ") client=" + this.clientAddr);
        }
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (this.isClosed) {
                throw new IOException("Client has been disconnected");
            }
            if (outOfBand) {
                this.outOfBandMessage = message;
            } else if (!this.messageList.offer(message) && Logging.SHOW_WARNING) {
                LOG.warning("Dropping relayed message " + message.toString() + " for peer " + this.clientPeerId);
            }
            if (this.thread == null || this.thread_idle) {
                if (this.messenger == null) {
                    long newExpireTime = TimeUtils.toAbsoluteTimeMillis(stallTimeout);
                    if (this.expireTime > newExpireTime) {
                        this.expireTime = newExpireTime;
                    }
                } else if (this.thread != null) {
                    this.notify();
                } else {
                    this.thread = new Thread(this.server.group.getHomeThreadGroup(), this, "Draining queue to " + this.clientAddr);
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("done queueMessage (" + this.messageList.size() + ") client=" + this.clientAddr);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("messenger (" + this.messenger + ") thread=" + this.thread);
        }
    }

    protected EndpointAddress getClientAddress() {
        return this.clientAddr;
    }

    protected Messenger getMessenger(EndpointAddress srcAddr, EndpointAddress destAddr, boolean outOfBand) {
        return new RelayMessenger(srcAddr, destAddr, this, outOfBand);
    }

    protected static class RelayMessenger
    extends BlockingMessenger {
        private final MessageElement srcAddressElement;
        private final RelayServerClient handler;
        private boolean outOfBand = false;
        private final String defaultServiceName;
        private final String defaultServiceParam;

        public RelayMessenger(EndpointAddress srcAddress, EndpointAddress destAddress, RelayServerClient handler, boolean outOfBand) {
            super(((RelayServerClient)handler).server.group.getPeerGroupID(), destAddress, false);
            this.defaultServiceName = destAddress.getServiceName();
            this.defaultServiceParam = destAddress.getServiceParameter();
            this.handler = handler;
            this.outOfBand = outOfBand;
            this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddress.toString(), null);
        }

        public boolean isIdleImpl() {
            return false;
        }

        public void closeImpl() {
        }

        public EndpointAddress getLogicalDestinationImpl() {
            return this.handler.getClientAddress();
        }

        public void sendMessageBImpl(Message message, String serviceName, String serviceParam) throws IOException {
            message.replaceMessageElement("jxta", this.srcAddressElement);
            EndpointAddress destAddressToUse = this.getDestAddressToUse(serviceName, serviceParam);
            StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), null);
            message.replaceMessageElement("jxta", dstAddressElement);
            this.handler.queueMessage(message.clone(), this.outOfBand);
        }
    }
}

