/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.access.always;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.credential.Credential;
import net.jxta.credential.PrivilegedOperation;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

public class AlwaysAccessService
implements AccessService {
    private static final Logger LOG = Logger.getLogger(AlwaysAccessService.class.getName());
    PeerGroup group;
    ModuleImplAdvertisement implAdvertisement;

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        this.group = group;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Always Access Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.config(configInfo.toString());
        }
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public AlwaysAccessService getInterface() {
        return this;
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    public AccessService.AccessResult doAccessCheck(PrivilegedOperation op, Credential cred) {
        if (null == cred) {
            return null == op ? AccessService.AccessResult.PERMITTED : ("DENY".equals(op.getSubject()) ? AccessService.AccessResult.DISALLOWED : AccessService.AccessResult.PERMITTED);
        }
        if (!cred.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if ("DENY".equals(cred.getSubject())) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (null == op) {
            return AccessService.AccessResult.PERMITTED;
        }
        if (!op.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        return "DENY".equals(op.getSubject()) ? AccessService.AccessResult.DISALLOWED : AccessService.AccessResult.PERMITTED;
    }

    public PrivilegedOperation newPrivilegedOperation(Object subject, Credential offerer) {
        if (!(subject instanceof String)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports String subjects.");
        }
        if (!offerer.isValid()) {
            throw new IllegalArgumentException("offerer is not a valid credential");
        }
        return new AlwaysOperation(this, (String)subject, offerer);
    }

    public PrivilegedOperation newPrivilegedOperation(Element source) {
        return new AlwaysOperation(this, source);
    }

    private static class AlwaysOperation
    implements PrivilegedOperation {
        AlwaysAccessService source;
        String op;
        Credential offerer;

        protected AlwaysOperation(AlwaysAccessService source, String op, Credential offerer) {
            this.source = source;
            this.op = op;
            this.offerer = offerer;
        }

        protected AlwaysOperation(AlwaysAccessService source, Element root) {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public Object getSubject() {
            return this.op;
        }

        public Service getSourceService() {
            return this.source;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:AlwaysOp");
            }
            Object e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("Operation", this.op);
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, doc, this.offerer.getDocument(as), "Offerer");
            return doc;
        }

        public Credential getOfferer() {
            return this.offerer;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URI gID = new URI(elem.getTextValue().trim());
                    ID pgid = IDFactory.fromURI(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Operation")) {
                this.op = elem.getTextValue();
                return true;
            }
            if (elem.getName().equals("Offerer")) {
                try {
                    this.offerer = this.source.getPeerGroup().getMembershipService().makeCredential(elem);
                }
                catch (Throwable failed) {
                    throw new IllegalArgumentException("Offerer credential could not be constructed" + failed);
                }
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!TextElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:AlwaysOp") && !doctype.equals("jxta:Cred") || !"jxta:AlwaysOp".equals(typedoctype)) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandleded element '" + elem.getName() + "' in " + doc.getName());
            }
            if (null == this.op) {
                throw new IllegalArgumentException("operation was never initialized.");
            }
            if (null == this.offerer) {
                throw new IllegalArgumentException("offerer was never initialized.");
            }
        }
    }
}

