/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class MimeMediaType
implements Serializable {
    private static final long serialVersionUID = 7546247036878523161L;
    private static final String CTL = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f";
    private static final String space = " ";
    private static final String LWSP_char = " \t";
    private static final String param_sep = " \t;";
    private static final String tspecials = "()<>@,;:\\\"/[]?=";
    private static final String terminator = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f ()<>@,;:\\\"/[]?=";
    private static final Map<MimeMediaType, Reference<MimeMediaType>> interned = new WeakHashMap<MimeMediaType, Reference<MimeMediaType>>();
    public static final MimeMediaType AOS = new MimeMediaType("application", "octet-stream").intern();
    public static final MimeMediaType TEXT_DEFAULTENCODING = new MimeMediaType("text", "plain").intern();
    public static final MimeMediaType TEXTUTF8 = new MimeMediaType("text", "plain", "charset=\"UTF-8\"").intern();
    public static final MimeMediaType XML_DEFAULTENCODING = new MimeMediaType("text", "xml").intern();
    public static final MimeMediaType APPLICATION_XML_DEFAULTENCODING = new MimeMediaType("application", "xml").intern();
    public static final MimeMediaType XMLUTF8 = new MimeMediaType("text", "xml", "charset=\"UTF-8\"").intern();
    private transient String type = null;
    private transient String subtype = null;
    private transient List<parameter> parameters = new ArrayList<parameter>();
    private transient int cachedHashCode = 0;

    public MimeMediaType(String mimetype) {
        String cleaned = mimetype.trim();
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("input cannot be empty");
        }
        int typeSepAt = MimeMediaType.findNextSeperator(cleaned);
        if (-1 == typeSepAt || 0 == typeSepAt || '/' != cleaned.charAt(typeSepAt)) {
            throw new IllegalArgumentException("expected seperator or seperator in unexpected location");
        }
        this.setType(cleaned.substring(0, typeSepAt));
        int subtypeSepAt = MimeMediaType.findNextSeperator(cleaned, typeSepAt + 1);
        String itsParams = "";
        if (-1 == subtypeSepAt) {
            this.setSubtype(cleaned.substring(typeSepAt + 1));
        } else {
            this.setSubtype(cleaned.substring(typeSepAt + 1, subtypeSepAt));
            itsParams = cleaned.substring(subtypeSepAt);
        }
        this.parseParams(itsParams, false);
    }

    public MimeMediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    public MimeMediaType(String type, String subtype, String parameters) {
        this.setType(type);
        this.setSubtype(subtype);
        if (null != parameters) {
            this.parseParams(parameters, false);
        }
    }

    public MimeMediaType(MimeMediaType type, String params, boolean replace) {
        this.setType(type.getType());
        this.setSubtype(type.getSubtype());
        this.parameters.addAll(type.parameters);
        this.parseParams(params, replace);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MimeMediaType)) {
            return false;
        }
        MimeMediaType asMMT = (MimeMediaType)obj;
        if (!this.type.equalsIgnoreCase(asMMT.type)) {
            return false;
        }
        if (!this.subtype.equalsIgnoreCase(asMMT.subtype)) {
            return false;
        }
        ArrayList<parameter> myParams = new ArrayList<parameter>(this.parameters);
        ArrayList<parameter> itsParams = new ArrayList<parameter>(asMMT.parameters);
        Collections.sort(myParams);
        Collections.sort(itsParams);
        return ((Object)myParams).equals(itsParams);
    }

    public boolean equalsIngoringParams(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MimeMediaType)) {
            return false;
        }
        MimeMediaType likeMe = (MimeMediaType)obj;
        boolean retValue = this.getType().equalsIgnoreCase(likeMe.getType()) && this.getSubtype().equalsIgnoreCase(likeMe.getSubtype());
        return retValue;
    }

    public int hashCode() {
        if (0 == this.cachedHashCode) {
            ArrayList<parameter> myParams = new ArrayList<parameter>(this.parameters);
            Collections.sort(myParams);
            int calcedHash = this.type.hashCode() * 2467 + this.subtype.hashCode() * 3943 + ((Object)myParams).hashCode();
            this.cachedHashCode = 0 != calcedHash ? calcedHash : 1;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder retValue = new StringBuilder(this.getMimeMediaType());
        for (parameter parameter2 : this.parameters) {
            retValue.append(';');
            parameter aParam = parameter2;
            retValue.append(aParam.toString());
        }
        return retValue.toString();
    }

    public MimeMediaType getBaseMimeMediaType() {
        return new MimeMediaType(this.type, this.subtype).intern();
    }

    public String getMimeMediaType() {
        StringBuilder retValue = new StringBuilder(this.type.length() + 1 + this.subtype.length());
        retValue.append(this.type);
        retValue.append('/');
        retValue.append(this.subtype);
        return retValue.toString();
    }

    public String getType() {
        return this.type;
    }

    public boolean isExperimentalType() {
        if (null == this.type || this.type.length() < 2) {
            return false;
        }
        if (this.type.startsWith("x-") || this.type.startsWith("x.")) {
            return true;
        }
        return null != this.subtype && this.subtype.length() >= 2 && (this.subtype.startsWith("x-") || this.subtype.startsWith("x."));
    }

    private void setType(String type) {
        if (null == type) {
            throw new IllegalArgumentException("type cannot be null");
        }
        String cleaned = type.trim().toLowerCase(Locale.US);
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (-1 != MimeMediaType.findNextSeperator(cleaned)) {
            throw new IllegalArgumentException("type cannot contain a seperator");
        }
        this.type = cleaned;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isExperimentalSubtype() {
        if (null == this.subtype || this.subtype.length() < 2) {
            return false;
        }
        return 'x' == this.subtype.charAt(0) && '-' == this.subtype.charAt(1);
    }

    private void setSubtype(String subtype) {
        if (null == subtype) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        String cleaned = subtype.trim().toLowerCase(Locale.US);
        if (0 == cleaned.length()) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (-1 != MimeMediaType.findNextSeperator(cleaned)) {
            throw new IllegalArgumentException("subtype cannot contain a seperator");
        }
        this.subtype = cleaned;
    }

    public String getParameter(String param) {
        Iterator<parameter> i$ = this.parameters.iterator();
        while (i$.hasNext()) {
            parameter parameter2;
            parameter aParam = parameter2 = i$.next();
            if (!aParam.attribute.equalsIgnoreCase(param)) continue;
            return aParam.value;
        }
        return null;
    }

    private void parseParams(String itsParams, boolean replace) {
        int currentCharIdx;
        String currentAttribute = null;
        boolean inSeperator = true;
        boolean inComment = false;
        boolean inAttribute = false;
        StringBuffer currentValue = null;
        boolean inValue = false;
        boolean inQuoted = false;
        boolean nextEscaped = false;
        for (currentCharIdx = 0; currentCharIdx < itsParams.length(); ++currentCharIdx) {
            char currentChar = itsParams.charAt(currentCharIdx);
            if (inSeperator) {
                if ('(' == currentChar) {
                    inSeperator = false;
                    inComment = true;
                    continue;
                }
                if (-1 != param_sep.indexOf(currentChar)) continue;
                inSeperator = false;
                inAttribute = true;
                --currentCharIdx;
                continue;
            }
            if (inComment) {
                if (nextEscaped) {
                    nextEscaped = false;
                    continue;
                }
                if ('\\' == currentChar) {
                    nextEscaped = true;
                    continue;
                }
                if (')' == currentChar) {
                    inComment = false;
                    inSeperator = true;
                    continue;
                }
                if ('\r' != currentChar) continue;
                throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
            }
            if (inAttribute) {
                int endAttr = MimeMediaType.findNextSeperator(itsParams, currentCharIdx);
                if (-1 == endAttr || '=' != itsParams.charAt(endAttr) || 0 == endAttr - currentCharIdx) {
                    throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
                }
                currentAttribute = itsParams.substring(currentCharIdx, endAttr).toLowerCase(Locale.US);
                currentCharIdx = endAttr;
                inAttribute = false;
                inValue = true;
                inQuoted = false;
                nextEscaped = false;
                currentValue = new StringBuffer();
                continue;
            }
            if (inValue) {
                if (inQuoted) {
                    if (nextEscaped) {
                        currentValue.append(currentChar);
                        nextEscaped = false;
                        continue;
                    }
                    if ('\\' == currentChar) {
                        nextEscaped = true;
                        continue;
                    }
                    if ('\"' == currentChar) {
                        inQuoted = false;
                        continue;
                    }
                    if ('\r' == currentChar) {
                        throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
                    }
                    currentValue.append(currentChar);
                    continue;
                }
                if (-1 == terminator.indexOf(currentChar)) {
                    currentValue.append(currentChar);
                    continue;
                }
                if ('\"' == currentChar) {
                    inQuoted = true;
                    continue;
                }
                parameter newparam = new parameter(currentAttribute, currentValue.toString());
                if (replace) {
                    while (this.parameters.remove(newparam)) {
                    }
                }
                this.parameters.add(newparam);
                inValue = false;
                inSeperator = true;
                --currentCharIdx;
                continue;
            }
            throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
        }
        if (inValue) {
            if (nextEscaped || inQuoted) {
                throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
            }
            parameter newparam = new parameter(currentAttribute, currentValue.toString());
            if (replace) {
                while (this.parameters.remove(newparam)) {
                }
            }
            this.parameters.add(newparam);
            inValue = false;
            inSeperator = true;
        }
        if (!inSeperator) {
            throw new IllegalArgumentException("malformed mime parameter at idx = " + currentCharIdx);
        }
    }

    private static int findNextSeperator(String source) {
        return MimeMediaType.findNextSeperator(source, 0);
    }

    private static int findNextSeperator(String source, int from) {
        int seperator = -1;
        for (int eachChar = from; eachChar < source.length(); ++eachChar) {
            if (-1 == terminator.indexOf(source.charAt(eachChar))) continue;
            seperator = eachChar;
            break;
        }
        return seperator;
    }

    public static MimeMediaType valueOf(String mimetype) {
        return new MimeMediaType(mimetype).intern();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        MimeMediaType readType = MimeMediaType.valueOf(s.readUTF());
        this.type = readType.type;
        this.subtype = readType.subtype;
        this.parameters = readType.parameters;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.intern();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMediaType intern() {
        Class<MimeMediaType> clazz = MimeMediaType.class;
        synchronized (MimeMediaType.class) {
            MimeMediaType result;
            Reference<MimeMediaType> common = interned.get(this);
            if (null == common) {
                common = new WeakReference<MimeMediaType>(this);
                interned.put(this, common);
                result = this;
            } else {
                result = common.get();
                if (null == result) {
                    interned.put(this, new WeakReference<MimeMediaType>(this));
                    result = this;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class parameter
    implements Comparable<parameter> {
        final String attribute;
        final String value;

        parameter(String attr, String val) {
            this.attribute = attr;
            this.value = val;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof parameter)) {
                return false;
            }
            parameter asParameter = (parameter)obj;
            return this.attribute.equalsIgnoreCase(asParameter.attribute) && asParameter.value.equals(this.value);
        }

        public int hashCode() {
            return this.attribute.toLowerCase().hashCode() * 6037 + this.value.hashCode();
        }

        public String toString() {
            return this.attribute + "=" + parameter.outputForm(this.value);
        }

        @Override
        public int compareTo(parameter asParameter) {
            if (this == asParameter) {
                return 0;
            }
            int result = this.attribute.compareToIgnoreCase(asParameter.attribute);
            if (0 != result) {
                return result;
            }
            return this.value.compareTo(asParameter.value);
        }

        private static String outputForm(String val) {
            StringBuilder result = new StringBuilder();
            if (-1 == MimeMediaType.findNextSeperator(val)) {
                result.append(val);
            } else {
                result.append('\"');
                for (int eachChar = 0; eachChar < val.length(); ++eachChar) {
                    char aChar = val.charAt(eachChar);
                    if ('\\' == aChar || '\"' == aChar || '\r' == aChar) {
                        result.append('\\');
                    }
                    result.append(aChar);
                }
                result.append('\"');
            }
            return result.toString();
        }
    }
}

