/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthMessage {
    private List<Entry> entries;
    private PeerID srcID;
    private static final String entryTag = "Entry";
    private static final String srcTag = "src";
    private static final String stateTag = "state";

    public HealthMessage() {
    }

    public HealthMessage(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (InputStream)stream);
        this.initialize((TextElement)doc);
    }

    public HealthMessage(PeerID srcID, List<Entry> entries) {
        this.srcID = srcID;
        this.entries = entries;
    }

    public HealthMessage(Element root) {
        TextElement doc = (TextElement)root;
        if (!HealthMessage.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.initialize(doc);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)asMimeType, (String)HealthMessage.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)adv).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Element e = adv.createElement((Object)srcTag, (Object)this.getSrcID().toString());
        adv.appendChild(e);
        Iterator<Entry> i$ = this.entries.iterator();
        while (i$.hasNext()) {
            Entry entry1;
            Entry entry = entry1 = i$.next();
            if (entry.id == null && entry.state == null) continue;
            e = adv.createElement((Object)entryTag);
            adv.appendChild(e);
            ((Attributable)e).addAttribute(stateTag, entry.state);
            StructuredTextDocument doc = (StructuredTextDocument)entry.adv.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements((StructuredDocument)adv, (Element)e, (Element)doc);
        }
        return adv;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public PeerID getSrcID() {
        return this.srcID;
    }

    private void initialize(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(srcTag)) {
                try {
                    URI id = new URI(elem.getTextValue());
                    this.setSrcID((PeerID)IDFactory.fromURI((URI)id));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("unknown ID format in advertisement: " + badID.getLocalizedMessage() + ' ' + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a known id type: " + badID.getLocalizedMessage() + ' ' + elem.getTextValue());
                }
            }
            if (!elem.getName().equals(entryTag)) continue;
            String state = "NA";
            Attribute stateAttr = ((Attributable)elem).getAttribute(stateTag);
            if (stateAttr != null) {
                state = stateAttr.getValue();
            }
            Enumeration each = elem.getChildren();
            while (each.hasMoreElements()) {
                SystemAdvertisement adv = new SystemAdvertisement((Element)((TextElement)each.nextElement()));
                Entry entry = new Entry(adv, state);
                this.add(entry);
            }
        }
        this.setEntries(this.entries);
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public void add(Entry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        }
    }

    public void remove(Entry entry) {
        if (this.entries.contains(entry)) {
            this.entries.remove(this.entries.indexOf(entry));
        }
    }

    public void setSrcID(PeerID id) {
        this.srcID = id == null ? null : id;
    }

    public String toString() {
        StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
        return doc.toString();
    }

    public static String getAdvertisementType() {
        return "jxta:Health";
    }

    public static final class Entry {
        final PeerID id;
        final SystemAdvertisement adv;
        String state;
        long timestamp;

        public Entry(SystemAdvertisement adv, String state) {
            this.state = state;
            this.adv = adv;
            this.id = (PeerID)adv.getID();
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.id.equals(obj);
        }

        public int hashCode() {
            return this.adv.getID().hashCode() * 45191 + this.state.hashCode();
        }

        public String toString() {
            return "HealthMessage.Entry: Id = " + this.id.toString() + "; State = " + this.state + "; LastTimeStamp = " + this.timestamp;
        }
    }
}

