/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupManagementServiceImpl
implements GroupManagementService,
Runnable {
    private final GMSContext ctx;
    private Router router;
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";

    public GroupManagementServiceImpl(String serverToken, String groupName, GroupManagementService.MemberType membertype, Properties properties) {
        this.ctx = GMSContextFactory.produceGMSContext(serverToken, groupName, membertype, properties);
        this.router = this.ctx.getRouter();
    }

    @Override
    public void run() {
        this.startup();
    }

    private void startup() {
        try {
            logger.log(Level.INFO, "gms.joinMessage");
            this.join();
        }
        catch (GMSException e) {
            logger.log(Level.FINE, "gms.joinException", e);
        }
    }

    @Override
    public void addActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.addDestination(failureNotificationActionFactory);
    }

    @Override
    public void addActionFactory(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.router.addDestination(componentName, failureRecoveryActionFactory);
    }

    @Override
    public void addActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.addDestination(joinNotificationActionFactory);
    }

    @Override
    public void addActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.addDestination(plannedShutdownActionFactory);
    }

    @Override
    public void addActionFactory(MessageActionFactory messageActionFactory, String componentName) {
        this.router.addDestination(messageActionFactory, componentName);
    }

    @Override
    public void addActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.addDestination(failureSuspectedActionFactory);
    }

    @Override
    public void removeActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.removeDestination(failureNotificationActionFactory);
    }

    @Override
    public void removeFailureRecoveryActionFactory(String componentName) {
        this.router.removeFailureRecoveryAFDestination(componentName);
    }

    @Override
    public void removeFailureSuspectedActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.removeDestination(failureSuspectedActionFactory);
    }

    @Override
    public void removeActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.removeDestination(joinNotificationActionFactory);
    }

    @Override
    public void removeActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.removeDestination(plannedShutdownActionFactory);
    }

    @Override
    public void removeMessageActionFactory(String componentName) {
        this.router.removeMessageAFDestination(componentName);
    }

    @Override
    public GroupHandle getGroupHandle() {
        return this.ctx.getGroupHandle();
    }

    @Override
    public void shutdown(GMSConstants.shutdownType shutdownType2) {
        this.leave(shutdownType2);
    }

    @Override
    public void updateMemberDetails(String memberToken, Serializable key, Serializable value) throws GMSException {
        this.ctx.getDistributedStateCache().addToCache(MEMBER_DETAILS, memberToken, key, value);
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails(String memberToken) {
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, memberToken);
    }

    @Override
    public Map<Serializable, Serializable> getAllMemberDetails(Serializable key) {
        HashMap<Serializable, Serializable> retval = new HashMap<Serializable, Serializable>();
        Map<GMSCacheable, Object> ret = this.ctx.getDistributedStateCache().getFromCache(key);
        for (GMSCacheable c : ret.keySet()) {
            if (!c.getComponentName().equals(MEMBER_DETAILS)) continue;
            retval.put((Serializable)((Object)c.getMemberTokenId()), (Serializable)ret.get(c));
        }
        return retval;
    }

    public void setMemberDetails(String serverToken, Map<? extends Object, ? extends Object> keyValuePairs) throws GMSException {
        for (Object object : keyValuePairs.keySet()) {
            this.ctx.getDistributedStateCache().addToLocalCache(MEMBER_DETAILS, serverToken, (Serializable)object, (Serializable)keyValuePairs.get(object));
        }
    }

    @Override
    public void join() throws GMSException {
        logger.log(Level.FINE, "Connecting to group......");
        this.ctx.join();
    }

    private void leave(GMSConstants.shutdownType shutdownType2) {
        logger.log(Level.FINE, "Deregistering ActionFactory instances...");
        this.removeAllActionFactories();
        this.ctx.leave(shutdownType2);
        GMSContextFactory.removeGMSContext(this.ctx.getGroupName());
    }

    private void removeAllActionFactories() {
        this.router.undocketAllDestinations();
    }

    @Override
    public void announceGroupShutdown(String groupName, GMSConstants.shutdownState shutdownState2) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        logger.log(Level.FINE, "GMS:Announcing GroupShutdown to group with State=" + (Object)((Object)shutdownState2));
        gctx.announceGroupShutdown(groupName, shutdownState2);
    }
}

