/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogService
extends BaseElement {
    public void transform(Element element, Element parentSource, Element parentResult) {
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.transformingMSG", (Object)this.getClass().getName(), (Object)element.getTagName()));
        NodeList logServs = parentResult.getElementsByTagName("log-service");
        Element logService = null;
        this.logger.log(Level.FINE, this.getClass().getName() + ":: logServs.getLength() ", logServs.getLength());
        if (logServs.getLength() == 0) {
            logService = parentResult.getOwnerDocument().createElement("log-service");
            this.transferAttributes(element, logService, null);
            this.appendElementToParent(parentResult, logService);
        } else {
            logService = (Element)logServs.item(0);
            this.transferAttributes(element, logService, null);
        }
        super.transform(element, parentSource, logService);
    }

    protected void transferAttributes(Element source, Element result, List nonTransferList) {
        if (commonInfoModel.getSourceVersion().equals("7x")) {
            result.setAttribute("use-system-logging", source.getAttribute("use-system-logging"));
            this.setModuleLevelLogs(source, result);
        } else {
            nonTransferList = new Vector<String>();
            if (UpgradeConstants.isPreAS91Version(commonInfoModel.getSourceVersion())) {
                nonTransferList.add("file");
            }
            super.transferAttributes(source, result, nonTransferList);
        }
    }

    private void setModuleLevelLogs(Element sourceLogService, Element resultLogService) {
        NodeList modLogLevels = resultLogService.getElementsByTagName("module-log-levels");
        Element moduleLogLevels = null;
        if (modLogLevels.getLength() == 0) {
            moduleLogLevels = resultLogService.getOwnerDocument().createElement("module-log-levels");
            resultLogService.appendChild(moduleLogLevels);
        } else {
            moduleLogLevels = (Element)modLogLevels.item(0);
        }
        this.setLogLevelAttribute(sourceLogService, "ejb-container", "log-level", moduleLogLevels, "ejb-container");
        this.setLogLevelAttribute(sourceLogService, "web-container", "log-level", moduleLogLevels, "web-container");
        this.setLogLevelAttribute(sourceLogService, "mdb-container", "log-level", moduleLogLevels, "mdb-container");
        this.setLogLevelAttribute(sourceLogService, "orb", "log-level", moduleLogLevels, "corba");
        this.setLogLevelAttribute(sourceLogService, "admin-service", "log-level", moduleLogLevels, "admin");
        this.setLogLevelAttribute(sourceLogService, "jms-service", "log-level", moduleLogLevels, "jms");
        this.setLogLevelAttribute(sourceLogService, "log-service", "level", moduleLogLevels, "server");
        this.setLogLevelAttribute(sourceLogService, "log-service", "level", moduleLogLevels, "root");
        this.setLogLevelAttribute(sourceLogService, "security-service", "log-level", moduleLogLevels, "security");
        this.setLogLevelAttribute(sourceLogService, "transaction-service", "log-level", moduleLogLevels, "jts");
    }

    private void setLogLevelAttribute(Element sourceLogService, String srcEle, String srcAttrName, Element moduleLogLevels, String targetAttrName) {
        String logLevelAttrValue;
        NodeList srcEles = sourceLogService.getOwnerDocument().getElementsByTagName(srcEle);
        if (srcEles != null && srcEles.getLength() > 0 && (logLevelAttrValue = ((Element)srcEles.item(0)).getAttribute(srcAttrName)) != null && !logLevelAttrValue.trim().equals("")) {
            if (logLevelAttrValue.equals("ALERT") || logLevelAttrValue.equals("FATAL")) {
                logLevelAttrValue = "SEVERE";
            }
            moduleLogLevels.setAttribute(targetAttrName, logLevelAttrValue);
        }
    }
}

