/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.MemoryHashLoginInfoStore;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TransformManager
implements BaseModule {
    private static TransformManager transManager;
    private Document sourceDocument;
    private Document resultDocument;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.transform");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private Vector recoveryList = new Vector();

    public static TransformManager getTransformManager() {
        if (transManager == null) {
            transManager = new TransformManager();
        }
        return transManager;
    }

    public void transform(Document source, Document result) {
        this.sourceDocument = source;
        this.resultDocument = result;
        try {
            Element docEle = this.sourceDocument.getDocumentElement();
            BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(docEle.getTagName());
            baseElement.transform(docEle, source.getDocumentElement(), result.getDocumentElement());
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.transform.startFailureMessage", (Object)ex.getMessage()), ex);
        }
    }

    public boolean upgrade(CommonInfoModel commonInfo) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.transform.startMessage"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (commonInfo.getSourceDomainRootFlag()) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        try {
            Document sourceDoc;
            String sourceConfigXMLFile = commonInfo.getSourceConfigXMLFile();
            String targetConfigXMLFile = commonInfo.getTargetConfigXMLFile();
            String sourceVersion = commonInfo.getSourceVersion();
            this.backup(targetConfigXMLFile, commonInfo);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DocumentBuilder builderDomainXml = factory.newDocumentBuilder();
            builderDomainXml.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document resultDoc = builderDomainXml.parse(new File(targetConfigXMLFile));
            BaseElement.setCommonInfoModel(commonInfo);
            if (!sourceVersion.equals("7x")) {
                builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            }
            if ((sourceDoc = builder.parse(new File(sourceConfigXMLFile))).getDocumentElement() == null || resultDoc.getDocumentElement() == null) {
                return false;
            }
            this.transform(sourceDoc, resultDoc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(targetConfigXMLFile));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.transform.startFailureMessage", (Object)ex.getMessage()), ex);
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.transform.startFailureCheckAccessMessage"));
            return false;
        }
        File dir = new File(System.getProperty("user.home"));
        File store = new File(dir, ".asadminpass");
        try {
            MemoryHashLoginInfoStore adminpass = new MemoryHashLoginInfoStore();
            String adminPort = DomainsProcessor.getSourceAdminPort(commonInfo.getSourceInstallDir());
            int port = new Integer(adminPort);
            String user = commonInfo.getAdminUserName();
            String pwd = commonInfo.getAdminPassword();
            LoginInfo login = new LoginInfo("localhost", port, user, pwd);
            adminpass.store(login, true);
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage());
        }
        return true;
    }

    private void backup(String filePath, CommonInfoModel commonInfo) throws IOException {
        String backupFilePath = filePath + ".bak";
        UpgradeUtils.copyFile(filePath, backupFilePath);
        this.recoveryList.add(filePath);
    }

    public void recovery(CommonInfoModel commonInfo) {
        Enumeration e = this.recoveryList.elements();
        while (e.hasMoreElements()) {
            String recoverPath = (String)e.nextElement();
            String backupPath = recoverPath + ".bak";
            try {
                UpgradeUtils.copyFile(backupPath, recoverPath);
                new File(backupPath).delete();
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.realm.recoveryFailureMessage", (Object)ioe.getMessage()), new Object[]{recoverPath, ioe});
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("com.sun.aas.installRoot", "C:\\Softwares\\Sun\\j2eesdk1.4_beta3");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document sourceDoc = builder.parse(new File("C:\\temp\\server.xml"));
            Document resultDoc = builder.parse(new File("C:\\temp\\domain.xml"));
            TransformManager transMan = TransformManager.getTransformManager();
            transMan.transform(sourceDoc, resultDoc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream("c:\\temp\\domainModified.xml"));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getName() {
        return this.stringManager.getString("upgrade.transform.moduleName");
    }
}

