/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;
import java.util.List;

public class ARG_noprompt
extends ArgumentHandler {
    public static String defaultAdminUser = "admin";
    private String defaultAdminPassword = "adminadmin";
    private String defaultMasterPassword = "changeit";

    public ARG_noprompt(ParsedArgument pa) {
        super(pa);
        this.commonInfo.setNoprompt(true);
        if (this.commonInfo.getAdminUserName() == null) {
            this.commonInfo.setAdminUserName(defaultAdminUser);
            this.interactiveMap.put("adminuser", defaultAdminUser);
        }
        if (this.commonInfo.getAdminPassword() == null) {
            this.commonInfo.setAdminPassword(this.defaultAdminPassword);
            this.interactiveMap.put("adminpassword", this.defaultAdminPassword);
        }
        if (this.commonInfo.getMasterPassword() == null) {
            this.commonInfo.setMasterPassword(this.defaultMasterPassword);
        }
        this.commonInfo.setCertificateConversionFlag(true);
        List domainList = this.commonInfo.getDomainList();
        for (String domainName : domainList) {
            String trustJksPath;
            this.commonInfo.setCurrentDomain(domainName);
            String password = UpgradeUtils.getUpgradeUtils(this.commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.keyStorePassword");
            if (password == null) {
                password = this.commonInfo.getMasterPassword();
            }
            this.commonInfo.setJksKeystorePassword(password);
            String trustPassword = UpgradeUtils.getUpgradeUtils(this.commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.trustStorePassword");
            if (trustPassword == null) {
                trustPassword = this.commonInfo.getMasterPassword();
            }
            this.commonInfo.setJksCAKeystorePassword(trustPassword);
            this.commonInfo.addDomainOptionName(domainName);
            this.interactiveMap.put("domain-" + this.commonInfo.getCurrentDomain(), domainName);
            this.interactiveMap.put("jkspwd-" + domainName, password);
            this.interactiveMap.put("capwd-" + domainName, password);
            this.interactiveMap.put("nsspwd-" + domainName, password);
            this.interactiveMap.put("targetnsspwd-" + domainName, password);
            this.commonInfo.setCertDbPassword(this.commonInfo.getCurrentDomain(), password);
            String jksPath = this.commonInfo.getSourceJKSKeyStorePath();
            if (!PasswordVerifier.verifyKeystorePassword(jksPath, password)) {
                this.commonInfo.recover();
                this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                System.exit(1);
            }
            if (PasswordVerifier.verifyKeystorePassword(trustJksPath = this.commonInfo.getSourceTrustedJKSKeyStorePath(), trustPassword)) continue;
            this.commonInfo.recover();
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
            System.exit(1);
        }
    }
}

