/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.common.Commands;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class DomainsProcessor {
    private CommonInfoModel commonInfo;
    private Vector httpSSLPorts;
    private Vector iiopSSLPorts;
    private Vector iiopMutualAuthPorts;
    private Vector sourceXMLCorePorts;
    private Vector adminJMXPorts;
    private Vector iiopPorts;
    private Vector httpPorts;
    private static int iiopPortToStartWith = 1071;
    private static int adminPortToStartWith = 4858;
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private static StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
    private boolean domainStarted = false;

    public DomainsProcessor(CommonInfoModel ci) {
        String sampleDomainFile;
        File samplesDir;
        this.commonInfo = ci;
        this.httpSSLPorts = new Vector();
        this.iiopSSLPorts = new Vector();
        this.iiopMutualAuthPorts = new Vector();
        this.sourceXMLCorePorts = new Vector();
        this.adminJMXPorts = new Vector();
        this.iiopPorts = new Vector();
        this.httpPorts = new Vector();
        String targetDomainRoot = this.commonInfo.getTargetDomainRoot();
        File domainDir = new File(targetDomainRoot + File.separator + "domain1");
        if (domainDir.exists()) {
            String targetDomainFile = targetDomainRoot + File.separator + "domain1" + File.separator + "config" + File.separator + "domain.xml";
            if (domainDir.isDirectory() && !ci.isValid70Domain(targetDomainRoot + File.separator + "domain1") && new File(targetDomainFile).exists()) {
                String httpP;
                String iiP;
                String adminJMX;
                String iiMAP;
                String iiSSP;
                String htSSP = DomainsProcessor.getPortFromXML(targetDomainFile, "http-listener", "http-listener-2");
                if (htSSP != null) {
                    this.httpSSLPorts.add(htSSP);
                }
                if ((iiSSP = DomainsProcessor.getPortFromXML(targetDomainFile, "iiop-listener", "SSL")) != null) {
                    this.iiopSSLPorts.add(iiSSP);
                }
                if ((iiMAP = DomainsProcessor.getPortFromXML(targetDomainFile, "iiop-listener", "SSL_MUTUALAUTH")) != null) {
                    this.iiopMutualAuthPorts.add(iiMAP);
                }
                if ((adminJMX = DomainsProcessor.getJMXPortFromXML(targetDomainFile, "jmx-connector", "system")) != null) {
                    this.adminJMXPorts.add(adminJMX);
                }
                if ((iiP = DomainsProcessor.getPortFromXML(targetDomainFile, "iiop-listener", "orb-listener-1")) != null) {
                    this.iiopPorts.add(iiP);
                }
                if ((httpP = DomainsProcessor.getPortFromXML(targetDomainFile, "http-listener", "http-listener-1")) != null) {
                    this.httpPorts.add(httpP);
                }
            }
        }
        if ((samplesDir = new File(targetDomainRoot + File.separator + "samples")).isDirectory() && !ci.isValid70Domain(targetDomainRoot + File.separator + "samples") && new File(sampleDomainFile = targetDomainRoot + File.separator + "samples" + File.separator + "config" + File.separator + "domain.xml").exists()) {
            String shttpP;
            String siiP;
            String sadminJMX;
            String siiMAP;
            String siiSSP;
            String shtSSP = DomainsProcessor.getPortFromXML(sampleDomainFile, "http-listener", "http-listener-2");
            if (shtSSP != null) {
                this.httpSSLPorts.add(shtSSP);
            }
            if ((siiSSP = DomainsProcessor.getPortFromXML(sampleDomainFile, "iiop-listener", "SSL")) != null) {
                this.iiopSSLPorts.add(siiSSP);
            }
            if ((siiMAP = DomainsProcessor.getPortFromXML(sampleDomainFile, "iiop-listener", "SSL_MUTUALAUTH")) != null) {
                this.iiopMutualAuthPorts.add(siiMAP);
            }
            if ((sadminJMX = DomainsProcessor.getJMXPortFromXML(sampleDomainFile, "jmx-connector", "system")) != null) {
                this.adminJMXPorts.add(sadminJMX);
            }
            if ((siiP = DomainsProcessor.getPortFromXML(sampleDomainFile, "iiop-listener", "orb-listener-1")) != null) {
                this.iiopPorts.add(siiP);
            }
            if ((shttpP = DomainsProcessor.getPortFromXML(sampleDomainFile, "http-listener", "http-listener-1")) != null) {
                this.httpPorts.add(shttpP);
            }
        }
    }

    public void processTargetDomains() throws HarnessException {
        List domainNames = this.commonInfo.getDomainList();
        String target = this.commonInfo.getTargetInstallDir();
        String sourceEdition = this.commonInfo.getSourceEdition();
        UpgradeUtils upgradeUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
        if (this.commonInfo.isEnterpriseEdition(sourceEdition) || sourceEdition.equals("cluster")) {
            this.commonInfo.processDomainXmlForClusters();
        }
        for (int i = 0; i < domainNames.size(); ++i) {
            String sourceDomainName;
            String targetDomainName = sourceDomainName = (String)domainNames.get(i);
            String targetDomainRoot = this.commonInfo.getTargetDomainRoot();
            if (!new File(targetDomainRoot).isDirectory()) {
                logger.log(Level.INFO, stringManager.getString("upgrade.common.not_valid_target_install"));
                return;
            }
            File targetDomainUpgrade = new File(targetDomainRoot + File.separator + targetDomainName);
            boolean targetDomainDeleted = false;
            if (!this.commonInfo.isInPlace()) {
                if (targetDomainUpgrade.isDirectory()) {
                    targetDomainDeleted = UpgradeUtils.deleteDirectory(targetDomainUpgrade);
                    if (targetDomainDeleted) {
                        logger.log(Level.INFO, stringManager.getString("upgrade.common.existing_target_domain_deleted"));
                    } else {
                        logger.log(Level.SEVERE, stringManager.getString("upgrade.common.delete_existing_target_domain_failed"));
                        UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
                    }
                } else {
                    targetDomainDeleted = true;
                }
                if (targetDomainDeleted) {
                    File targetNodeagentsDir = new File(target, "nodeagents");
                    String sourceDomainDir = this.commonInfo.getSourceInstallDir();
                    String sourceInstallDir = sourceDomainDir.substring(0, sourceDomainDir.lastIndexOf("domains"));
                    File sourceNodeagentsDir = new File(sourceInstallDir, "nodeagents");
                    if (targetNodeagentsDir.exists()) {
                        if (UpgradeUtils.deleteDirectory(targetNodeagentsDir)) {
                            targetNodeagentsDir.mkdir();
                        } else {
                            logger.warning("Unable to delete existing nodeagents config!");
                        }
                    } else {
                        targetNodeagentsDir.mkdir();
                    }
                }
            } else {
                targetDomainDeleted = true;
            }
            if (targetDomainDeleted) {
                String[] createDomainCommand = this.getCreateDomainCommand(sourceDomainName, targetDomainName);
                boolean canContinue = this.executeCommand(createDomainCommand);
                UpdateProgressManager.getProgressManager().setContinueUpgrade(canContinue);
                if (!canContinue) {
                    throw new HarnessException(stringManager.getString("upgrade.common.domain_creation_error", (Object)targetDomainName));
                }
                UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(i * 30 / domainNames.size());
            }
            this.setAdminPortAndSecurity(sourceDomainName, targetDomainName);
            this.setServerIIOPPort(sourceDomainName, targetDomainName);
        }
    }

    private String[] getCreateDomainCommand(String domainName, String domainName80) {
        String target = this.commonInfo.getTargetDomainRoot();
        DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(domainName);
        String domainPath = dInfo.getDomainPath();
        String profile = dInfo.getProfile();
        String httpPort = this.getAFreePort(8080, 10);
        String adminPort = DomainsProcessor.getSourceAdminPort(domainPath);
        String jmsPort = "7676";
        String iiopPort = DomainsProcessor.getSourceIIOPPort(domainPath);
        String httpSSLPort = this.getAFreePort(8081, 10);
        String iiopSSLPort = this.getAFreePort(3820, 10);
        String iiopSSLMutualAuth = this.getAFreePort(3920, 10);
        String adminJMXPort = this.getAFreePort(8686, 10);
        this.iiopPorts.add(iiopPort);
        this.adminJMXPorts.add(adminJMXPort);
        this.httpSSLPorts.add(httpSSLPort);
        this.iiopSSLPorts.add(iiopSSLPort);
        this.iiopMutualAuthPorts.add(iiopSSLMutualAuth);
        String instancePortAttr = "";
        if (httpPort != null) {
            instancePortAttr = "--instanceport " + httpPort;
        }
        String propertiesString = "http.ssl.port=" + httpSSLPort + ":orb.ssl.port=" + iiopSSLPort + ":orb.mutualauth.port=" + iiopSSLMutualAuth + ":jms.port=" + jmsPort + ":orb.listener.port=" + iiopPort;
        propertiesString = propertiesString + ":domain.jmxPort=" + adminJMXPort;
        String[] createDomainCommand = new String[]{"create-domain", "--profile", "\"" + profile + "\"", "--domaindir", "\"" + target + "\"", "--adminport", adminPort, "--user", this.commonInfo.getAdminUserName(), "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", "--savemasterpassword=true", instancePortAttr, "--domainproperties", propertiesString, domainName80};
        return createDomainCommand;
    }

    public static String getSourceAdminPort(String domainPath) {
        String domainXmlFile = domainPath + File.separator + "config" + File.separator + "domain.xml";
        if (new File(domainXmlFile).exists()) {
            String port = DomainsProcessor.getPortFromXML(domainXmlFile, "http-listener", "admin-listener");
            if (port != null) {
                return port;
            }
        } else {
            adminPortToStartWith = 10;
        }
        return String.valueOf(adminPortToStartWith);
    }

    public static String getSourceAdminSecurity(String domainPath) {
        String securityEnabled;
        String domainXmlFile = domainPath + File.separator + "config" + File.separator + "domain.xml";
        if (new File(domainXmlFile).exists() && (securityEnabled = DomainsProcessor.getSecurityEnabledFromXML(domainXmlFile, "http-listener", "admin-listener")) != null) {
            return securityEnabled;
        }
        return "true";
    }

    private void setAdminPortAndSecurity(String sourceDomainName, String targetDomainName) {
        DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(sourceDomainName);
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        String domainPath = dInfo.getDomainPath();
        String sourceEdition = this.commonInfo.getSourceEdition();
        String targetDomainRoot = this.commonInfo.getTargetDomainRoot();
        String adminPort = DomainsProcessor.getSourceAdminPort(domainPath);
        String securityEnabled = DomainsProcessor.getSourceAdminSecurity(domainPath);
        String domainFileName = targetDomainRoot + File.separator + targetDomainName + File.separator + "config" + File.separator + "domain.xml";
        Document resultDoc = upgrUtils.getDomainDocumentElement(domainFileName);
        try {
            NodeList taggedElements = resultDoc.getDocumentElement().getElementsByTagName("http-listener");
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals("admin-listener")) continue;
                element.setAttribute("port", adminPort);
                if (this.commonInfo.isEnterpriseEdition(sourceEdition)) break;
                element.setAttribute("security-enabled", securityEnabled);
                break;
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(domainFileName));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_port_from_XML"), ex);
        }
    }

    private static String getPortFromXML(String fileName, String tagName, String id) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName(tagName);
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals(id)) continue;
                return element.getAttribute("port");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_port_from_XML"), ex);
        }
        return null;
    }

    private static String getSecurityEnabledFromXML(String fileName, String tagName, String id) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName(tagName);
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("id").equals(id)) continue;
                return element.getAttribute("security-enabled");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_admin_security_from_XML"), ex);
        }
        return null;
    }

    private String getSourceNodeAgentForInstance(String domainName, String serverName) {
        String sourceDomainPath = ((DomainInfo)this.commonInfo.getDomainMapping().get(domainName)).getDomainPath();
        String domainXmlFile = sourceDomainPath + File.separator + "config" + File.separator + "domain.xml";
        String nodeAgentName = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(domainXmlFile));
            NodeList servers = adminServerDoc.getDocumentElement().getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            for (int lh = 0; lh < serverList.getLength(); ++lh) {
                Element server = (Element)serverList.item(lh);
                if (!serverName.equals(server.getAttribute("name"))) continue;
                nodeAgentName = server.getAttribute("node-agent-ref");
                break;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"), ex);
        }
        return nodeAgentName;
    }

    private String getTargetNodeAgentName(String domainName, CommonInfoModel commonInfoMod) {
        String configFileName = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return this.getNodeAgentNameFromXML(configFileName);
    }

    private String getNodeAgentNameFromXML(String fileName) {
        if (this.commonInfo.getSourceVersion().equals("7x") || !new File(fileName).exists()) {
            return null;
        }
        Object nodeAgentName = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            Element element = (Element)taggedElements.item(0);
            if (null == element) {
                logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"));
                return null;
            }
            return element.getAttribute("name");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"), ex);
            return null;
        }
    }

    private boolean nodeAgentExists(String agentName, String fileName) {
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        Document adminServerDoc = upgrUtils.getDomainDocumentElement(fileName);
        try {
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element itElement = (Element)taggedElements.item(lh);
                String attrName = itElement.getAttribute("name");
                if (attrName.equals(agentName)) {
                    return true;
                }
                if (agentName.indexOf(".") == -1 || !agentName.substring(0, agentName.indexOf(".")).equals(attrName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"), ex);
        }
        return false;
    }

    public static String getTargetDomainPort(String domainName, CommonInfoModel commonInfoMod) {
        String configFileName = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return DomainsProcessor.getPortFromXML(configFileName, "http-listener", "admin-listener");
    }

    public static String getTargetDomainSecurity(String domainName, CommonInfoModel commonInfoMod) {
        String configFile = commonInfoMod.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        return DomainsProcessor.getSecurityEnabledFromXML(configFile, "http-listener", "admin-listener");
    }

    private String getAFreePort(int initPortNumber, int increment) {
        int portNumber = initPortNumber;
        for (int i = 0; i < 20; ++i) {
            if (this.isPortNumberUsable(portNumber)) {
                return Integer.toString(portNumber);
            }
            portNumber += increment;
        }
        return Integer.toString(portNumber);
    }

    private boolean isPortNumberUsable(int portNumber) {
        int i;
        String portString = Integer.toString(portNumber);
        for (i = 0; i < this.httpSSLPorts.size(); ++i) {
            if (!((String)this.httpSSLPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.iiopSSLPorts.size(); ++i) {
            if (!((String)this.iiopSSLPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.iiopMutualAuthPorts.size(); ++i) {
            if (!((String)this.iiopMutualAuthPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.sourceXMLCorePorts.size(); ++i) {
            if (!((String)this.sourceXMLCorePorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.adminJMXPorts.size(); ++i) {
            if (!((String)this.adminJMXPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.iiopPorts.size(); ++i) {
            if (!((String)this.iiopPorts.get(i)).equals(portString)) continue;
            return false;
        }
        for (i = 0; i < this.httpPorts.size(); ++i) {
            if (!((String)this.httpPorts.get(i)).equals(portString)) continue;
            return false;
        }
        return NetUtils.isPortFree((int)portNumber);
    }

    private List getInstanceNamesWithoutAdminServerAndServer1(List instanceList) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String serverName : instanceList) {
            if (serverName.equals("admin-server")) continue;
            newList.add(serverName);
        }
        return newList;
    }

    public boolean createNodeAgent(String agentName, String dasHost, String dasPort, String dasuser, String daspwd, String domainName, String clientHostName) throws HarnessException {
        String clientAddress;
        String myAddress;
        block4: {
            myAddress = null;
            clientAddress = null;
            try {
                myAddress = InetAddress.getByName(dasHost).getHostAddress();
                clientAddress = InetAddress.getByName(clientHostName).getHostAddress();
            }
            catch (Exception e) {
                if (clientAddress == null) {
                    logger.warning(stringManager.getString("upgrade.common.domain_processor_could_not_resolve_client_hostname") + " " + clientHostName);
                    clientAddress = "unknown";
                }
                if (myAddress != null) break block4;
                myAddress = "127.0.0.1";
            }
        }
        if (clientAddress.equals(myAddress) || clientHostName.equals("localhost")) {
            String adminSecurity = DomainsProcessor.getTargetDomainSecurity(domainName, this.commonInfo);
            System.setProperty("com.sun.aas.instanceRoot", this.commonInfo.getTargetInstallDir());
            String agentProperties = "remoteclientaddress=" + clientHostName;
            agentProperties = agentProperties != null && !agentProperties.equals("") ? "--agentproperties " + agentProperties : "";
            String[] command = new String[]{"create-node-agent", "--host", dasHost, "--port", dasPort, "--secure=" + adminSecurity, "--user", dasuser, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", agentProperties, agentName};
            return this.executeCommand(command);
        }
        return true;
    }

    public boolean createNodeAgentConfig(String agentName, String dasHost, String dasPort, String dasuser, String daspwd, String domainName, String clientHostname) {
        String adminSecurity = DomainsProcessor.getTargetDomainSecurity(domainName, this.commonInfo);
        System.setProperty("com.sun.aas.instanceRoot", this.commonInfo.getTargetInstallDir());
        String[] command = new String[]{"create-node-agent-config", "--host", dasHost, "--port", dasPort, "--secure=" + adminSecurity, "--user", dasuser, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", agentName};
        boolean result = this.executeCommand(command);
        return result;
    }

    private void transferNodeAgentSettings(String domainName, String agentName, String clientHostname) throws HarnessException {
        this.stopDomain(domainName);
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        String targetDomainRoot = this.commonInfo.getTargetDomainRoot();
        String targetDomainFileName = targetDomainRoot + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        String sourceDomainPath = this.commonInfo.getSourceInstallDir();
        String sourceDomainFileName = sourceDomainPath + File.separator + "config" + File.separator + "domain.xml";
        Document sourceDoc = upgrUtils.getDomainDocumentElement(sourceDomainFileName);
        Document resultDoc = upgrUtils.getDomainDocumentElement(targetDomainFileName);
        try {
            NodeList agentElements = resultDoc.getDocumentElement().getElementsByTagName("node-agents");
            Element nodeAgents = (Element)agentElements.item(0);
            NodeList taggedElements = nodeAgents.getElementsByTagName("node-agent");
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("name").equals(agentName)) continue;
                NodeList jmxConnectorElements = element.getElementsByTagName("jmx-connector");
                Element jmxConnectorElement = (Element)jmxConnectorElements.item(0);
                NodeList sourceAgentElements = sourceDoc.getDocumentElement().getElementsByTagName("node-agents");
                Element sourceNodeAgents = (Element)sourceAgentElements.item(0);
                NodeList sourceTaggedElements = sourceNodeAgents.getElementsByTagName("node-agent");
                for (int ii = 0; ii < sourceTaggedElements.getLength(); ++ii) {
                    Element sourceElement = (Element)sourceTaggedElements.item(ii);
                    if (!sourceElement.getAttribute("name").equals(agentName)) continue;
                    NodeList sourceJmxConnectorElements = sourceElement.getElementsByTagName("jmx-connector");
                    Element sourceJmxConnectorElement = (Element)sourceJmxConnectorElements.item(0);
                    String port = sourceJmxConnectorElement.getAttribute("port");
                    jmxConnectorElement.setAttribute("port", port);
                    break;
                }
                NodeList propertyElements = jmxConnectorElement.getElementsByTagName("property");
                for (int pi = 0; pi < propertyElements.getLength(); ++pi) {
                    Element propertyElement = (Element)propertyElements.item(pi);
                    if (!propertyElement.getAttribute("name").equals("client-hostname")) continue;
                    propertyElement.setAttribute("value", clientHostname);
                }
                String rendezvousOccurredValue = this.getNodeAgentRendezvousProperty(agentName);
                propertyElements = element.getElementsByTagName("property");
                for (int pi = 0; pi < propertyElements.getLength(); ++pi) {
                    Element propertyElement = (Element)propertyElements.item(pi);
                    if (!propertyElement.getAttribute("name").equals("rendezvousOccurred")) continue;
                    propertyElement.setAttribute("value", rendezvousOccurredValue);
                }
                break;
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult resultStream = new StreamResult(new FileOutputStream(targetDomainFileName));
            transformer.transform(source, resultStream);
            resultStream.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_port_from_XML"), ex);
        }
        this.startDomain(domainName);
    }

    public boolean createServerInstance(String serverName, String agentName, String configName, String userid, String pwd, String adminPort, String adminSecurity, String domainName) {
        if (configName != null) {
            String[] command = new String[]{"create-instance", "--nodeagent", agentName, "--port", adminPort, "--secure=" + adminSecurity, "--config", configName, "--user", userid, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", serverName};
            return this.executeCommand(command);
        }
        String[] command = new String[]{"create-instance", "--nodeagent", agentName, "--user", userid, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", "--port", adminPort, "--secure=" + adminSecurity, serverName};
        return this.executeCommand(command);
    }

    private boolean startDomain(String domainName) throws HarnessException {
        return this.startDomain(domainName, this.commonInfo);
    }

    public boolean startDomain(String domainName, CommonInfoModel commonInfo) throws HarnessException {
        if (!this.domainStarted) {
            if (Commands.startDomain(domainName, commonInfo)) {
                this.domainStarted = true;
                return true;
            }
            throw new HarnessException(stringManager.getString("upgrade.common.domain_start_failed", (Object)domainName));
        }
        return false;
    }

    public boolean stopDomain(String domainName) throws HarnessException {
        if (this.domainStarted) {
            if (Commands.stopDomain(domainName, this.commonInfo)) {
                this.domainStarted = false;
                return true;
            }
            throw new HarnessException(stringManager.getString("upgrade.common.domain_stop_failed", (Object)domainName));
        }
        return false;
    }

    private boolean executeCommand(String[] commandStrings) {
        try {
            return Commands.executeCommand(commandStrings);
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            logger.log(Level.SEVERE, stringManager.getString("enterprise.tools.upgrade.generalException", (Object)ce.getMessage()), ce);
            if (t != null) {
                logger.log(Level.SEVERE, stringManager.getString("enterprise.tools.upgrade.generalException", (Object)t.getMessage()));
            }
            return false;
        }
    }

    public boolean processClusters() throws HarnessException {
        String sourceVersion = this.commonInfo.getSourceVersion();
        List clInfoList = ClustersInfoManager.getClusterInfoManager().getClusterInfoList();
        if (clInfoList == null || clInfoList.isEmpty()) {
            return false;
        }
        int clusterNo = 0;
        for (ClusterInfo clInfo : clInfoList) {
            String adminSecurity;
            String adminPort;
            String clusterName = null;
            clusterName = "7x".equals(sourceVersion) ? "cluster_" + Integer.toString(clusterNo++) : clInfo.getClusterName();
            clInfo.setClusterName(clusterName);
            this.startDomain(clInfo.getDomainName());
            boolean clusterCreated = this.createCluster(clusterName, clInfo.getDomainName());
            if (!clusterCreated) {
                this.stopDomain(clInfo.getDomainName());
                return false;
            }
            List clInstances = clInfo.getClusteredInstanceList();
            ClusteredInstance masterInstance = clInfo.getMasterInstance();
            String startedDomainName = null;
            String configName = clusterName + "_config";
            if (masterInstance == null) {
                adminPort = null;
                adminSecurity = null;
                for (ClusteredInstance clusteredInstance : clInstances) {
                    startedDomainName = clusteredInstance.getDomain();
                    adminPort = DomainsProcessor.getTargetDomainPort(startedDomainName, this.commonInfo);
                    adminSecurity = DomainsProcessor.getTargetDomainSecurity(startedDomainName, this.commonInfo);
                    this.createClusteredInstance(clusteredInstance, clusterName, startedDomainName, configName, adminPort, adminSecurity);
                }
            } else {
                adminPort = DomainsProcessor.getTargetDomainPort(masterInstance.getDomain(), this.commonInfo);
                adminSecurity = DomainsProcessor.getTargetDomainSecurity(masterInstance.getDomain(), this.commonInfo);
                this.createClusteredInstance(masterInstance, clusterName, masterInstance.getDomain(), configName, adminPort, adminSecurity);
                for (ClusteredInstance clInst : clInstances) {
                    if (clInst.isMaster()) continue;
                    this.createClusteredInstance(clInst, clusterName, masterInstance.getDomain(), configName, adminPort, adminSecurity);
                }
            }
            this.stopDomain(clInfo.getDomainName());
        }
        this.commonInfo.setCurrentCluster(null);
        this.processStandAloneInstances();
        return true;
    }

    private boolean createClusteredInstance(ClusteredInstance clInstance, String clusterName, String domainName, String configName, String adminPort, String adminSecurity) throws HarnessException {
        String serverName = clInstance.getInstanceName();
        String nodeAgentName = clInstance.getHost();
        String clientHostName = this.getNodeAgentClient(nodeAgentName);
        String dasHostName = null;
        try {
            dasHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            dasHostName = "localhost";
        }
        String configFileName = this.commonInfo.getTargetDomainRoot() + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml";
        String user = this.commonInfo.getAdminUserName();
        String password = this.commonInfo.getAdminPassword();
        if (!this.nodeAgentExists(nodeAgentName, configFileName)) {
            if (this.commonInfo.isInPlace()) {
                this.createNodeAgentConfig(nodeAgentName, dasHostName, clInstance.getPort(), user, password, domainName, clientHostName);
            } else {
                this.createNodeAgent(nodeAgentName, dasHostName, clInstance.getPort(), user, password, domainName, clientHostName);
            }
        }
        String[] command = new String[]{"create-instance", "--user", user, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", "--nodeagent", nodeAgentName, "--port", adminPort, "--secure=" + adminSecurity, "--cluster", clusterName, clInstance.getInstanceName()};
        boolean success = this.executeCommand(command);
        this.transferNodeAgentSettings(domainName, nodeAgentName, clientHostName);
        return success;
    }

    private boolean createCluster(String clusterName, String domainName) throws HarnessException {
        String adminSecurity = null;
        String adminPort = null;
        if (domainName != null) {
            adminPort = DomainsProcessor.getTargetDomainPort(domainName, this.commonInfo);
            adminSecurity = DomainsProcessor.getTargetDomainSecurity(domainName, this.commonInfo);
        }
        String adminUser = this.commonInfo.getAdminUserName();
        String[] command = new String[]{"create-cluster", "--port", adminPort, "--secure=" + adminSecurity, "--user", adminUser, "--passwordfile ", "\"" + this.commonInfo.getPasswordFile() + "\"", clusterName};
        boolean returnStatus = this.executeCommand(command);
        return returnStatus;
    }

    public void processStandAloneInstances() throws HarnessException {
        List stdAloneInsts = null;
        UpgradeUtils upgradeUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        String sourceVersion = this.commonInfo.getSourceVersion();
        stdAloneInsts = upgradeUtils.getStandAloneInstancesFromDomainXml();
        if (stdAloneInsts == null) {
            return;
        }
        Vector<DomainInfo> runningDomains = new Vector<DomainInfo>();
        for (Vector instDInfo : stdAloneInsts) {
            String serverName = (String)instDInfo.elementAt(0);
            DomainInfo dInfo = (DomainInfo)instDInfo.elementAt(1);
            String adminPort = DomainsProcessor.getTargetDomainPort(dInfo.getDomainName(), this.commonInfo);
            String adminSecurity = DomainsProcessor.getTargetDomainSecurity(dInfo.getDomainName(), this.commonInfo);
            String domainName = dInfo.getDomainName();
            String agentName = this.getSourceNodeAgentForInstance(domainName, serverName);
            if (agentName == null || agentName.equals("")) continue;
            if (!runningDomains.contains(dInfo)) {
                this.startDomain(dInfo.getDomainName());
                runningDomains.add(dInfo);
            }
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                hostName = "localhost";
            }
            String clientName = this.getNodeAgentClient(agentName);
            String configFileName = this.commonInfo.getTargetDomainRoot() + File.separator + dInfo.getDomainName() + File.separator + "config" + File.separator + "domain.xml";
            if (!this.nodeAgentExists(agentName, configFileName)) {
                if (this.commonInfo.isInPlace()) {
                    this.createNodeAgentConfig(agentName, hostName, adminPort, this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), dInfo.getDomainName(), clientName);
                } else {
                    this.createNodeAgent(agentName, hostName, adminPort, this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), dInfo.getDomainName(), clientName);
                }
                this.transferNodeAgentSettings(dInfo.getDomainName(), agentName, clientName);
            }
            if (serverName.equals("server")) continue;
            boolean status = this.createServerInstance(serverName, agentName, null, this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), adminPort, adminSecurity, dInfo.getDomainName());
        }
        ListIterator runningDomainsList = runningDomains.listIterator();
        while (runningDomainsList.hasNext()) {
            this.stopDomain(((DomainInfo)runningDomainsList.next()).getDomainName());
        }
    }

    private static String getJMXPortFromXML(String fileName, String tagName, String name) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(fileName));
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName(tagName);
            for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                Element element = (Element)taggedElements.item(lh);
                if (!element.getAttribute("name").equals(name)) continue;
                return element.getAttribute("port");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_port_from_XML"), ex);
        }
        return null;
    }

    public static String getSourceIIOPPort(String domainPath) {
        String port;
        String domainXmlFile = domainPath + File.separator + "config" + File.separator + "domain.xml";
        if (new File(domainXmlFile).exists() && (port = DomainsProcessor.getPortFromXML(domainXmlFile, "iiop-listener", "orb-listener-1")) != null) {
            return port;
        }
        iiopPortToStartWith = 10;
        return String.valueOf(iiopPortToStartWith);
    }

    private void setServerIIOPPort(String sourceDomainName, String targetDomainName) {
        DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(sourceDomainName);
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.commonInfo);
        String domainPath = dInfo.getDomainPath();
        String targetDomainRoot = this.commonInfo.getTargetDomainRoot();
        String iiopPort = DomainsProcessor.getSourceIIOPPort(domainPath);
        String domainFileName = targetDomainRoot + File.separator + targetDomainName + File.separator + "config" + File.separator + "domain.xml";
        Document resultDoc = upgrUtils.getDomainDocumentElement(domainFileName);
        try {
            NodeList configElements = resultDoc.getDocumentElement().getElementsByTagName("configs");
            NodeList configList = ((Element)configElements.item(0)).getElementsByTagName("config");
            block2: for (int i = 0; i < configList.getLength(); ++i) {
                Element configElement = (Element)configList.item(i);
                if (!configElement.getAttribute("name").equals("server-config")) continue;
                NodeList iiopListenerElements = configElement.getElementsByTagName("iiop-listener");
                for (int lh = 0; lh < iiopListenerElements.getLength(); ++lh) {
                    Element element = (Element)iiopListenerElements.item(lh);
                    if (!element.getAttribute("id").equals("orb-listener-1")) continue;
                    element.setAttribute("port", iiopPort);
                    continue block2;
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(domainFileName));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_port_from_XML"), ex);
        }
    }

    private String getNodeAgentClient(String nodeAgentName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            String sourceDomainPath = this.commonInfo.getSourceInstallDir();
            String domainXmlFile = sourceDomainPath + File.separator + "config" + File.separator + "domain.xml";
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(domainXmlFile);
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            for (int i = 0; i < taggedElements.getLength(); ++i) {
                Element element = (Element)taggedElements.item(i);
                if (!nodeAgentName.equals(element.getAttribute("name"))) continue;
                NodeList jmxConnectorList = element.getElementsByTagName("jmx-connector");
                Element jmxConnectorElement = (Element)jmxConnectorList.item(0);
                NodeList properties = jmxConnectorElement.getElementsByTagName("property");
                for (int ii = 0; ii < properties.getLength(); ++ii) {
                    Element client = (Element)properties.item(ii);
                    if (!"client-hostname".equals(client.getAttribute("name"))) continue;
                    return client.getAttribute("value");
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"), ex);
        }
        return null;
    }

    private String getNodeAgentRendezvousProperty(String nodeAgentName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            String sourceDomainPath = this.commonInfo.getSourceInstallDir();
            String domainXmlFile = sourceDomainPath + File.separator + "config" + File.separator + "domain.xml";
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(domainXmlFile);
            NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("node-agent");
            for (int i = 0; i < taggedElements.getLength(); ++i) {
                Element element = (Element)taggedElements.item(i);
                if (!nodeAgentName.equals(element.getAttribute("name"))) continue;
                NodeList properties = element.getElementsByTagName("property");
                for (int ii = 0; ii < properties.getLength(); ++ii) {
                    Element client = (Element)properties.item(ii);
                    if (!"rendezvousOccurred".equals(client.getAttribute("name"))) continue;
                    return client.getAttribute("value");
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, stringManager.getString("upgrade.common.domain_processor_nodeAgent_from_XML"), ex);
        }
        return null;
    }
}

