/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;

public class Commands {
    private static StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");

    public static boolean deploy(String modulePath, CommonInfoModel commonInfo, ArrayList parameters) {
        String currentDomain = commonInfo.getCurrentDomain();
        String adminPort = DomainsProcessor.getTargetDomainPort(currentDomain, commonInfo);
        String adminSecurity = DomainsProcessor.getTargetDomainSecurity(currentDomain, commonInfo);
        ArrayList<String> deployList = new ArrayList<String>();
        deployList.add("deploy");
        deployList.add("--user");
        deployList.add(commonInfo.getAdminUserName());
        deployList.add("--passwordfile");
        deployList.add("\"" + commonInfo.getPasswordFile() + "\"");
        deployList.add("--port");
        deployList.add(adminPort);
        deployList.add("--secure=" + adminSecurity);
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                deployList.add((String)parameters.get(i));
            }
        }
        deployList.add("\"" + modulePath + "\"");
        String[] deployArray = new String[1];
        if (!commonInfo.isPlatformEdition(commonInfo.getSourceEdition())) {
            String targetName = commonInfo.getCurrentCluster();
            if (targetName == null) {
                targetName = commonInfo.getCurrentSourceInstance();
            }
            if (targetName != null && !"".equals(targetName)) {
                deployList.add(deployList.size() - 1, "--target");
                deployList.add(deployList.size() - 1, targetName);
            }
        }
        String[] deploy = deployList.toArray(deployArray);
        try {
            return Commands.executeCommand(deploy);
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("upgrade.common.general_exception") + " " + (t == null ? ce.getMessage() : t.getMessage()));
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.errorDeployingMsg") + modulePath);
            return false;
        }
    }

    public static boolean startDomain(String domainName, CommonInfoModel commonInfo) {
        String adminUser = commonInfo.getAdminUserName();
        String[] command = new String[]{"start-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() + "\"", "--user", adminUser, "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", domainName};
        try {
            boolean b = Commands.executeCommand(command);
            return b;
        }
        catch (CommandException ce) {
            String message;
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().severe(stringManager.getString("upgrade.common.general_exception") + ce.getMessage());
            if (t != null && (message = t.getMessage()) != null) {
                CommonInfoModel.getDefaultLogger().severe(stringManager.getString("upgrade.common.general_exception") + message);
                if (message.indexOf(stringManager.getString("commands.DomainRunningFragment")) != -1 || stringManager.getString("commands.DomainRunningFragment").equalsIgnoreCase("No local string defined") && message.indexOf("running") != -1) {
                    CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.DomainRunningMsg", (Object)domainName));
                }
            }
            return false;
        }
    }

    public static boolean stopDomain(String domainName, CommonInfoModel commonInfo) {
        String[] command = new String[]{"stop-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() + "\"", domainName};
        try {
            boolean b = Commands.executeCommand(command);
            return b;
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            if (t != null && t.getMessage().indexOf("is not running") != -1) {
                return true;
            }
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("upgrade.common.general_exception") + ce.getMessage());
            return false;
        }
    }

    public static boolean executeCommand(String[] commandStrings) throws CommandException {
        try {
            StringBuffer commandOneString = new StringBuffer();
            for (int i = 0; i < commandStrings.length; ++i) {
                commandOneString.append(commandStrings[i]).append(" ");
            }
            InputsAndOutputs io = InputsAndOutputs.getInstance();
            PipedOutputStream pos = new PipedOutputStream();
            io.setErrorOutput((OutputStream)pos);
            io.setUserOutput((OutputStream)pos);
            CommandOutputReader cor = new CommandOutputReader(pos);
            cor.start();
            CommonInfoModel.getDefaultLogger().info(stringManager.getString("commands.executingCommandMsg") + commandOneString);
            CLIMain.invokeCLI((String)commandOneString.toString(), (InputsAndOutputs)io);
            pos.flush();
            return true;
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("upgrade.common.general_exception") + (t == null ? e.getMessage() : t.getMessage()));
            return false;
        }
    }

    static class CommandOutputReader
    extends Thread {
        PipedInputStream pis = new PipedInputStream();

        public CommandOutputReader(PipedOutputStream pout) throws IOException {
            this.pis.connect(pout);
        }

        public void run() {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(this.pis));
            try {
                String s;
                while ((s = buffReader.readLine()) != null) {
                    CommonInfoModel.getDefaultLogger().info(s);
                }
                buffReader.close();
            }
            catch (Exception ioe) {
                try {
                    buffReader.close();
                }
                catch (Exception e) {
                    CommonInfoModel.getDefaultLogger().info(e.getMessage());
                }
            }
        }

        protected void finalize() throws Throwable {
            this.pis.close();
        }
    }
}

