/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.certconversion.CertificateException;
import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NSStoJKSConversionModule
implements BaseModule {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");
    private static final String PKCS12_OUTPUTFILE_OPTION = "-o";
    private static final String NSS_DB_LOCATION_OPTION = "-d";
    private static final String ALIAS_OPTION = "-n";
    private static final String NSS_PWD_OPTION = "-K";
    private static final String KEYSTORE_PWD_OPTION = "-W";
    private static final String LIST_CERTIFICATE_OPTION = "-L";
    private static final String LIST_KEY_ID = "-K";
    private static final String CERT_NSS_PWD_OPTION = "-f";
    private static final String CERT_UTIL_UNIX = "certutil.sh";
    private static final String PK12_UTIL_UNIX = "pk12util.sh";
    private static final String CERT_UTIL_WIN = "certutil.bat";
    private static final String PK12_UTIL_WIN = "pk12util.bat";
    private static final String CONFIG = "config";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    private static final String UPGRADE = "upgrade";
    String pathOfNSSDbFiles;
    private String jksPath;
    private String trustJksPath;
    private List pkcs12PathList;
    private String nssKeyStorePassword;
    private List keyList;
    private InputStream isJksPath;
    private OutputStream osJksPath;
    private OutputStream trustJKSPathStream;
    private String jksKeyStorePassword;
    private String jksCAkeyStorePassword;
    private boolean certificateError = false;
    private char[] pwd;
    private KeyStore jksKeyStore;
    private KeyStore trustedJksKeyStore;
    private CommonInfoModel commonInfo;

    public boolean upgrade(CommonInfoModel commonInfo) {
        try {
            String currentDomain = commonInfo.getCurrentDomain();
            if (!commonInfo.getDomainOptionList().contains(currentDomain) || commonInfo.getCertDbPassword() == null) {
                return true;
            }
            this.jksPath = commonInfo.getTargetJKSKeyStorePath();
            this.trustJksPath = commonInfo.getTargetTrustedJKSKeyStorePath();
            this.jksKeyStorePassword = commonInfo.getJksKeystorePassword();
            this.jksCAkeyStorePassword = commonInfo.getJksCAKeystorePassword();
            this.pkcs12PathList = new ArrayList();
            this.keyList = new ArrayList();
            this.nssKeyStorePassword = commonInfo.getCertDbPassword();
            this.commonInfo = commonInfo;
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.start_certificate_migration", (Object)currentDomain));
            this.doBackup(commonInfo);
            this.listAllKeysFromSourceInstall();
            this.generatePKCS12Certificates();
            this.runPkcs12ToJks();
            this.deletePKCS12Files();
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.finished_certificate_migration", (Object)currentDomain));
        }
        catch (CertificateException ce) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)ce));
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            return false;
        }
        return true;
    }

    private void doBackup(CommonInfoModel commonInfo) {
        this.doCACertificateBackup();
        this.doKeyPairBackup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCACertificateBackup() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            KeyStore keystoreSource = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore keystoreTarget = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(new File(this.trustJksPath));
            keystoreSource.load(in, this.jksCAkeyStorePassword.toCharArray());
            keystoreTarget.load(null, this.jksCAkeyStorePassword.toCharArray());
            Enumeration<String> en = keystoreSource.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                Certificate cert = keystoreSource.getCertificate(alias);
                keystoreTarget.setCertificateEntry(alias, cert);
            }
            out = new FileOutputStream(this.trustJksPath + ".back");
            keystoreTarget.store(out, this.jksCAkeyStorePassword.toCharArray());
        }
        catch (java.security.cert.CertificateException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (NoSuchAlgorithmException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (FileNotFoundException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (KeyStoreException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKeyPairBackup() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            KeyStore keystoreSource = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore keystoreTarget = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(new File(this.jksPath));
            keystoreSource.load(in, this.jksKeyStorePassword.toCharArray());
            keystoreTarget.load(null, this.jksKeyStorePassword.toCharArray());
            Enumeration<String> en = keystoreSource.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                Key key = keystoreSource.getKey(alias, this.jksKeyStorePassword.toCharArray());
                Certificate[] cert = keystoreSource.getCertificateChain(alias);
                keystoreTarget.setKeyEntry(alias, key, this.jksKeyStorePassword.toCharArray(), cert);
            }
            out = new FileOutputStream(this.jksPath + ".back");
            keystoreTarget.store(out, this.jksKeyStorePassword.toCharArray());
        }
        catch (java.security.cert.CertificateException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (NoSuchAlgorithmException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (FileNotFoundException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (KeyStoreException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public void recovery(CommonInfoModel commonInfo) {
        File keypairKeyStoreOriginalFile = new File(this.jksPath);
        File keypairKeyStoreBackupFile = new File(this.jksPath + ".back");
        File trustedKeyStoreOriginalFile = new File(this.trustJksPath);
        File trustedKeyStoreBackupFile = new File(this.trustJksPath + ".back");
        new File(this.jksPath + ".back1").delete();
        new File(this.trustJksPath + ".back1").delete();
        boolean success = keypairKeyStoreOriginalFile.renameTo(new File(this.jksPath + ".back1"));
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            return;
        }
        success = trustedKeyStoreOriginalFile.renameTo(new File(this.trustJksPath + ".back1"));
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            return;
        }
        keypairKeyStoreOriginalFile.delete();
        trustedKeyStoreOriginalFile.delete();
        success = keypairKeyStoreBackupFile.renameTo(keypairKeyStoreOriginalFile);
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            File keypairKeyStoreanotherBackupFile = new File(this.jksPath + ".back1");
            File trustedKeyStoreanotherBackupFile = new File(this.trustJksPath + ".back1");
            keypairKeyStoreanotherBackupFile.renameTo(keypairKeyStoreOriginalFile);
            trustedKeyStoreanotherBackupFile.renameTo(trustedKeyStoreOriginalFile);
            return;
        }
        success = trustedKeyStoreBackupFile.renameTo(trustedKeyStoreOriginalFile);
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            File keypairKeyStoreanotherBackupFile = new File(this.jksPath + ".back1");
            File trustedKeyStoreanotherBackupFile = new File(this.trustJksPath + ".back1");
            keypairKeyStoreanotherBackupFile.renameTo(keypairKeyStoreOriginalFile);
            trustedKeyStoreanotherBackupFile.renameTo(trustedKeyStoreOriginalFile);
            return;
        }
        new File(this.jksPath + ".back1").delete();
        new File(this.trustJksPath + ".back1").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listAllKeysFromSourceInstall() throws CertificateException {
        String osName = this.commonInfo.getOSName();
        String sourceDomainDir = this.commonInfo.getSourceInstancePath();
        String configDir = sourceDomainDir + File.separator + CONFIG;
        String source70Lib = this.commonInfo.getSourceInstallDir() + File.separator + LIB;
        String source70Bin = this.commonInfo.getSourceInstallDir() + File.separator + BIN;
        String certutilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + UPGRADE;
        String certUtilPath = "";
        certUtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_WIN;
        StringWriter result = new StringWriter();
        String nssPwd = this.commonInfo.getCertDbPassword();
        String domainPath = this.commonInfo.getDestinationDomainPath();
        String nssPwdFile = domainPath + File.separator + "pwdfile";
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(nssPwdFile));
            pw.println(nssPwd);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fe) {
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.unknownError "), fe);
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {}
        }
        String commandString = certUtilPath + " " + "-K" + " " + NSS_DB_LOCATION_OPTION + " " + configDir + " " + CERT_NSS_PWD_OPTION + " " + nssPwdFile + " " + source70Lib + " " + source70Bin + " " + certutilLocation;
        int exitVal = ProcessAdaptor.executeProcess(commandString, (Writer)result);
        result.flush();
        String resultString = result.toString();
        if (exitVal != 0) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)resultString));
        }
        this.parseAndGetKeys(resultString);
    }

    private void parseAndGetKeys(String input) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(input));
            String readString = reader.readLine();
            while (readString != null) {
                String marker = readString.substring(0, 1);
                String anotherMarker = readString.substring(2, 3);
                if (!marker.equals("<") || !anotherMarker.equals(">")) {
                    _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.error_executing_certutil", (Object)input));
                    return;
                }
                String alias = readString.substring(4);
                this.keyList.add(alias);
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_info", (Object)this.commonInfo.getCurrentDomain(), (Object)alias));
                readString = reader.readLine();
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.unknownError"), e);
        }
    }

    private void generatePKCS12Certificates() throws CertificateException {
        String osName = this.commonInfo.getOSName();
        int size = this.keyList.size();
        for (int i = 0; i < size; ++i) {
            String pkcsFile = this.removeWhiteSpace("" + this.keyList.get(i));
            String pkcsFilePath = this.commonInfo.getDestinationDomainPath() + File.separator + pkcsFile + ".pkcs12";
            String sourceDomainDir = this.commonInfo.getSourceInstancePath();
            String configDir = sourceDomainDir + File.separator + CONFIG;
            String source70Lib = this.commonInfo.getSourceInstallDir() + File.separator + LIB;
            String source70Bin = this.commonInfo.getSourceInstallDir() + File.separator + BIN;
            String pk12UtilPath = "";
            pk12UtilPath = osName.indexOf("Windows") == -1 ? this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_UNIX : this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + PK12_UTIL_WIN;
            String pk12utilLocation = this.commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + UPGRADE;
            String[] commandArray = new String[]{pk12UtilPath, source70Lib, source70Bin, pk12utilLocation, PKCS12_OUTPUTFILE_OPTION, pkcsFilePath, NSS_DB_LOCATION_OPTION, configDir, ALIAS_OPTION, "" + this.keyList.get(i) + "", "-K", this.commonInfo.getCertDbPassword(), KEYSTORE_PWD_OPTION, this.commonInfo.getCertDbPassword()};
            StringWriter result = new StringWriter();
            int exitVal = ProcessAdaptor.executeProcess(commandArray, (Writer)result);
            result.flush();
            if (exitVal != 0) {
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", this.keyList.get(i), (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
                throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificateError", this.keyList.get(i), (Object)this.commonInfo.getCurrentDomain(), (Object)result.toString()));
            }
            this.pkcs12PathList.add(pkcsFilePath);
        }
    }

    private String removeWhiteSpace(String str) {
        String concat = "";
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            concat = concat + st.nextToken();
        }
        return concat;
    }

    private void runPkcs12ToJks() throws CertificateException {
        this.openOutputKeystoreJKS();
        this.openOutputTrustedKeystoreJKS();
        this.openAllInputKeystorePKCS12();
        if (!this.certificateError) {
            this.storeJksKeyStore();
        }
        if (!this.certificateError) {
            this.storeJksTrustedKeyStore();
        }
    }

    private void storeJksKeyStore() throws CertificateException {
        try {
            this.osJksPath = new FileOutputStream(this.jksPath);
            this.jksKeyStore.store(this.osJksPath, this.jksKeyStorePassword.toCharArray());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"), ex);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"));
        }
        finally {
            if (this.osJksPath != null) {
                try {
                    this.osJksPath.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void storeJksTrustedKeyStore() throws CertificateException {
        try {
            this.trustJKSPathStream = new FileOutputStream(this.trustJksPath);
            this.trustedJksKeyStore.store(this.trustJKSPathStream, this.jksCAkeyStorePassword.toCharArray());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"), ex);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_JKS_Error"));
        }
        finally {
            if (this.osJksPath != null) {
                try {
                    this.osJksPath.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void openOutputKeystoreJKS() throws CertificateException {
        FileInputStream inputStreamJks = null;
        try {
            inputStreamJks = new FileInputStream(this.jksPath);
            this.jksKeyStore = KeyStore.getInstance("JKS");
            this.jksKeyStore.load(inputStreamJks, this.jksKeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            this.certificateError = true;
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
        finally {
            if (inputStreamJks != null) {
                try {
                    ((InputStream)inputStreamJks).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void openOutputTrustedKeystoreJKS() throws CertificateException {
        FileInputStream inputStreamJks = null;
        try {
            inputStreamJks = new FileInputStream(this.trustJksPath);
            this.trustedJksKeyStore = KeyStore.getInstance("JKS");
            this.trustedJksKeyStore.load(inputStreamJks, this.jksCAkeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            this.certificateError = true;
            _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
        finally {
            if (inputStreamJks != null) {
                try {
                    ((InputStream)inputStreamJks).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void openAllInputKeystorePKCS12() throws CertificateException {
        int size = this.pkcs12PathList.size();
        for (int i = 0; i < size; ++i) {
            this.openInputKeystorePKCS12((String)this.pkcs12PathList.get(i), this.nssKeyStorePassword);
        }
    }

    public void openInputKeystorePKCS12(String pkcs12Path, String pkcs12Pwd) throws CertificateException {
        FileInputStream fis = null;
        KeyStore pkcs12KeyStore = null;
        try {
            fis = new FileInputStream(pkcs12Path);
            pkcs12KeyStore = KeyStore.getInstance("PKCS12");
            pkcs12KeyStore.load(fis, pkcs12Pwd.toCharArray());
            Enumeration<String> en = pkcs12KeyStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.processing_keypair", (Object)alias));
                Key key = pkcs12KeyStore.getKey(alias, pkcs12Pwd.toCharArray());
                Certificate[] cert = pkcs12KeyStore.getCertificateChain(alias);
                ArrayList caList = new ArrayList();
                int i = 0;
                if (cert.length > 1) {
                    for (i = 1; i < cert.length; ++i) {
                        if (!(cert[i] instanceof X509Certificate) || this.certificateError) continue;
                        this.writeToOutputTrustedKeystore(cert[i], alias + "ca" + i);
                    }
                }
                if (cert.length == 1) {
                    String issuer;
                    X509Certificate x509cert = (X509Certificate)cert[0];
                    Principal issuerPrincipal = x509cert.getIssuerDN();
                    Principal subjectPrincipal = x509cert.getSubjectDN();
                    String subject = subjectPrincipal.getName();
                    if (subject.equals(issuer = issuerPrincipal.getName()) && !this.certificateError) {
                        this.writeToOutputTrustedKeystore(cert[i], alias);
                    } else {
                        _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.ca_list", (Object)issuer));
                    }
                }
                if (this.certificateError) continue;
                this.writeToOutputKeystore(key, cert, alias);
            }
        }
        catch (Exception e) {
            this.certificateError = true;
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_PKCS12_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.certificate_PKCS12_Error"));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void writeToOutputKeystore(Key key, Certificate[] cert, String alias) throws CertificateException {
        try {
            this.jksKeyStore.setKeyEntry(alias, key, this.jksKeyStorePassword.toCharArray(), cert);
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_transferred", (Object)alias));
        }
        catch (Exception e) {
            this.certificateError = true;
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
    }

    public void writeToOutputTrustedKeystore(Certificate cert, String alias) throws CertificateException {
        try {
            this.trustedJksKeyStore.setCertificateEntry(alias, cert);
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.ca_transferred", (Object)alias));
        }
        catch (Exception e) {
            this.certificateError = true;
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.certconversion.JKS_Password_Error"));
        }
    }

    private void deletePKCS12Files() {
        String pkcsFilesPath = this.commonInfo.getDestinationDomainPath();
        String[] fileList = new File(pkcsFilesPath).list();
        for (int i = 0; i < fileList.length; ++i) {
            File pkcsFile = new File(pkcsFilesPath + File.separator + fileList[i]);
            if (!pkcsFile.isFile() || !fileList[i].endsWith(".pkcs12")) continue;
            pkcsFile.delete();
        }
        String domainPath = this.commonInfo.getDestinationDomainPath();
        String nssPwdFile = domainPath + File.separator + "pwdfile";
        File pwdfile = new File(nssPwdFile);
        pwdfile.delete();
    }

    public static void main(String[] args) {
        CommonInfoModel commonInfo = new CommonInfoModel();
        commonInfo.setSourceInstallDir(args[0]);
        commonInfo.setTargetInstallDir(args[1]);
        commonInfo.setCertDbPassword(args[2]);
        commonInfo.setJksKeystorePassword(args[3]);
        NSStoJKSConversionModule convModule = new NSStoJKSConversionModule();
        convModule.upgrade(commonInfo);
    }

    public String getName() {
        return this.sm.getString("enterprise.tools.upgrade.certconversion.moduleName");
    }
}

