/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.net.Socket;
import javax.net.ssl.SSLEngine;
import org.apache.tomcat.util.compat.JdkCompat;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEFactory;

public class JSSEImplementation
extends SSLImplementation {
    static final String JSSE14Factory = "org.apache.tomcat.util.net.jsse.JSSE14Factory";
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    private JSSEFactory factory;

    public JSSEImplementation() throws ClassNotFoundException {
        Class.forName(SSLSocketClass);
        if (JdkCompat.isJava14()) {
            try {
                Class<?> factcl = Class.forName(JSSE14Factory);
                this.factory = (JSSEFactory)factcl.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            throw new RuntimeException("JDK 1.3 not supported");
        }
    }

    public String getImplementationName() {
        return "JSSE";
    }

    public ServerSocketFactory getServerSocketFactory() {
        ServerSocketFactory ssf = this.factory.getSocketFactory();
        return ssf;
    }

    public SSLSupport getSSLSupport(Socket s) {
        SSLSupport ssls = this.factory.getSSLSupport(s);
        return ssls;
    }

    public SSLSupport getSSLSupport(SSLEngine sslEngine) {
        return this.factory.getSSLSupport(sslEngine);
    }
}

