/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.OutputBuffer;

public class CoyoteOutputStream
extends ServletOutputStream {
    private static final StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    protected OutputBuffer ob;

    public CoyoteOutputStream(OutputBuffer ob) {
        this.ob = ob;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    public void write(int i) throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.ob.writeByte(i);
    }

    public void write(byte[] b) throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.ob.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.ob.flush();
    }

    public void close() throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.ob.close();
    }

    public void print(String s) throws IOException {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        this.ob.write(s);
    }
}

