/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.obj;

import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.obj.GroupOfNames;
import com.sun.jndi.ldap.obj.LdapPrincipal;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.NamingManager;

public class GroupOfURLs
implements Group {
    private static final boolean debug = false;
    private static final String OBJECT_CLASS = "groupOfURLs";
    private static final String MEMBER_ATTR_ID = "memberURL";
    private static final String EXPAND_GROUP = "com.sun.jndi.ldap.obj.expandGroup";
    private static final String GROUPS_ONLY = "(|(objectClass=groupOfNames)(objectClass=groupOfURLs)(objectClass=groupOfUniqueNames))";
    private static final Attribute OBJECT_CLASS_ATTR = new BasicAttribute("objectClass", "top");
    private boolean objectIsBound;
    private boolean expandGroup = true;
    private Attributes attributes = null;
    private Attribute memberAttr = null;
    private SearchControls searchNoAttrs = null;
    private SearchControls objectSearch = null;
    private ModificationItem[] modification = new ModificationItem[1];
    private String groupDN = null;
    private String bindDN = null;
    private DirContext rootCtx = null;
    private DirContext ctx = null;
    private DirContext bindCtx = null;
    private Name name = null;
    private Name bindName = null;
    private Hashtable env = null;

    public GroupOfURLs() {
        this.objectIsBound = false;
        this.attributes = new BasicAttributes(true);
        this.attributes.put(OBJECT_CLASS_ATTR);
    }

    public GroupOfURLs(Set set) {
        this.objectIsBound = false;
        this.attributes = new BasicAttributes(true);
        this.attributes.put(OBJECT_CLASS_ATTR);
        if (set != null && !set.isEmpty()) {
            this.memberAttr = new BasicAttribute(MEMBER_ATTR_ID);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.memberAttr.add(iterator.next());
            }
            this.attributes.put(this.memberAttr);
        }
    }

    private GroupOfURLs(String string, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        this.initializeBoundState(string, dirContext, name, hashtable, attributes);
    }

    static Object getObjectInstance(String string, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        return new GroupOfURLs(string, dirContext, name, hashtable, attributes);
    }

    public boolean addMember(Principal principal) {
        throw new UnsupportedOperationException();
    }

    public void addMembers(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        this.modifyMembers(string, 1);
    }

    public boolean isMember(Principal principal) {
        try {
            return this.isMember(principal.getName());
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public boolean isMember(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        if (this.memberAttr != null || (this.memberAttr = this.ctx.getAttributes(this.name, new String[]{MEMBER_ATTR_ID}).get(MEMBER_ATTR_ID)) != null) {
            if (this.searchNoAttrs == null) {
                this.searchNoAttrs = new SearchControls();
                this.searchNoAttrs.setReturningAttributes(new String[0]);
            }
            NamingEnumeration<?> namingEnumeration = this.memberAttr.getAll();
            while (namingEnumeration.hasMoreElements()) {
                NamingEnumeration namingEnumeration2 = this.searchUsingLdapUrl((String)namingEnumeration.nextElement(), this.searchNoAttrs, string);
                if (namingEnumeration2 == null || !namingEnumeration2.hasMore()) continue;
                namingEnumeration2.close();
                return true;
            }
            if (this.expandGroup) {
                return this.isSubgroupMember(string);
            }
        }
        return false;
    }

    public Enumeration members() {
        try {
            return this.members(null);
        }
        catch (NamingException namingException) {
            return new Members();
        }
    }

    public Enumeration members(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        if (this.memberAttr != null || (this.memberAttr = this.ctx.getAttributes(this.name, new String[]{MEMBER_ATTR_ID}).get(MEMBER_ATTR_ID)) != null) {
            if (this.objectSearch == null) {
                this.objectSearch = new SearchControls();
                this.objectSearch.setReturningObjFlag(true);
            }
            return new Members(this.memberAttr.getAll(), string, this.objectSearch);
        }
        return new Members();
    }

    public boolean removeMember(Principal principal) {
        throw new UnsupportedOperationException();
    }

    public void removeMembers(String string) throws NamingException {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        this.modifyMembers(string, 3);
    }

    public String getName() {
        if (!this.isBound()) {
            throw new IllegalStateException();
        }
        return this.groupDN;
    }

    void setName(String string, DirContext dirContext, Name name) {
        this.bindDN = string;
        this.bindCtx = dirContext;
        this.bindName = name;
    }

    public String toString() {
        this.isBound();
        if (this.groupDN != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{name: ").append(this.groupDN).append("}");
            if (this.attributes != null) {
                stringBuffer.append(this.attributes.toString());
            }
            return stringBuffer.toString();
        }
        return this.attributes == null ? null : this.attributes.toString();
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    static boolean matches(Attribute attribute) {
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                if (!OBJECT_CLASS.equalsIgnoreCase((String)namingEnumeration.nextElement())) continue;
                return true;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return false;
    }

    private boolean isBound() {
        if (this.objectIsBound) {
            return true;
        }
        if (this.bindCtx != null && this.bindName != null && this.attributes != null) {
            try {
                Attributes attributes = this.bindCtx.getAttributes(this.bindName);
                Attribute attribute = attributes.get("objectClass");
                if (attribute != null && attribute.equals(this.attributes.get("objectClass"))) {
                    this.initializeBoundState(this.bindDN, this.bindCtx, this.bindName, this.env, attributes);
                    return true;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.bindDN = null;
            this.bindCtx = null;
            this.bindName = null;
        }
        return false;
    }

    public void close() throws NamingException {
        if (this.rootCtx != null && this.rootCtx != this.ctx) {
            this.rootCtx.close();
            this.rootCtx = null;
        }
    }

    private void initializeBoundState(String string, DirContext dirContext, Name name, Hashtable hashtable, Attributes attributes) {
        String string2;
        this.objectIsBound = true;
        this.groupDN = string;
        this.ctx = dirContext;
        this.name = name;
        this.env = hashtable;
        if (hashtable == null && dirContext != null) {
            try {
                this.env = dirContext.getEnvironment();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (hashtable != null && "false".equalsIgnoreCase(string2 = (String)hashtable.get(EXPAND_GROUP))) {
            this.expandGroup = false;
        }
        this.attributes = attributes;
        this.memberAttr = attributes != null ? attributes.get(MEMBER_ATTR_ID) : null;
    }

    private void modifyMembers(String string, int n) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(MEMBER_ATTR_ID, string);
        this.modification[0] = new ModificationItem(n, basicAttribute);
        this.ctx.modifyAttributes(this.name, this.modification);
        this.memberAttr = null;
    }

    private boolean isSubgroupMember(String string) throws NamingException {
        NamingEnumeration namingEnumeration = (NamingEnumeration)this.members(GROUPS_ONLY);
        while (namingEnumeration.hasMore()) {
            Object t = namingEnumeration.next();
            if (t instanceof GroupOfNames && ((GroupOfNames)t).isMember(string)) {
                namingEnumeration.close();
                return true;
            }
            if (!(t instanceof GroupOfURLs) || !((GroupOfURLs)t).isMember(string)) continue;
            namingEnumeration.close();
            return true;
        }
        return false;
    }

    private NamingEnumeration searchUsingLdapUrl(String string, SearchControls searchControls, String string2) throws NamingException {
        return this.searchUsingLdapUrl(string2, string, null, searchControls);
    }

    private NamingEnumeration searchUsingLdapUrl(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.searchUsingLdapUrl(null, string, string2, searchControls);
    }

    private NamingEnumeration searchUsingLdapUrl(String string, String string2, String string3, SearchControls searchControls) throws NamingException {
        Object object;
        LdapURL ldapURL = new LdapURL(string2);
        String string4 = ldapURL.getFilter();
        Object[] objectArray = null;
        if (string != null) {
            object = GroupOfURLs.restrictFilter(string4, string);
            string4 = (String)((ArrayList)object).remove(((ArrayList)object).size() - 1);
            objectArray = ((ArrayList)object).toArray();
        } else if (string3 != null) {
            object = new StringBuffer(string4.length() + string3.length() + 3);
            string4 = ((StringBuffer)object).append("(&").append(string4).append(string3).append(")").toString();
        }
        object = ldapURL.getScope();
        if ("sub".equalsIgnoreCase((String)object)) {
            searchControls.setSearchScope(2);
        } else if ("base".equalsIgnoreCase((String)object)) {
            searchControls.setSearchScope(0);
        } else if ("one".equalsIgnoreCase((String)object)) {
            searchControls.setSearchScope(1);
        }
        if (this.rootCtx == null) {
            if (this.ctx.getNameInNamespace().length() == 0) {
                this.rootCtx = this.ctx;
            } else {
                this.env = GroupOfNames.generateRootContextProperties(this.env);
                this.rootCtx = (DirContext)NamingManager.getInitialContext(this.env);
                if (this.ctx instanceof LdapContext) {
                    ((LdapContext)this.rootCtx).setRequestControls(((LdapContext)this.ctx).getRequestControls());
                }
            }
        }
        return string != null ? this.rootCtx.search(ldapURL.getDN(), string4, objectArray, searchControls) : this.rootCtx.search(ldapURL.getDN(), string4, searchControls);
    }

    private static ArrayList restrictFilter(String string, String string2) throws InvalidNameException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2 * string2.length());
        stringBuffer.append("(&").append(string);
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LdapName ldapName = new LdapName(string2);
        for (int i = n = ldapName.size(); i > 0; --i) {
            String string3 = ldapName.get(i - 1);
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string3.indexOf(43, n4)) >= 0 && string3.charAt(n3 - 1) != '\\') {
                arrayList.add(GroupOfURLs.appendFilterComponent(stringBuffer, n2++, string3.substring(n4, n3), i == n));
                n4 = n3 + 1;
            }
            if (n4 == 0) {
                string3 = string3.substring(n4);
            }
            arrayList.add(GroupOfURLs.appendFilterComponent(stringBuffer, n2++, string3, i == n));
        }
        stringBuffer.append(")");
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    private static Object appendFilterComponent(StringBuffer stringBuffer, int n, String string, boolean bl) {
        int n2 = string.indexOf(61);
        String string2 = string.substring(0, n2);
        Object object = LdapName.unescapeAttributeValue(string.substring(n2 + 1));
        if (bl) {
            stringBuffer.append("(").append(string2).append("={").append(n).append("})");
        } else {
            stringBuffer.append("(").append(string2).append(":dn:={").append(n).append("})");
        }
        return object;
    }

    static {
        OBJECT_CLASS_ATTR.add(OBJECT_CLASS);
    }

    class Members
    implements NamingEnumeration {
        private NamingEnumeration memberUrls = null;
        private String filter = null;
        private SearchControls searchControls = null;
        private NamingEnumeration results = null;
        private boolean expandSubgroups;
        private ArrayList subgroups = null;
        private NamingEnumeration subgroupMembers = null;

        Members() {
            this.expandSubgroups = GroupOfURLs.this.expandGroup;
        }

        Members(NamingEnumeration namingEnumeration, String string, SearchControls searchControls) {
            this.memberUrls = namingEnumeration;
            this.filter = string;
            this.searchControls = searchControls;
            this.expandSubgroups = GroupOfURLs.this.expandGroup;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        public boolean hasMore() throws NamingException {
            if (this.memberUrls == null) {
                return false;
            }
            if (this.results == null) {
                this.results = GroupOfURLs.this.searchUsingLdapUrl((String)this.memberUrls.next(), this.filter, this.searchControls);
            }
            if (this.results.hasMore()) {
                return true;
            }
            if (this.memberUrls.hasMore()) {
                this.results = GroupOfURLs.this.searchUsingLdapUrl((String)this.memberUrls.next(), this.filter, this.searchControls);
                if (this.hasMore()) {
                    return true;
                }
            }
            if (this.expandSubgroups && this.subgroups != null) {
                if (this.subgroupMembers == null && !this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                }
                if (this.subgroupMembers.hasMore()) {
                    return true;
                }
                if (!this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                    return this.subgroupMembers.hasMore();
                }
            }
            return false;
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException(namingException.toString());
            }
        }

        public Object next() throws NamingException {
            if (this.memberUrls == null) {
                throw new NoSuchElementException();
            }
            if (this.results == null) {
                this.results = GroupOfURLs.this.searchUsingLdapUrl((String)this.memberUrls.next(), this.filter, this.searchControls);
            }
            if (this.results.hasMore()) {
                Object object = ((SearchResult)this.results.next()).getObject();
                if (object instanceof Group) {
                    if (this.expandSubgroups) {
                        if (this.subgroups == null) {
                            this.subgroups = new ArrayList();
                        }
                        this.subgroups.add(object);
                    }
                    return (Group)object;
                }
                if (object instanceof DirContext) {
                    String string = ((DirContext)object).getNameInNamespace();
                    ((DirContext)object).close();
                    return new LdapPrincipal(string);
                }
                return object;
            }
            if (this.memberUrls.hasMore()) {
                this.results = GroupOfURLs.this.searchUsingLdapUrl((String)this.memberUrls.next(), this.filter, this.searchControls);
                if (this.hasMore()) {
                    return this.next();
                }
            }
            if (this.expandSubgroups && this.subgroups != null) {
                if (this.subgroupMembers == null && !this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                }
                if (this.subgroupMembers.hasMore()) {
                    return this.subgroupMembers.next();
                }
                if (!this.subgroups.isEmpty()) {
                    this.subgroupMembers = (NamingEnumeration)((Group)this.subgroups.remove(0)).members();
                    return this.subgroupMembers.next();
                }
            }
            throw new NoSuchElementException();
        }

        public void close() throws NamingException {
            if (this.results != null) {
                this.results.close();
            }
            if (this.subgroupMembers != null) {
                this.subgroupMembers.close();
            }
        }
    }
}

