/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONParser {
    private JSONParser() {
    }

    public static String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        JSONParser.append(buffer, object);
        return buffer.toString();
    }

    public static String toString(Map object) {
        StringBuffer buffer = new StringBuffer();
        JSONParser.appendMap(buffer, object);
        return buffer.toString();
    }

    public static String toString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        JSONParser.appendArray(buffer, array);
        return buffer.toString();
    }

    public static Object parse(String s) {
        return JSONParser.parse(new Source(s));
    }

    public static void append(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Generator) {
            JSONParser.appendJSON(buffer, (Generator)object);
        } else if (object instanceof Map) {
            JSONParser.appendMap(buffer, (Map)object);
        } else if (object instanceof List) {
            JSONParser.appendArray(buffer, ((List)object).toArray());
        } else if (object.getClass().isArray()) {
            JSONParser.appendArray(buffer, object);
        } else if (object instanceof Number) {
            JSONParser.appendNumber(buffer, (Number)object);
        } else if (object instanceof Boolean) {
            JSONParser.appendBoolean(buffer, (Boolean)object);
        } else if (object instanceof String) {
            JSONParser.appendString(buffer, (String)object);
        } else {
            JSONParser.appendString(buffer, object.toString());
        }
    }

    private static void appendNull(StringBuffer buffer) {
        buffer.append("null");
    }

    private static void appendJSON(StringBuffer buffer, Generator generator) {
        generator.addJSON(buffer);
    }

    private static void appendMap(StringBuffer buffer, Map object) {
        if (object == null) {
            JSONParser.appendNull(buffer);
            return;
        }
        buffer.append('{');
        Iterator iter = object.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            JSONParser.quote(buffer, entry.getKey().toString());
            buffer.append(':');
            JSONParser.append(buffer, entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
    }

    private static void appendArray(StringBuffer buffer, Object array) {
        if (array == null) {
            JSONParser.appendNull(buffer);
            return;
        }
        buffer.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            JSONParser.append(buffer, Array.get(array, i));
        }
        buffer.append(']');
    }

    private static void appendBoolean(StringBuffer buffer, Boolean b) {
        if (b == null) {
            JSONParser.appendNull(buffer);
            return;
        }
        buffer.append(b != false ? "true" : "false");
    }

    private static void appendNumber(StringBuffer buffer, Number number) {
        if (number == null) {
            JSONParser.appendNull(buffer);
            return;
        }
        buffer.append(number);
    }

    private static void appendString(StringBuffer buffer, String string) {
        if (string == null) {
            JSONParser.appendNull(buffer);
            return;
        }
        JSONParser.quote(buffer, string);
    }

    private static Object parse(Source source) {
        int comment_state = 0;
        while (source.hasNext()) {
            char c = source.peek();
            if (comment_state == 1) {
                switch (c) {
                    case '/': {
                        comment_state = -1;
                        break;
                    }
                    case '*': {
                        comment_state = 2;
                    }
                }
            } else if (comment_state > 1) {
                switch (c) {
                    case '*': {
                        comment_state = 3;
                        break;
                    }
                    case '/': {
                        if (comment_state == 3) {
                            comment_state = 0;
                            break;
                        }
                        comment_state = 2;
                        break;
                    }
                    default: {
                        comment_state = 2;
                        break;
                    }
                }
            } else if (comment_state < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        comment_state = 0;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '{': {
                        return JSONParser.parseObject(source);
                    }
                    case '[': {
                        return JSONParser.parseArray(source);
                    }
                    case '\"': {
                        return JSONParser.parseString(source);
                    }
                    case '-': {
                        return JSONParser.parseNumber(source);
                    }
                    case 'n': {
                        JSONParser.complete("null", source);
                        return null;
                    }
                    case 't': {
                        JSONParser.complete("true", source);
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        JSONParser.complete("false", source);
                        return Boolean.FALSE;
                    }
                    case '/': {
                        comment_state = 1;
                        break;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            return JSONParser.parseNumber(source);
                        }
                        if (Character.isWhitespace(c)) break;
                        throw new IllegalStateException("unknown char " + c);
                    }
                }
            }
            source.next();
        }
        return null;
    }

    private static Map parseObject(Source source) {
        if (source.next() != '{') {
            throw new IllegalStateException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        char next = JSONParser.seekTo("\"}", source);
        while (source.hasNext()) {
            if (next == '}') {
                source.next();
                break;
            }
            String name = JSONParser.parseString(source);
            JSONParser.seekTo(':', source);
            source.next();
            Object value = JSONParser.parse(source);
            map.put(name, value);
            JSONParser.seekTo(",}", source);
            next = source.next();
            if (next == '}') break;
            next = JSONParser.seekTo("\"}", source);
        }
        return map;
    }

    private static Object parseArray(Source source) {
        if (source.next() != '[') {
            throw new IllegalStateException();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean coma = true;
        while (source.hasNext()) {
            char c = source.peek();
            switch (c) {
                case ']': {
                    source.next();
                    return list.toArray(new Object[list.size()]);
                }
                case ',': {
                    if (coma) {
                        throw new IllegalStateException();
                    }
                    coma = true;
                    source.next();
                }
            }
            if (Character.isWhitespace(c)) {
                source.next();
                continue;
            }
            coma = false;
            list.add(JSONParser.parse(source));
        }
        throw new IllegalStateException("unexpected end of array");
    }

    private static String parseString(Source source) {
        if (source.next() != '\"') {
            throw new IllegalStateException();
        }
        boolean escape = false;
        StringBuffer b = new StringBuffer();
        block8: while (source.hasNext()) {
            char c = source.next();
            if (escape) {
                escape = false;
                switch (c) {
                    case 'n': {
                        b.append('\n');
                        continue block8;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block8;
                    }
                    case 't': {
                        b.append('\t');
                        continue block8;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block8;
                    }
                    case 'b': {
                        b.append('\b');
                        continue block8;
                    }
                    case 'u': {
                        b.append((char)((JSONParser.convertHexDigit((byte)source.next()) << 24) + (JSONParser.convertHexDigit((byte)source.next()) << 16) + (JSONParser.convertHexDigit((byte)source.next()) << 8) + JSONParser.convertHexDigit((byte)source.next())));
                        continue block8;
                    }
                }
                b.append(c);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') break;
            b.append(c);
        }
        return b.toString();
    }

    private static Number parseNumber(Source source) {
        String s;
        int start = source.index();
        int end = -1;
        boolean is_double = false;
        block4: while (source.hasNext() && end < 0) {
            char c = source.peek();
            switch (c) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    source.next();
                    continue block4;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    is_double = true;
                    source.next();
                    continue block4;
                }
            }
            end = source.index();
        }
        String string = s = end >= 0 ? source.from(start, end) : source.from(start);
        if (is_double) {
            return new Double(s);
        }
        return new Long(s);
    }

    private static void seekTo(char seek, Source source) {
        while (source.hasNext()) {
            char c = source.peek();
            if (c == seek) {
                return;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + " while seeking '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected '" + seek + "'");
    }

    private static char seekTo(String seek, Source source) {
        while (source.hasNext()) {
            char c = source.peek();
            if (seek.indexOf(c) >= 0) {
                return c;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + "' while seeking one of '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected one of '" + seek + "'");
    }

    private static void complete(String seek, Source source) {
        int i = 0;
        while (source.hasNext() && i < seek.length()) {
            char c = source.next();
            if (c == seek.charAt(i++)) continue;
            throw new IllegalStateException("Unexpected '" + c + " while seeking  \"" + seek + "\"");
        }
        if (i < seek.length()) {
            throw new IllegalStateException("Expected \"" + seek + "\"");
        }
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        StringBuffer b = new StringBuffer(s.length() + 8);
        JSONParser.quote(b, s);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer buf, String s) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append('\"');
            block12: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block12;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block12;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block12;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block12;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block12;
                    }
                    default: {
                        buf.append(c);
                        continue block12;
                    }
                }
            }
            buf.append('\"');
        }
    }

    public static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static class Literal
    implements Generator {
        private String _json;

        public Literal(String json) {
            JSONParser.parse(json);
            this._json = json;
        }

        public String toString() {
            return this._json;
        }

        public void addJSON(StringBuffer buffer) {
            buffer.append(this._json);
        }
    }

    public static interface Generator {
        public void addJSON(StringBuffer var1);
    }

    private static class Source {
        private final String string;
        private int index;

        Source(String s) {
            this.string = s;
        }

        boolean hasNext() {
            return this.index < this.string.length();
        }

        char next() {
            return this.string.charAt(this.index++);
        }

        char peek() {
            return this.string.charAt(this.index);
        }

        int index() {
            return this.index;
        }

        String from(int mark) {
            return this.string.substring(mark, this.index);
        }

        String from(int mark, int end) {
            return this.string.substring(mark, end);
        }
    }
}

