/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import com.sun.logging.LogDomains;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.security.PasswordCredential;

public class ManagedConnectionMetaData
implements javax.resource.spi.ManagedConnectionMetaData {
    private DatabaseMetaData dmd = null;
    private ManagedConnection mc;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private boolean debug = false;

    public ManagedConnectionMetaData(ManagedConnection mc) throws ResourceException {
        try {
            this.mc = mc;
            this.dmd = mc.getActualConnection().getMetaData();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_md", sqle);
            throw new ResourceException(sqle.getMessage());
        }
    }

    public String getEISProductName() throws ResourceException {
        try {
            return this.dmd.getDatabaseProductName();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_prodname", sqle);
            throw new ResourceException(sqle.getMessage());
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            return this.dmd.getDatabaseProductVersion();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_prodvers", sqle);
            throw new ResourceException(sqle.getMessage(), sqle.getMessage());
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            return this.dmd.getMaxConnections();
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_eis_maxconn");
            throw new ResourceException(sqle.getMessage());
        }
    }

    public String getUserName() throws ResourceException {
        PasswordCredential pc = this.mc.getPasswordCredential();
        if (pc != null) {
            return pc.getUserName();
        }
        return this.mc.getManagedConnectionFactory().getUser();
    }
}

