/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WsTxUtils {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    public static String getDefaultVirtualServerHostAndPort(boolean secure) {
        String host = WsTxUtils.getHostName();
        String port = WsTxUtils.getPort(secure);
        if (host == null || port == null) {
            return null;
        }
        return host + ":" + port;
    }

    private static String getHostName() {
        return System.getProperty("com.sun.aas.hostName");
    }

    private static String getPort(boolean secure) {
        try {
            HttpListener[] listeners;
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            String serverName = System.getProperty("com.sun.aas.instanceName");
            Config config = ServerHelper.getConfigForServer(configContext, serverName);
            for (HttpListener listener : listeners = config.getHttpService().getHttpListener()) {
                if (secure && listener.isSecurityEnabled()) {
                    return listener.getPort();
                }
                if (secure || listener.isSecurityEnabled()) continue;
                return listener.getPort();
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINEST, "Exception occurred retrieving port configuration for WSTX service", t);
        }
        return null;
    }
}

