/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.JAXWSServletModule;
import com.sun.enterprise.webservice.ResourceInjectorImpl;
import com.sun.enterprise.webservice.ServerPipeCreator;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.ServerPipelineHook;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletModule;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSContainer
extends Container {
    private final ServletContext servletContext;
    private final WebServiceEndpoint endpoint;
    private final JAXWSServletModule module;

    public JAXWSContainer(ServletContext servletContext, WebServiceEndpoint ep) {
        this.servletContext = servletContext;
        this.endpoint = ep;
        this.module = servletContext != null ? JAXWSServletModule.getServletModule(servletContext.getContextPath()) : null;
    }

    public void addEndpoint(WSEndpoint wsEndpoint) {
        if (this.module != null) {
            this.module.addEndpoint(this.endpoint.getEndpointAddressUri(), wsEndpoint);
        }
    }

    public <T> T getSPI(Class<T> spiType) {
        if (spiType == ServletContext.class) {
            return (T)this.servletContext;
        }
        if (spiType == ServerPipelineHook.class || spiType == com.sun.xml.ws.assembler.ServerPipelineHook.class) {
            return (T)((Object)new ServerPipeCreator(this.endpoint));
        }
        if (spiType == ResourceInjector.class && this.endpoint.implementedByWebComponent()) {
            return (T)((Object)new ResourceInjectorImpl(this.endpoint));
        }
        if (spiType.isAssignableFrom(ServletModule.class) && this.module != null) {
            return spiType.cast((Object)this.module);
        }
        return null;
    }
}

