/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.enterprise.web.connector.coyote.PECoyoteResponse;
import com.sun.enterprise.web.connector.coyote.PwcCoyoteRequest;
import com.sun.enterprise.web.connector.extension.GrizzlyConfig;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.MapperListener;

public class PECoyoteConnector
extends CoyoteConnector {
    private static final String USE_COYOTE_CONNECTOR = "com.sun.enterprise.web.connector.useCoyoteConnector";
    private static final String GRIZZLY_CONNECTOR = "com.sun.enterprise.web.connector.grizzly.GrizzlyHttpProtocol";
    protected boolean recycleObjects;
    protected int maxAcceptWorkerThreads;
    protected int maxReadWorkerThreads;
    protected int processorWorkerThreadsTimeout;
    protected int minProcessorWorkerThreadsIncrement;
    protected int minAcceptQueueLength;
    protected int minReadQueueLength;
    protected int minProcessorQueueLength;
    protected boolean useDirectByteBuffer;
    private boolean coyoteOn = false;
    private int keepAliveTimeoutInSeconds;
    private int keepAliveThreadCount;
    private boolean chunkingDisabled;
    private int queueSizeInBytes = 4096;
    protected int ssBackLog = 4096;
    public int selectorReadThreadsCount = 0;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    private GrizzlyConfig grizzlyMonitor;
    private String domain;
    private String rootFolder = "";
    private String name;
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = 2048L;
    private long maxEntrySize = 537600L;
    private long maxLargeFileCacheSize = 0xA00000L;
    private long maxSmallFileCacheSize = 0x100000L;
    private boolean fileCacheEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private String crlFile;
    private String trustAlgorithm;
    private String trustMaxCertLength;
    private Logger logger;

    public PECoyoteConnector() {
        boolean coyoteOn = false;
        if (System.getProperty(USE_COYOTE_CONNECTOR) != null) {
            coyoteOn = Boolean.valueOf(System.getProperty(USE_COYOTE_CONNECTOR));
        }
        if (!coyoteOn) {
            this.setProtocolHandlerClassName(GRIZZLY_CONNECTOR);
        }
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        this.chunkingDisabled = chunkingDisabled;
    }

    public boolean isChunkingDisabled() {
        return this.chunkingDisabled;
    }

    public Request createRequest() {
        PwcCoyoteRequest request = new PwcCoyoteRequest();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        PECoyoteResponse response = new PECoyoteResponse(this.isChunkingDisabled());
        response.setConnector(this);
        return response;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.setProperty("keepAliveTimeoutInSeconds", String.valueOf(timeout));
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.keepAliveThreadCount = threadCount;
        this.setProperty("keepAliveThreadCount", String.valueOf(threadCount));
    }

    public void setQueueSizeInBytes(int queueSizeInBytes) {
        this.queueSizeInBytes = queueSizeInBytes;
        this.setProperty("queueSizeInBytes", queueSizeInBytes);
    }

    public int getQueueSizeInBytes() {
        return this.queueSizeInBytes;
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
        this.setProperty("socketServerBacklog", ssBackLog);
    }

    public int getSocketServerBacklog() {
        return this.ssBackLog;
    }

    public void setRecycleObjects(boolean recycleObjects) {
        this.recycleObjects = recycleObjects;
        this.setProperty("recycleObjects", String.valueOf(recycleObjects));
    }

    public boolean getRecycleObjects() {
        return this.recycleObjects;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
        this.setProperty("maxReadWorkerThreads", String.valueOf(maxReadWorkerThreads));
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public void setMaxAcceptWorkerThreads(int maxAcceptWorkerThreads) {
        this.maxAcceptWorkerThreads = maxAcceptWorkerThreads;
        this.setProperty("maxAcceptWorkerThreads", String.valueOf(maxAcceptWorkerThreads));
    }

    public int getMaxAcceptWorkerThreads() {
        return this.maxAcceptWorkerThreads;
    }

    public void setMinAcceptQueueLength(int minAcceptQueueLength) {
        this.minAcceptQueueLength = minAcceptQueueLength;
        this.setProperty("minAcceptQueueLength", String.valueOf(minAcceptQueueLength));
    }

    public int getMinAcceptQueueLength() {
        return this.minAcceptQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
        this.setProperty("minReadQueueLength", String.valueOf(minReadQueueLength));
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
        this.setProperty("minProcessorQueueLength", String.valueOf(minProcessorQueueLength));
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.setProperty("useDirectByteBuffer", String.valueOf(useDirectByteBuffer));
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.processorWorkerThreadsTimeout = timeout;
        this.setProperty("processorWorkerThreadsTimeout", String.valueOf(timeout));
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.processorWorkerThreadsTimeout;
    }

    public void setProcessorWorkerThreadsIncrement(int increment) {
        this.minProcessorWorkerThreadsIncrement = increment;
        this.setProperty("processorThreadsIncrement", String.valueOf(increment));
    }

    public int getMinProcessorWorkerThreadsIncrement() {
        return this.minProcessorWorkerThreadsIncrement;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.setProperty("selectorReadThreadsCount", String.valueOf(selectorReadThreadsCount));
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
        this.setProperty("defaultResponseType", defaultResponseType);
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedResponseType) {
        this.forcedRequestType = forcedResponseType;
        this.setProperty("forcedRequestType", forcedResponseType);
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.initConfig();
            this.grizzlyMonitor.registerMonitoringLevelEvents();
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.unregisterMonitoringLevelEvents();
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
        this.setProperty("secondsMaxAge", String.valueOf(this.secondsMaxAge));
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
        this.setProperty("maxCacheEntries", String.valueOf(this.maxCacheEntries));
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
        this.setProperty("minEntrySize", String.valueOf(this.minEntrySize));
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
        this.setProperty("maxEntrySize", String.valueOf(this.maxEntrySize));
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
        this.setProperty("maxLargeFileCacheSize", String.valueOf(this.maxLargeFileCacheSize));
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
        this.setProperty("maxSmallFileCacheSize", String.valueOf(this.maxSmallFileCacheSize));
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.fileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
        this.setProperty("fileCacheEnabled", String.valueOf(fileCacheEnabled));
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
        this.setProperty("largeFileCacheEnabled", String.valueOf(this.isLargeFileCacheEnabled));
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        this.rootFolder = rootFolder;
        this.setProperty("webAppRootPath", rootFolder);
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void initialize() throws LifecycleException {
        super.initialize();
        if (!this.getProtocolHandler().getClass().getName().equals(GRIZZLY_CONNECTOR)) {
            return;
        }
        this.grizzlyMonitor = new GrizzlyConfig(this.domain, this.getPort());
        try {
            Method loggerMethod = this.getProtocolHandler().getClass().getMethod("setLogger", Logger.class);
            loggerMethod.invoke((Object)this.getProtocolHandler(), this.logger);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Unable to set logger on " + this.getProtocolHandler(), ex);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTruststore(String truststore) {
        this.setProperty("truststore", truststore);
    }

    public String getTruststore() {
        return (String)this.getProperty("truststore");
    }

    public void setTruststoreType(String type) {
        this.setProperty("truststoreType", type);
    }

    public String getTruststoreType() {
        return (String)this.getProperty("truststoreType");
    }

    public void setKeystoreType(String type) {
        this.setProperty("keystoreType", type);
    }

    public String getKeystoreType() {
        return (String)this.getProperty("keystoreType");
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
        this.setProperty("crlFile", crlFile);
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String trustAlgorithm) {
        this.trustAlgorithm = trustAlgorithm;
        this.setProperty("truststoreAlgorithm", trustAlgorithm);
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
        this.setProperty("trustMaxCertLength", trustMaxCertLength);
    }

    public MapperListener getMapperListener() {
        return this.mapperListener;
    }
}

