/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.LifecycleStarter;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;

public class VirtualServer
extends StandardHost {
    public static final String ADMIN_VS = "__asadmin";
    static final String STATE = "state";
    static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    static final String DISABLED = "disabled";
    static final String OFF = "off";
    static final String ON = "on";
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline = this.pipeline;
    private String _id = null;
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    protected boolean _debug = false;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;
    private String[] cacheControls;
    private boolean isActive;
    private PWCRequestStatsImpl pwcRequestStatsImpl;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;

    public VirtualServer() {
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public String getInfo() {
        return _info;
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
        Switch sw = Switch.getSwitch();
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                sw.removeDescriptorFor(children[i]);
            }
        }
    }

    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void removeValve(Valve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    protected List getWebModules(Server serverBean, String modulesRoot) {
        WebModule[] wmBeans;
        Vector<WebModuleConfig> modules = new Vector<WebModuleConfig>();
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(serverBean.getConfigContext());
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            Object[] params = new Object[]{this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (appsBean != null && (wmBeans = appsBean.getWebModule()) != null && wmBeans.length > 0) {
            for (int i = 0; i < wmBeans.length; ++i) {
                WebModule wm = wmBeans[i];
                if (this.isActive(wm)) {
                    WebModuleConfig wmInfo;
                    ApplicationRef ref = serverBean.getApplicationRefByRef(wm.getName());
                    if (ref == null) continue;
                    String location = wm.getLocation();
                    File moduleBase = new File(location);
                    if (!moduleBase.isAbsolute()) {
                        location = modulesRoot + File.separator + location;
                        wm.setLocation(location);
                    }
                    if ((wmInfo = this.loadWebModuleConfig(wm)) == null) continue;
                    modules.add(wmInfo);
                    continue;
                }
                if (!this._debug) continue;
                _logger.finer("Web Module [" + wm.getName() + "] is not applicable for virtual " + " server [" + this.getID() + "]");
            }
        }
        return modules;
    }

    protected String getDefaultContextPath(Server serverBean) {
        Object[] params;
        String contextRoot = null;
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(serverBean.getConfigContext());
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            params = new Object[]{this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            WebModule wm;
            WebModuleConfig wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID);
            if (wmInfo == null) {
                wm = appsBean.getWebModuleByName(wmID);
                if (wm != null) {
                    if (this.isActive(wm, false)) {
                        contextRoot = wm.getContextRoot();
                    } else {
                        Object[] params2 = new Object[]{wmID, this.getID()};
                        _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params2);
                    }
                }
            } else {
                wm = wmInfo.getBean();
                contextRoot = wm.getContextRoot();
            }
            if (contextRoot == null) {
                params = new Object[]{wmID, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
            }
        }
        return contextRoot;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary() {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            wmInfo = new WebModuleConfig();
            WebModule wm = new WebModule();
            wm.setName("__default-web-module");
            wm.setContextRoot("");
            wm.setLocation(docroot);
            wmInfo.setBean(wm);
            wmInfo.setDescriptor(DOLLoadingContextFactory.getDefaultWebBundleDescriptor());
            WebBundleDescriptor wbd = wmInfo.getDescriptor();
            if (wbd.getApplication() == null) {
                Application application = new Application();
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        try {
            WebModulesManager webModulesManager = new WebModulesManager(ApplicationServer.getServerContext().getInstanceEnvironment());
            Application app = webModulesManager.getDescriptor(wmID, location);
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            wmInfo.setDescriptor(wbd);
        }
        catch (ConfigException ce) {
            wmInfo = null;
            String msg = _rb.getString("vs.moduleConfigError");
            Object[] params = new Object[]{wmID, this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, ce);
        }
        return wmInfo;
    }

    private boolean isActive(WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= wm.isEnabled();
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals(ADMIN_VS) && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = matchVSID && vsIDs != null && vsIDs.length() > 0 ? ((vsList = StringUtils.parseStringList(vsIDs, " ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = null;
        if (this.vsBean != null) {
            wmID = this.vsBean.getDefaultWebModule();
            if (wmID != null && this._debug) {
                Object[] params = new Object[]{wmID, this._id};
                _logger.log(Level.FINE, "vs.defaultWebModule", params);
            }
        } else {
            _logger.log(Level.SEVERE, "vs.configError", this._id);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id) {
        WebModuleConfig wmInfo = null;
        int length = id.length();
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            J2eeApplication j2eeApp = appsBean.getJ2eeApplicationByName(appID);
            if (j2eeApp != null && j2eeApp.isEnabled()) {
                Application appDesc;
                String location = j2eeApp.getLocation();
                String moduleDir = DeploymentUtils.getRelativeEmbeddedModulePath(location, moduleID);
                ApplicationRegistry registry = ApplicationRegistry.getInstance();
                ClassLoader appLoader = registry.getClassLoaderForApplication(appID);
                if (appLoader != null && (appDesc = registry.getApplication(appLoader)) != null) {
                    Set wbds = appDesc.getWebBundleDescriptors();
                    WebBundleDescriptor wbd2 = null;
                    for (WebBundleDescriptor wbd2 : wbds) {
                        String webUri = wbd2.getModuleDescriptor().getArchiveUri();
                        if (!moduleID.equals(webUri)) continue;
                        StringBuffer dir = new StringBuffer(location);
                        dir.append(File.separator);
                        dir.append(moduleDir);
                        WebModule wm = new WebModule();
                        wm.setName(moduleID);
                        wm.setContextRoot(wbd2.getContextRoot());
                        wm.setLocation(dir.toString());
                        wm.setEnabled(true);
                        String vsList = this.getVirtualServers(j2eeApp.getName());
                        wmInfo = new WebModuleConfig();
                        wmInfo.setBean(wm);
                        wmInfo.setDescriptor(wbd2);
                        wmInfo.setParentLoader(appLoader);
                        wmInfo.setVirtualServers(vsList);
                        break;
                    }
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
            }
        }
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            ret = ServerBeansFactory.getVirtualServersByAppName(ctx, appName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "Cannot get virtual server for " + appName, ce);
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    ElementProperty[] getProperties() {
        if (this.vsBean != null) {
            return this.vsBean.getElementProperty();
        }
        return null;
    }

    public void setPWCRequestStatsImpl(PWCRequestStatsImpl pwcRequestStatsImpl) {
        this.pwcRequestStatsImpl = pwcRequestStatsImpl;
    }

    public PWCRequestStatsImpl getPWCRequestStatsImpl() {
        return this.pwcRequestStatsImpl;
    }

    protected void configureCatalinaProperties() {
        ElementProperty[] props = this.vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            }
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList(this.vsBean.getHosts(), ",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        ElementProperty prop = this.vsBean.getElementPropertyByName("authRealm");
        if (prop != null && prop.getValue() != null) {
            if (securityService.getAuthRealmByName(prop.getValue()) != null) {
                this.authRealmName = prop.getValue();
            } else {
                _logger.log(Level.SEVERE, "vs.invalidAuthRealm", new Object[]{this.getID(), prop.getValue()});
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Valve valve = (Valve)this.loadInstance(valveName);
        if (valve == null) {
            return;
        }
        super.addValve(valve);
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            _logger.log(Level.SEVERE, "webcontainer.invalidListener" + listenerName);
        }
    }

    private Object loadInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "webcontainer.unableToLoadExtension", ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        if (this.vsBean == null) {
            return;
        }
        ElementProperty[] props = this.vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", propValue);
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        if (this.vsBean == null) {
            return;
        }
        ElementProperty[] props = this.vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", propValue);
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", propValue);
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", propValue);
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    _logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", propValue);
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline(this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSSOValve(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory) {
        if (this.vsBean == null) {
            return;
        }
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            Object[] params = new Object[]{this.getID()};
            _logger.log(Level.INFO, "webcontainer.ssodisabled", params);
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            try {
                ElementProperty expireTime;
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                String vsName = this.getName();
                SingleSignOn sso = ssoFactory.createSingleSignOnValve(vsName);
                ElementProperty idle = this.vsBean.getElementPropertyByName(SSO_MAX_IDLE);
                if (idle != null && idle.getValue() != null) {
                    _logger.fine("SSO entry max idle time set to: " + idle.getValue());
                    int i = Integer.parseInt(idle.getValue());
                    sso.setMaxInactive(i);
                }
                if ((expireTime = this.vsBean.getElementPropertyByName(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                    _logger.fine("SSO expire thread interval set to : " + expireTime.getValue());
                    int i = Integer.parseInt(expireTime.getValue());
                    sso.setReapInterval(i);
                }
                Valve[] valves = this.getValves();
                for (int i = 0; valves != null && i < valves.length; ++i) {
                    if (!(valves[i] instanceof SingleSignOn)) continue;
                    this.removeValve(valves[i]);
                    break;
                }
                this.addValve(sso);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "webcontainer.ssobadconfig", e);
                _logger.log(Level.WARNING, "webcontainer.ssodisabled", this.getID());
            }
        }
    }

    void configureVirtualServerState() {
        String stateValue = ON;
        if (this.vsBean != null) {
            stateValue = this.vsBean.getState();
        }
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase(ADMIN_VS)) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBean.toBoolean(stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        RemoteAddrValve remoteAddrValve = null;
        if (this.vsBean == null) {
            return;
        }
        ElementProperty allow = this.vsBean.getElementPropertyByName("allowRemoteAddress");
        ElementProperty deny = this.vsBean.getElementPropertyByName("denyRemoteAddress");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            remoteAddrValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            remoteAddrValve.setDeny(deny.getValue());
        }
        if (remoteAddrValve != null) {
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve(HttpProtocol httpProtocol) {
        RemoteHostValve remoteHostValve = null;
        if (this.vsBean == null) {
            return;
        }
        ElementProperty allow = this.vsBean.getElementPropertyByName("allowRemoteHost");
        ElementProperty deny = this.vsBean.getElementPropertyByName("denyRemoteHost");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            if (httpProtocol == null || !httpProtocol.isDnsLookupEnabled()) {
                _logger.log(Level.WARNING, "webcontainer.allowRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            if (httpProtocol == null || !httpProtocol.isDnsLookupEnabled()) {
                _logger.log(Level.WARNING, "webcontainer.denyRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setDeny(deny.getValue());
        }
        if (remoteHostValve != null) {
            Valve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteHostValve);
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, InstanceEnvironment instance, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, instance, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve(this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve(this.accessLogValve);
    }

    private boolean isAccessLogValveActivated() {
        Valve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList(cacheControl, ",")) != null && !values.isEmpty()) {
            String[] cacheControls = new String[values.size()];
            this.setCacheControls(values.toArray(cacheControls));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        ElementProperty ssoProperty = this.vsBean.getElementPropertyByName("sso-enabled");
        if (ssoProperty == null || ssoProperty.getValue() == null) {
            return globalSSOEnabled;
        }
        return ConfigBean.toBoolean(ssoProperty.getValue());
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        ElementProperty prop = this.vsBean.getElementPropertyByName("accessLoggingEnabled");
        if (prop == null || prop.getValue() == null) {
            return globalAccessLoggingEnabled;
        }
        return ConfigBean.toBoolean(prop.getValue());
    }

    protected void startChildren() {
        ArrayList<LifecycleStarter> starters = new ArrayList<LifecycleStarter>();
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            LifecycleStarter starter = new LifecycleStarter((Lifecycle)((Object)children[i]));
            starters.add(starter);
            starter.submit();
        }
        for (LifecycleStarter starter : starters) {
            Throwable t = starter.waitDone();
            if (t == null) continue;
            Lifecycle container = starter.getContainer();
            ((Context)((Object)container)).setAvailable(false);
            String msg = _rb.getString("vs.startContextError");
            msg = MessageFormat.format(msg, container, this.getID());
            _logger.log(Level.SEVERE, msg, t);
        }
    }
}

