/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AppPublicID
extends ApplicationTest
implements AppCheck {
    String[] acceptablePubidLiterals = new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN"};
    String[] acceptableURLs = new String[]{"http://java.sun.com/j2ee/dtds/application_1_2.dtd", "http://java.sun.com/dtd/application_1_3.dtd"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getSpecVersion().compareTo("1.4") < 0) {
            InputStream deploymentEntry = null;
            String uri = null;
            try {
                uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry("META-INF/application.xml");
                if (deploymentEntry == null) return result;
                BufferedReader in = new BufferedReader(new InputStreamReader(deploymentEntry));
                String s = in.readLine();
                boolean foundDOCTYPE = false;
                boolean foundPubid = false;
                boolean foundURL = false;
                while (s != null) {
                    if (s.indexOf("DOCTYPE") > -1) {
                        foundDOCTYPE = true;
                    }
                    if (foundDOCTYPE) {
                        for (int i = 0; i < this.acceptablePubidLiterals.length; ++i) {
                            if (s.indexOf(this.acceptablePubidLiterals[i]) > -1) {
                                foundPubid = true;
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The deployment descriptor has the proper PubidLiteral: {0}", new Object[]{this.acceptablePubidLiterals[i]}));
                            }
                            if (s.indexOf(this.acceptableURLs[i]) <= -1) continue;
                            foundURL = true;
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed1", "The deployment descriptor has the proper URL corresponding the the PubIdLiteral: {0}", new Object[]{this.acceptableURLs[i]}));
                        }
                    }
                    if (foundPubid && foundURL) {
                        result.setStatus(0);
                        break;
                    }
                    if (foundDOCTYPE && s.endsWith(">")) break;
                    s = in.readLine();
                }
                if (!foundDOCTYPE) {
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "No document type declaration found in the deployment descriptor for {0}", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (!foundPubid) {
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "The deployment descriptor for {0} does not have the expected PubidLiteral ", new Object[]{descriptor.getName()}));
                    return result;
                }
                if (foundURL) return result;
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The deployment descriptor {0} doesnot have the right URL corresponding to the PubIdLiteral", new Object[]{descriptor.getName()}));
                return result;
            }
            catch (IOException e) {
                result.failed(smh.getLocalString(this.getClass().getName() + ".IOException", "I/O error trying to open {0}", new Object[]{uri}));
                return result;
            }
            finally {
                try {
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (Exception x) {}
            }
        }
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT-APPLICABLE: No DOCTYPE found for [ {0} ]", new Object[]{descriptor.getName()}));
        return result;
    }
}

