/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASSelectorProvider;
import com.sun.enterprise.server.ss.provider.ASServerSocketChannel;
import com.sun.enterprise.server.ss.spi.ASSocketFacadeUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ASServerSocket
extends ServerSocket {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private ServerSocket ss = null;
    private ASServerSocketChannel sschan = null;
    private boolean toBind = true;
    private LinkedList socketCache = null;
    private final LinkedList clientSocketLocalPorts = new LinkedList();

    ASServerSocket(ServerSocket ss, ASServerSocketChannel sschan) throws IOException {
        this.ss = ss;
        this.sschan = sschan;
    }

    public int getLocalPort() {
        return this.ss.getLocalPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.ss.getReceiveBufferSize();
    }

    public synchronized int getSoTimeout() throws IOException {
        return this.ss.getSoTimeout();
    }

    public void close() throws IOException {
        ASSocketFacadeUtils.getASSocketService().close(this.getLocalPort(), this.ss, (ServerSocketChannel)this.sschan.getActualChannel());
    }

    public boolean getReuseAddress() throws SocketException {
        return this.ss.getReuseAddress();
    }

    public boolean isBound() {
        return this.ss.isBound();
    }

    public boolean isClosed() {
        return this.ss.isClosed();
    }

    public synchronized void setReceiveBufferSize(int i) throws SocketException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASServerSocket.setReceiveBufferSize = " + i);
        }
        this.ss.setReceiveBufferSize(i);
    }

    public synchronized void setSoTimeout(int i) throws SocketException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASServerSocket.setSoTimeout = " + i);
        }
        this.ss.setSoTimeout(i);
    }

    public void setReuseAddress(boolean b) throws SocketException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASServerSocket.setReuseAddress = " + b);
        }
        this.ss.setReuseAddress(b);
    }

    public String toString() {
        return this.ss.toString();
    }

    public InetAddress getInetAddress() {
        return this.ss.getInetAddress();
    }

    public synchronized Socket accept() throws IOException {
        Socket s = this.getAlreadyAcceptedSocketInSameVM();
        if (s != null) {
            return s;
        }
        s = this.getFirstSocketFromCache();
        if (s == null) {
            s = this.acceptSocket();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASServerSocket.accept got connection, s.port=" + s.getPort() + " s.localPort=" + s.getLocalPort());
        }
        if (!this.hasClientSocketLocalPorts()) {
            ASSocketFacadeUtils.getASSocketService().waitOnAccept(s);
        }
        if (this.hasClientSocketLocalPorts()) {
            s = this.findSocketInSameVM(s);
        }
        return s;
    }

    private Socket acceptSocket() throws IOException {
        return this.ss.accept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientSocketLocalPort(int port) {
        LinkedList linkedList = this.clientSocketLocalPorts;
        synchronized (linkedList) {
            this.clientSocketLocalPorts.addLast(new Integer(port));
        }
    }

    public boolean hasClientSocketLocalPorts() {
        return this.clientSocketLocalPorts.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getAlreadyAcceptedSocketInSameVM() {
        if (this.socketCache != null && this.socketCache.size() > 0 && this.clientSocketLocalPorts.size() > 0) {
            Iterator it = this.socketCache.iterator();
            Socket result = null;
            while (it.hasNext()) {
                result = (Socket)it.next();
                if (!ASSocketFacadeUtils.getASSocketService().isLocalClient(result)) continue;
                Integer port = new Integer(result.getPort());
                LinkedList linkedList = this.clientSocketLocalPorts;
                synchronized (linkedList) {
                    if (this.clientSocketLocalPorts.remove(port)) {
                        it.remove();
                        return result;
                    }
                }
            }
        }
        return null;
    }

    private Socket getFirstSocketFromCache() {
        if (this.socketCache != null && this.socketCache.size() > 0) {
            return (Socket)this.socketCache.removeFirst();
        }
        return null;
    }

    private LinkedList getSocketCache() {
        if (this.socketCache == null) {
            this.socketCache = new LinkedList();
        }
        return this.socketCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket findSocketInSameVM(Socket s) throws IOException {
        Socket result = s;
        while (true) {
            if (ASSocketFacadeUtils.getASSocketService().isLocalClient(result)) {
                Integer port = new Integer(result.getPort());
                LinkedList linkedList = this.clientSocketLocalPorts;
                synchronized (linkedList) {
                    if (this.clientSocketLocalPorts.remove(port)) {
                        break;
                    }
                }
            }
            LinkedList cache = this.getSocketCache();
            cache.addLast(result);
            result = this.acceptSocket();
        }
        return result;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.ss.getLocalSocketAddress();
    }

    public void bind(SocketAddress s) throws IOException {
        this.bind(s, 0);
    }

    public void bind(SocketAddress s, int backlog) throws IOException {
        if (s == null) {
            s = new InetSocketAddress(0);
        }
        int port = ((InetSocketAddress)s).getPort();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "In ASServerSocket.bind for port " + port, new Exception());
        }
        this.sschan.setPortNumber(port);
        if (!ASSocketFacadeUtils.getASSocketService().exists(port)) {
            this.ss.bind(s, backlog);
        } else {
            int state;
            ServerSocket savedss = this.getServerSocket(port);
            if (savedss != null) {
                this.ss = savedss;
                this.sschan.setServerSocketChannel(this.ss.getChannel());
            }
            if ((state = this.getPortState(port)) != 1) {
                try {
                    this.ss.bind(s, backlog);
                }
                catch (IOException ie) {
                    throw ie;
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof SocketException) {
                        throw (SocketException)t.getCause();
                    }
                    throw new BindException(t.getMessage() + ":" + port);
                }
            } else if (state == 1) {
                ASSocketFacadeUtils.getASSocketService().removeListeningSelector(port);
            }
            this.setServerSocket(this.ss, port);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASServerSocket.bind, bound at port " + this.ss.getLocalPort());
        }
    }

    public ServerSocketChannel getChannel() {
        return this.sschan;
    }

    private ServerSocket getServerSocket(int port) {
        ASSelectorProvider provider = (ASSelectorProvider)SelectorProvider.provider();
        return provider.getServerSocket(port);
    }

    private void setServerSocket(ServerSocket ss, int port) {
        ASSelectorProvider provider = (ASSelectorProvider)SelectorProvider.provider();
        provider.setServerSocket(ss, port);
    }

    private int getPortState(int port) {
        ASSelectorProvider provider = (ASSelectorProvider)SelectorProvider.provider();
        return provider.getPortState(port);
    }
}

