/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.server.PEMain;
import com.sun.enterprise.server.ondemand.entry.EntryPoint;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.server.ss.ASSocketServiceConfig;
import com.sun.enterprise.server.ss.provider.ASSelector;
import com.sun.enterprise.server.ss.provider.ASSelectorProvider;
import com.sun.enterprise.server.ss.provider.ASServerSocket;
import com.sun.enterprise.server.ss.provider.PortConflictException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ASSocketService
implements EntryPoint {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static final StringManager localStrings = StringManager.getManager(ASSocketService.class);
    private static final HashMap<Integer, ASSocketService> managedPortsTable = new HashMap();
    private static PEMain peMain = null;
    private static InetAddress localHost = null;
    private static final String SO_REUSEADDR_PROPERTY = "com.sun.enterprise.server.ss.setReuseAddress";
    private static final boolean setReuseAddress = new Boolean(System.getProperty("com.sun.enterprise.server.ss.setReuseAddress"));
    private ServerSocket ss;
    private ServerSocketChannel sschan;
    private Selector sel;
    private static final int TIMEOUT = 30000;
    private static boolean triggered = false;
    static final int NOTSTARTED = 0;
    static final int SERVICENOTIFIED = 1;
    static final int STARTING = 2;
    static final int STARTED = 3;
    private int state = 0;
    private static final Object lock = new Object();
    private final Object acceptLock = new Object();
    private ASSocketServiceConfig config = null;

    ASSocketService(ASSocketServiceConfig config) {
        this.config = config;
        if (localHost == null) {
            try {
                localHost = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void start() throws PortConflictException {
        try {
            this.config.init();
            this._initializeService();
            if (this.config.getStartSelector()) {
                Selector select = this.createListeningSelector();
                new EntryPointThread(select).start();
            } else {
                this.state = 3;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ASSocketService Successfully started for " + this.config);
            }
        }
        catch (IOException ie) {
            String i18nMsg = localStrings.getString("socketservice.port_conflict", new Object[]{String.valueOf(this.config.getPort())});
            throw new PortConflictException(this.config.getPort(), i18nMsg, ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _reInitializeService() throws IOException {
        ASSelectorProvider provider = (ASSelectorProvider)SelectorProvider.provider();
        provider.clear(this.config.getPort());
        HashMap<Integer, ASSocketService> hashMap = managedPortsTable;
        synchronized (hashMap) {
            managedPortsTable.remove(this.config.getPort());
        }
        try {
            if (this.sel != null) {
                this.sel.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, e.getMessage(), e);
        }
        int oldPort = this.config.getPort();
        this.config.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _initializeService() throws IOException {
        HashMap<Integer, ASSocketService> hashMap = managedPortsTable;
        synchronized (hashMap) {
            managedPortsTable.put(this.config.getPort(), this);
        }
        this.sschan = ServerSocketChannel.open();
        this.ss = this.sschan.socket();
        if (setReuseAddress) {
            this.ss.setReuseAddress(true);
        }
        if (this.config.getBacklog() > 0) {
            this.ss.bind(this.config.getSocketAddress(), this.config.getBacklog());
        } else {
            this.ss.bind(this.config.getSocketAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean close(int port, ServerSocket sock, ServerSocketChannel channel) throws IOException {
        ASSocketService savedSS = null;
        if (port > 0 && (savedSS = ASSocketService.get(port)) != null && savedSS.entryBeingProcessed()) {
            ASSelectorProvider pr = (ASSelectorProvider)SelectorProvider.provider();
            pr.setPortState(port, 1);
            return false;
        }
        boolean closed = false;
        try {
            if (channel != null && channel.isOpen()) {
                closed = true;
                channel.close();
            }
            if (sock != null && !sock.isClosed()) {
                closed = true;
                sock.close();
            }
        }
        finally {
            if (savedSS != null && closed) {
                ASSocketService.reInitializeService(port);
            }
        }
        return true;
    }

    static void reInitializeService(int port) throws IOException {
        ASSocketService savedSS = ASSocketService.get(port);
        if (savedSS != null) {
            savedSS._reInitializeService();
        }
    }

    Selector createListeningSelector() {
        try {
            this.sschan.configureBlocking(false);
            this.sel = Selector.open();
            this.sschan.register(this.sel, 16);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return this.sel;
    }

    static void removeListeningSelector(int port) {
        try {
            ASSocketService savedSS = ASSocketService.get(port);
            if (savedSS.sel != null) {
                savedSS.sel.close();
                savedSS.sschan.configureBlocking(true);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    static ServerSocket getServerSocket(int port) {
        ASSocketService a = managedPortsTable.get(port);
        return a.ss;
    }

    static ServerSocketChannel getServerSocketChannel(int port) {
        ASSocketService a = managedPortsTable.get(port);
        return a.sschan;
    }

    static boolean exists(int port) {
        return managedPortsTable.containsKey(port);
    }

    static ASSocketService get(int port) {
        return managedPortsTable.get(port);
    }

    static void initialize() {
        if (peMain == null) {
            peMain = PEMain.getInstance();
        }
    }

    boolean entryBeingProcessed() {
        return this.state != 3;
    }

    public static boolean socketServiceNotified(int port) {
        ASSocketService ss = ASSocketService.get(port);
        if (ss != null) {
            InvocationManager im = Switch.getSwitch().getInvocationManager();
            ss._socketServiceNotified(port);
            return im.isStartupInvocation();
        }
        return true;
    }

    void _socketServiceNotified(int port) {
        if (this.state == 0 && !ServerEntryHelper.isNotifiedByPortEntryContext(port)) {
            this.state = 1;
        }
    }

    public void generateEntryContext(Object context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In ASSocketService.generateEntryContext for context " + context);
        }
        ServerEntryHelper.generatePortEntryContext((Integer)context);
    }

    static void waitOnAccept(SocketChannel sc) {
        if (peMain.isStartingUp()) {
            ASSocketService.waitOnAccept(sc.socket());
        } else {
            ASSocketService.waitForServiceStartUp(sc.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitOnAccept(Socket s) {
        if (peMain.isStartingUp()) {
            int localPort = s.getLocalPort();
            if (!ASSocketService.exists(localPort)) {
                return;
            }
            PEMain pEMain = peMain;
            synchronized (pEMain) {
                while (peMain.isStartingUp() && !ASSocketService.hasClientSocketLocalPorts(s)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("In ASSocketService.waitOnAccept for localport " + localPort);
                    }
                    try {
                        peMain.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        ASSocketService.waitForServiceStartUp(s);
    }

    static void waitForServiceStartUp(Socket s) {
        ASSocketService savedService = ASSocketService.get(s.getLocalPort());
        if (savedService != null) {
            savedService._waitForServiceStartUp(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitForServiceStartUp(Socket s) {
        if (this.entryBeingProcessed()) {
            int localPort = s.getLocalPort();
            Object object = this.acceptLock;
            synchronized (object) {
                while (this.entryBeingProcessed() && !ASSocketService.hasClientSocketLocalPorts(s)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("In ASSocketService.waitForServiceStartUp for localport " + localPort);
                    }
                    try {
                        this.acceptLock.wait();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clientSocketConnected(int port, int localPort) {
        ASSocketService service;
        boolean toAdd = true;
        if (peMain.isStartingUp()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("In ASSocketService.clientSocketConnected, adding port " + localPort);
            }
            PEMain pEMain = peMain;
            synchronized (pEMain) {
                ASSocketService.putClientSocketLocalPort(port, localPort);
                toAdd = false;
                peMain.notifyAll();
            }
        }
        if ((service = ASSocketService.get(port)) != null && service.entryBeingProcessed()) {
            Object object = service.acceptLock;
            synchronized (object) {
                if (toAdd) {
                    ASSocketService.putClientSocketLocalPort(port, localPort);
                }
                service.acceptLock.notifyAll();
            }
        }
    }

    static void putClientSocketLocalPort(int serverPort, int localPort) {
        if (ASSocketService.exists(serverPort)) {
            ASServerSocket ss = (ASServerSocket)ASSocketService.getServerSocket(serverPort);
            ss.addClientSocketLocalPort(localPort);
        }
    }

    static boolean hasClientSocketLocalPorts(Socket s) {
        ASServerSocket ss = (ASServerSocket)ASSocketService.getServerSocket(s.getLocalPort());
        return ss.hasClientSocketLocalPorts();
    }

    static boolean isLocalClient(Socket s) {
        return ASSocketService.isLocalClient(s.getInetAddress());
    }

    static boolean isLocalClient(InetAddress remoteAddr) {
        return remoteAddr.equals(localHost) || remoteAddr.isSiteLocalAddress() || remoteAddr.isLinkLocalAddress() || remoteAddr.isLoopbackAddress() || remoteAddr.isAnyLocalAddress();
    }

    public static SelectionKey keyFor(SelectableChannel channel, Selector sel) {
        return channel.keyFor(((ASSelector)sel).getSelector());
    }

    static boolean isServerStartingUp() {
        return peMain.isStartingUp();
    }

    static boolean isServerStartingUp(int port) {
        ASSocketService savedSS;
        if (ASSocketService.isServerStartingUp()) {
            return true;
        }
        if (port > 0 && (savedSS = ASSocketService.get(port)) != null) {
            return savedSS.entryBeingProcessed();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerServerExit() {
        Object object = lock;
        synchronized (object) {
            triggered = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForClientNotification() {
        Object object = lock;
        synchronized (object) {
            if (!triggered) {
                try {
                    lock.wait(30000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void waitOnClientConnection(int port) {
        ASSocketService ss = ASSocketService.get(port);
        if (ss != null) {
            ss._waitOnClientConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitOnClientConnection() {
        if (this.entryBeingProcessed()) {
            Object object = this.acceptLock;
            synchronized (object) {
                try {
                    while (this.entryBeingProcessed()) {
                        this.acceptLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    class EntryPointThread
    extends Thread {
        private Selector selector = null;

        EntryPointThread(Selector selector) {
            this.selector = selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: {
                try {
                    Iterator<SelectionKey> it;
                    block12: while (true) {
                        SelectionKey selKey;
                        this.selector.select();
                        it = this.selector.selectedKeys().iterator();
                        do {
                            if (!it.hasNext()) continue block12;
                        } while (!(selKey = it.next()).isValid() || !selKey.isAcceptable());
                        break;
                    }
                    it.remove();
                    if (ASSocketService.this.state == 1 || !peMain.isStartingUp()) break block15;
                    PEMain pEMain = peMain;
                    synchronized (pEMain) {
                        try {
                            while (peMain.isStartingUp()) {
                                peMain.wait();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) break block15;
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            try {
                ASSocketService.this.state = 2;
                ASSocketService.this.generateEntryContext(new Integer(ASSocketService.this.config.getPort()));
                ASSocketService.this.state = 3;
                Object e = ASSocketService.this.acceptLock;
                synchronized (e) {
                    ASSocketService.this.acceptLock.notifyAll();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

