/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.stats;

import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorStatistics {
    private static final int MIN_INTERVALS = 5;
    private static final int MAX_INTERVALS = 500;
    private static final long DEFAULT_INTERVAL = 3600000L;
    private static final ErrorStatistics singleton = new ErrorStatistics();
    private long interval = 3600000L;
    private int numOfIntervals = 5;
    private long startTimeStamp;
    private HashMap<Long, HashMap<String, ErrorCount>> intervalMap = new HashMap();

    public static ErrorStatistics singleton() {
        return singleton;
    }

    public static void registerStartupTime() {
        ErrorStatistics.singleton();
    }

    ErrorStatistics() {
        this.startTimeStamp = System.currentTimeMillis();
    }

    public int getNumOfIntervals() {
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            if (sc != null) {
                LogService ls = ServerBeansFactory.getConfigBean(sc.getConfigContext()).getLogService();
                this.numOfIntervals = Integer.parseInt(ls.getRetainErrorStatisticsForHours());
            }
        }
        catch (Exception n) {
            this.numOfIntervals = 5;
        }
        return this.numOfIntervals;
    }

    public void setNumOfIntervals(int intervals) {
        if (intervals < 5 || intervals > 500) {
            throw new IllegalArgumentException("Number of intervals must be between 5 and 500");
        }
        this.numOfIntervals = intervals;
    }

    public void setIntervalDuration(long interval) {
        this.interval = interval;
    }

    public long getIntervalDuration() {
        return this.interval;
    }

    public void updateStatistics(LogRecord record) {
        ErrorCount errorCount;
        long logTimeStamp = record.getMillis();
        String logModuleId = record.getLoggerName();
        if (logModuleId == null) {
            Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
            logger.log(Level.WARNING, "Update error statistics failed", new Throwable("Logger name is null.").fillInStackTrace());
            return;
        }
        Level logLevel = record.getLevel();
        long hoursElapsed = (logTimeStamp - this.startTimeStamp) / this.interval;
        long timeStamp = this.startTimeStamp + hoursElapsed * this.interval;
        HashMap<String, ErrorCount> moduleMap = this.intervalMap.get(timeStamp);
        if (moduleMap == null) {
            moduleMap = new HashMap();
            this.trimHourMap(timeStamp);
            this.intervalMap.put(timeStamp, moduleMap);
        }
        if ((errorCount = moduleMap.get(logModuleId)) == null) {
            errorCount = new ErrorCount();
            moduleMap.put(logModuleId, errorCount);
        }
        if (logLevel.equals(Level.SEVERE)) {
            errorCount.setSevereCount(errorCount.getSevereCount() + 1);
        } else {
            errorCount.setWarningCount(errorCount.getWarningCount() + 1);
        }
    }

    private void trimHourMap(long refTimeStamp) {
        Long[] timeStamps = this.intervalMap.keySet().toArray(new Long[0]);
        for (int i = 0; i < timeStamps.length; ++i) {
            long timeStamp = timeStamps[i];
            if (refTimeStamp - timeStamp < this.interval * (long)this.getNumOfIntervals()) continue;
            this.intervalMap.remove(timeStamp);
        }
    }

    public List<Map<String, Object>> getErrorInformation() {
        long intervalsElapsed = (System.currentTimeMillis() - this.startTimeStamp) / this.interval;
        long recentTimeStamp = this.startTimeStamp + intervalsElapsed * this.interval;
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.getNumOfIntervals(); ++i) {
            long timeStamp = recentTimeStamp - this.interval * (long)i;
            HashMap<String, ErrorCount> moduleMap = this.intervalMap.get(timeStamp);
            int severeCount = 0;
            int warningCount = 0;
            if (timeStamp < this.startTimeStamp) {
                severeCount = -1;
                warningCount = -1;
            }
            if (moduleMap != null) {
                for (ErrorCount error : moduleMap.values()) {
                    severeCount += error.getSevereCount();
                    warningCount += error.getWarningCount();
                }
            }
            HashMap<String, Number> entry = new HashMap<String, Number>();
            entry.put("TimeStamp", timeStamp);
            entry.put("SevereCount", severeCount);
            entry.put("WarningCount", warningCount);
            results.add(entry);
        }
        return results;
    }

    public Map<String, Integer> getErrorDistribution(long timeStamp, Level level) {
        if (!level.equals(Level.SEVERE) && !level.equals(Level.WARNING)) {
            throw new IllegalArgumentException("Log level: " + level);
        }
        HashMap<String, ErrorCount> moduleMap = this.intervalMap.get(timeStamp);
        if (moduleMap == null) {
            return null;
        }
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String moduleId : moduleMap.keySet()) {
            ErrorCount errorCount = moduleMap.get(moduleId);
            if (level.equals(Level.SEVERE)) {
                results.put(moduleId, errorCount.getSevereCount());
                continue;
            }
            results.put(moduleId, errorCount.getWarningCount());
        }
        return results;
    }

    public static void main(String[] args) {
        long timeStamp;
        LogRecord srecord = new LogRecord(Level.SEVERE, "severe record");
        srecord.setMillis(System.currentTimeMillis());
        srecord.setLoggerName("com.wombat.smodule");
        LogRecord wrecord = new LogRecord(Level.WARNING, "warning record");
        wrecord.setMillis(System.currentTimeMillis());
        wrecord.setLoggerName("com.wombat.wmodule");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        ErrorStatistics stats = new ErrorStatistics();
        long interval = 1000L;
        stats.setIntervalDuration(interval);
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int j = 0; j < 2; ++j) {
                srecord.setMillis(System.currentTimeMillis());
                stats.updateStatistics(srecord);
                wrecord.setMillis(System.currentTimeMillis());
                stats.updateStatistics(wrecord);
            }
            System.out.printf("Interval(%1$s): %2$s\n", i, sdf.format(new Date(System.currentTimeMillis())));
        }
        System.out.println("\nTimeStamp\tSevere\tWarning");
        System.out.println("--------------------------------");
        List<Map<String, Object>> list = stats.getErrorInformation();
        for (Map<String, Object> item : list) {
            timeStamp = (Long)item.get("TimeStamp");
            int severeCount = (Integer)item.get("SevereCount");
            int warningCount = (Integer)item.get("WarningCount");
            System.out.printf("%1$s\t%2$s\t%3$s\n", sdf.format(new Date(timeStamp)), severeCount, warningCount);
        }
        for (Map<String, Object> item : list) {
            timeStamp = (Long)item.get("TimeStamp");
            Map<String, Integer> map = stats.getErrorDistribution(timeStamp, Level.SEVERE);
            System.out.printf("\nModuleId\tLevel.SEVERE\t(%1$s)\n", sdf.format(new Date(timeStamp)));
            System.out.println("------------------------------------------");
            for (String moduleId : map.keySet()) {
                System.out.printf("%1$s\t%2$s\n", moduleId, map.get(moduleId));
            }
            map = stats.getErrorDistribution(timeStamp, Level.WARNING);
            System.out.printf("\nModuleId\tLevel.WARNING\t(%1$s)\n", sdf.format(new Date(timeStamp)));
            System.out.println("------------------------------------------");
            for (String moduleId : map.keySet()) {
                System.out.printf("%1$s\t%2$s\n", moduleId, map.get(moduleId));
            }
        }
    }

    private static class ErrorCount {
        private int severeCount;
        private int warningCount;

        private ErrorCount() {
        }

        void setSevereCount(int count) {
            this.severeCount = count;
        }

        int getSevereCount() {
            return this.severeCount;
        }

        void setWarningCount(int count) {
            this.warningCount = count;
        }

        int getWarningCount() {
            return this.warningCount;
        }
    }
}

