/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.DummyWebModuleManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class WebModuleDeployEventListener
extends DummyWebModuleManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(WebModuleDeployEventListener.class);
    private Hashtable cachedWebModules = new Hashtable();
    protected WebContainer webContainer = null;

    public WebModuleDeployEventListener(WebModulesManager manager, ClassLoader loader) {
        super(manager, loader);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    private WebModuleConfig loadWebModuleConfig(WebModule wm, ConfigContext config) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        try {
            Application app = this.getWebModulesManager().getDescriptor(wmID, location);
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            wmInfo.setDescriptor(wbd);
            String vs = ServerBeansFactory.getVirtualServersByAppName(config, wmID);
            wmInfo.setVirtualServers(vs);
        }
        catch (ConfigException ce) {
            wmInfo = null;
        }
        return wmInfo;
    }

    private void moduleDeployed(ConfigContext config, String moduleName) throws AdminEventListenerException {
        WebModule webModule = this.getWebModuleAndUpdateCache(config, moduleName, true);
        if (!this.isEnabled(config, moduleName)) {
            return;
        }
        String location = webModule.getLocation();
        File moduleBase = new File(location);
        String modulesRoot = this.getWebContainer().getModulesRoot();
        if (!moduleBase.isAbsolute()) {
            location = modulesRoot + File.separator + location;
            webModule.setLocation(location);
        }
        WebModuleConfig wmInfo = this.loadWebModuleConfig(webModule, config);
        List<Throwable> throwables = this.getWebContainer().loadWebModule(wmInfo, "null");
        if (throwables != null && !throwables.isEmpty()) {
            String msg = throwables.get(0).getMessage();
            AdminEventListenerException ex = new AdminEventListenerException(msg);
            ex.initCause(throwables.get(0));
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleUndeployed(ConfigContext config, String moduleName) throws AdminEventListenerException {
        String virtualServers;
        String contextRoot;
        WebBundleDescriptor wbd;
        String appName;
        block11: {
            WebModule webModule = this.getWebModuleAndUpdateCache(config, moduleName, false);
            appName = null;
            try {
                Application app = this.getWebModulesManager().getDescriptor(webModule.getName(), webModule.getLocation());
                RoleMapper.removeRoleMapper(app.getRoleMapper().getName());
                wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
                appName = app.getRegistrationName();
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce);
            }
            contextRoot = webModule.getContextRoot();
            virtualServers = null;
            try {
                virtualServers = ServerBeansFactory.getVirtualServersByAppName(config, moduleName);
            }
            catch (ConfigException ce) {
                if (!_logger.isLoggable(Level.FINEST)) break block11;
                _logger.log(Level.FINEST, "Exception getting virtual servers by app name " + moduleName, ce);
            }
        }
        try {
            this.getWebContainer().unloadWebModule(contextRoot, appName, virtualServers, wbd);
        }
        finally {
            try {
                Switch.getSwitch().getNamingManager().unbindObjects(wbd);
            }
            catch (NamingException nameEx) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener]  Exception during namingManager.unbindObject", nameEx);
            }
        }
    }

    public synchronized void moduleDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
            ConfigContext config = event.getConfigContext();
            String moduleName = event.getModuleName();
            try {
                this.getWebModulesManager().refreshConfigContext(config);
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
            AbstractLoader dummyLoader = this.getLoader(moduleName);
            if (dummyLoader.load(false)) {
                this.moduleDeployed(config, moduleName);
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            ConfigContext config = event.getOldConfigContext();
            String moduleName = event.getModuleName();
            try {
                this.getWebModulesManager().refreshConfigContext(config);
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
            AbstractLoader dummyLoader = this.getLoader(moduleName);
            dummyLoader.unload(false);
            this.moduleUndeployed(config, moduleName);
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            String moduleName = event.getModuleName();
            ConfigContext oldConfig = event.getOldConfigContext();
            this.moduleUndeployed(oldConfig, moduleName);
            ConfigContext config = event.getConfigContext();
            this.moduleDeployed(config, moduleName);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
            }
            ConfigContext config = event.getConfigContext();
            String moduleName = event.getModuleName();
            WebModule webModule = this.getWebModuleAndUpdateCache(config, moduleName, true);
            if (!this.isEnabled(event.getConfigContext(), moduleName)) {
                return;
            }
            String location = webModule.getLocation();
            File moduleBase = new File(location);
            String modulesRoot = this.getWebContainer().getModulesRoot();
            if (!moduleBase.isAbsolute()) {
                location = modulesRoot + File.separator + location;
                webModule.setLocation(location);
            }
            WebModuleConfig wmInfo = this.loadWebModuleConfig(webModule, config);
            this.getWebContainer().enableWebModule(wmInfo, "null");
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("web")) {
            String virtualServers;
            String contextRoot;
            String appName;
            block6: {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebModuleDeployEventListener] Handling event " + event.toString());
                }
                ConfigContext config = event.getConfigContext();
                String moduleName = event.getModuleName();
                WebModule webModule = this.getWebModuleAndUpdateCache(config, moduleName, true);
                appName = null;
                try {
                    Application app = this.getWebModulesManager().getDescriptor(webModule.getName(), webModule.getLocation());
                    WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
                    appName = app.getRegistrationName();
                }
                catch (ConfigException ce) {
                    throw new AdminEventListenerException(ce);
                }
                contextRoot = webModule.getContextRoot();
                virtualServers = null;
                try {
                    virtualServers = ServerBeansFactory.getVirtualServersByAppName(config, moduleName);
                }
                catch (ConfigException ce) {
                    if (!_logger.isLoggable(Level.FINEST)) break block6;
                    _logger.log(Level.FINEST, "Exception getting virtual servers by app name " + moduleName, ce);
                }
            }
            this.getWebContainer().disableWebModule(contextRoot, appName, virtualServers);
        }
    }

    private synchronized WebModule getWebModuleAndUpdateCache(ConfigContext config, String moduleName, boolean isAddToCache) throws AdminEventListenerException {
        WebModule webModule = (WebModule)this.cachedWebModules.get(moduleName);
        if (webModule == null) {
            try {
                webModule = (WebModule)ApplicationHelper.findApplication(config, moduleName);
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce);
            }
            if (webModule == null) {
                String msg = localStrings.getString("webmodule.module_not_found", moduleName);
                throw new AdminEventListenerException(msg);
            }
            if (isAddToCache) {
                this.cachedWebModules.put(moduleName, webModule);
            }
        } else if (!isAddToCache) {
            this.cachedWebModules.remove(moduleName);
        }
        return webModule;
    }

    public void moduleReferenceAdded(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    public void moduleReferenceRemoved(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    protected boolean isEnabled(ConfigContext config, String moduleName) {
        try {
            ConfigBean app = ApplicationHelper.findApplication(config, moduleName);
            Server server = ServerBeansFactory.getServerBean(config);
            ApplicationRef appRef = server.getApplicationRefByRef(moduleName);
            return app != null && app.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            AdminEventListenerException ex = new AdminEventListenerException();
            ex.initCause(e);
            _logger.log(Level.FINE, "Error in finding " + moduleName, e);
            return false;
        }
    }

    private WebModulesManager getWebModulesManager() throws ConfigException {
        return (WebModulesManager)this.configManager;
    }

    private WebContainer getWebContainer() {
        if (this.webContainer == null) {
            this.webContainer = WebContainer.getInstance();
        }
        return this.webContainer;
    }
}

