/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.server.MonitorableEntry;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

abstract class AbstractMonitor
extends TimerTask {
    protected HashSet _monitoredEntries;
    protected Timer _timer;
    protected long _pollInterval;

    AbstractMonitor(long pollInterval) {
        this._pollInterval = pollInterval;
        this._monitoredEntries = new HashSet();
    }

    void start() {
        this._timer = new Timer(true);
        this._timer.schedule((TimerTask)this, 0L, this._pollInterval);
    }

    void stop() {
        if (this._timer != null) {
            this._timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMonitorableEntry(MonitorableEntry entry) {
        HashSet hashSet = this._monitoredEntries;
        synchronized (hashSet) {
            this._monitoredEntries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitorableEntry(MonitorableEntry entry) {
        HashSet hashSet = this._monitoredEntries;
        synchronized (hashSet) {
            this._monitoredEntries.remove(entry);
        }
    }
}

