/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class PolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    static Map polConfTable = new HashMap();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static Lock rLock = rwLock.readLock();
    private static Lock wLock = rwLock.writeLock();

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        PolicyConfigurationImpl pci;
        PolicyConfigurationImpl.checkSetPolicyPermission();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Getting PolicyConfiguration object with id = " + contextId);
        }
        if ((pci = PolicyConfigurationFactoryImpl.getPolicyConfigImpl(contextId)) == null) {
            pci = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextId, true, remove);
            if (pci == null) {
                pci = new PolicyConfigurationImpl(contextId);
                PolicyConfigurationFactoryImpl.putPolicyConfigurationImpl(contextId, pci);
            }
        } else {
            pci.initialize(true, remove, false);
        }
        return pci;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfigurationImpl.checkSetPolicyPermission();
        PolicyConfigurationImpl pc = PolicyConfigurationFactoryImpl.getPolicyConfigImpl(contextID);
        if (pc == null) {
            pc = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextID, false, false);
        }
        return pc == null ? false : pc.inService();
    }

    private static PolicyConfigurationImpl getPolicyConfigurationImplFromDirectory(String contextId, boolean open, boolean remove) {
        PolicyConfigurationImpl pci = null;
        File f = new File(PolicyConfigurationImpl.getContextDirectoryName(contextId));
        if (f.exists() && (pci = new PolicyConfigurationImpl(f, open, remove)) != null) {
            PolicyConfigurationFactoryImpl.putPolicyConfigurationImpl(contextId, pci);
        }
        return pci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PolicyConfigurationImpl[] getPolicyConfigurationImpls() {
        PolicyConfigurationImpl[] rvalue = null;
        try {
            rLock.lock();
            Collection c = polConfTable.values();
            if (c != null) {
                rvalue = c.toArray(new PolicyConfigurationImpl[c.size()]);
            }
        }
        finally {
            rLock.unlock();
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PolicyConfigurationImpl putPolicyConfigurationImpl(String contextID, PolicyConfigurationImpl pci) {
        try {
            wLock.lock();
            PolicyConfigurationImpl policyConfigurationImpl = polConfTable.put(contextID, pci);
            return policyConfigurationImpl;
        }
        finally {
            wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyConfigurationImpl getPolicyConfigImpl(String contextId) {
        try {
            rLock.lock();
            PolicyConfigurationImpl policyConfigurationImpl = (PolicyConfigurationImpl)polConfTable.get(contextId);
            return policyConfigurationImpl;
        }
        finally {
            rLock.unlock();
        }
    }

    protected static PolicyConfigurationImpl getPolicyConfigurationImpl(String contextId) {
        PolicyConfigurationImpl pci = PolicyConfigurationFactoryImpl.getPolicyConfigImpl(contextId);
        if (pci == null && (pci = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextId, false, false)) == null) {
            logger.log(Level.WARNING, "pc.unknown_policy_context", new Object[]{contextId});
        }
        return pci;
    }
}

