/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.ConnectorConnectionPoolDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public class ConnectorResourceDeployer
implements ResourceDeployer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        String poolName = domainResource.getPoolName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        _logger.log(Level.FINE, "Calling backend to add connector resource", jndiName);
        this.loadPool(domainResource);
        crt.createConnectorResource(jndiName, poolName, null);
        _logger.log(Level.FINE, "Added connector resource in backend", jndiName);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String jndiName = domainResource.getJndiName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        crt.deleteConnectorResource(jndiName);
        this.checkAndDeletePool(domainResource);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        ConnectorResource res = rbeans.getConnectorResourceByJndiName(name);
        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE, "no_resource", name);
            _logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        return res;
    }

    private void loadPool(ConnectorResource cr) throws Exception {
        ConnectorConnectionPool cb;
        String poolName = cr.getPoolName();
        Resources resources = (Resources)cr.parent();
        ConnectorConnectionPool cp = cb = resources.getConnectorConnectionPoolByName(poolName);
        if (cb != null) {
            if (ConnectionPoolObjectsUtils.isPoolSystemPool(poolName)) {
                this.createPool(cp);
            } else {
                try {
                    InitialContext ic = new InitialContext();
                    ic.lookup(ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName));
                }
                catch (Exception e) {
                    this.createPool(cp);
                }
            }
        }
    }

    private void checkAndDeletePool(ConnectorResource cr) throws Exception {
        try {
            String poolName = cr.getPoolName();
            Resources res = (Resources)cr.parent();
            boolean poolReferred = ResourcesUtil.createInstance().isPoolReferredInServerInstance(poolName);
            if (!poolReferred) {
                _logger.fine("Deleting pool " + poolName + "as there is no more " + "resource-refs to the pool in this server instance");
                ConnectorConnectionPool ccp = res.getConnectorConnectionPoolByName(poolName);
                ConnectorConnectionPoolDeployer deployer = new ConnectorConnectionPoolDeployer();
                deployer.undeployResource(ccp);
            }
        }
        catch (ConfigException ce) {
            _logger.warning(ce.getMessage());
            _logger.fine("Exception while deleting pool : " + ce);
            throw ce;
        }
    }

    private void createPool(ConnectorConnectionPool cp) throws Exception {
        ConnectorConnectionPoolDeployer deployer = new ConnectorConnectionPoolDeployer();
        deployer.deployResource(cp);
    }
}

