/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.pluggable;

import com.sun.enterprise.pluggable.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PluggableFeatureFactoryBaseImpl
implements InvocationHandler {
    private Logger _logger;
    private Properties _featureImplClasses;

    protected PluggableFeatureFactoryBaseImpl(Logger logger) {
        this._logger = logger;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String featureName = this.findFeatureFromMethod(method);
        String className = this._featureImplClasses.getProperty(featureName);
        Object featureImpl = Class.forName(className).newInstance();
        return featureImpl;
    }

    protected abstract String getDefaultFeatureFactoryPropertyName();

    public Object getInstance() {
        String propClassName = System.getProperty(this.getDefaultFeatureFactoryPropertyName());
        return this.getInstance(propClassName);
    }

    public Object getInstance(String propClassName) {
        if (propClassName == null) {
            return null;
        }
        Properties props = null;
        try {
            props = (Properties)Class.forName(propClassName).newInstance();
        }
        catch (Exception ex) {
            String msg = "Error loading pluggable features class " + propClassName;
            if (this._logger != null) {
                this._logger.log(Level.WARNING, msg, ex);
            }
            System.err.println(msg + "\nStack Trace:");
            ex.printStackTrace();
        }
        return this.getInstance(props);
    }

    protected abstract Object createFeatureFactory(InvocationHandler var1);

    public Object getInstance(Properties props) {
        if (props == null) {
            return null;
        }
        this._featureImplClasses = props;
        return this.createFeatureFactory(this);
    }

    private String findFeatureFromMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return Utils.getNQClassName(returnType);
    }
}

