/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.install;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanHelper {
    private static final String OBJ_NAME_PREFIX = "com.sun.jbi:JbiName=";
    private static final String SERVICE_NAME = ",ServiceName=";
    private static final String CONTROL_TYPE = ",ControlType=";
    private static final String COMPONENT_TYPE = ",ComponentType=System";
    private static final String ADMIN_SERVICE_CONTROL_TYPE = "AdministrationService";
    public static final String INSTALLATION_SERVICE = "InstallationService";
    public static final String ADMIN_SERVICE = "AdminService";
    public static final String CONFIGURATION_SERVICE = "Configuration";
    public static final String FRAMEWORK = "Framework";
    public static final String ESB_INSTALLATION_SERVICE = "com.sun.jbi.esb:ServiceType=Installation";
    public static final String ESB_LIFECYCLE_SERVICE = "com.sun.jbi.esb:ServiceType=LifeCycle";
    private MBeanServerConnection mbeanServer;

    public MBeanHelper(MBeanServerConnection mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public ObjectName getObjectName(String domainName, String serviceName) throws ServiceEngineException {
        if (serviceName != null && domainName != null) {
            String objName = OBJ_NAME_PREFIX + domainName + SERVICE_NAME;
            String controlType = "";
            if (serviceName.equals(INSTALLATION_SERVICE)) {
                controlType = serviceName;
            } else if (serviceName.equals(ADMIN_SERVICE)) {
                controlType = ADMIN_SERVICE_CONTROL_TYPE;
            } else if (serviceName.equals(FRAMEWORK)) {
                controlType = CONFIGURATION_SERVICE;
            }
            objName = objName + serviceName + CONTROL_TYPE + controlType + COMPONENT_TYPE;
            return this.getObjectName(objName);
        }
        throw new ServiceEngineException("Either JBI Instance name or Service name or both null");
    }

    public ObjectName getObjectName(String stringifiedObjName) throws ServiceEngineException {
        if (stringifiedObjName != null) {
            try {
                ObjectInstance objInstance = this.mbeanServer.getObjectInstance(new ObjectName(stringifiedObjName));
                return objInstance.getObjectName();
            }
            catch (MalformedObjectNameException e) {
                throw new ServiceEngineException(e.getMessage());
            }
            catch (InstanceNotFoundException infe) {
                throw new ServiceEngineException(infe.getMessage());
            }
            catch (IOException ioe) {
                throw new ServiceEngineException(ioe.getMessage());
            }
        }
        throw new ServiceEngineException(" Null object name");
    }

    public Object invokeMBeanOperation(ObjectName objName, String operationName, Object[] params, String[] signature) throws ServiceEngineException {
        Object result = null;
        try {
            result = this.mbeanServer.invoke(objName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ServiceEngineException(notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ServiceEngineException(rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ServiceEngineException.filterExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ServiceEngineException.filterExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ServiceEngineException.filterExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw ServiceEngineException.filterExceptions(ex);
        }
        return result;
    }
}

