/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.interceptor;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.enterprise.interceptor.DynamicInterceptorHook;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class DynamicInterceptor
implements MBeanServer {
    private volatile MBeanServer mDelegateMBeanServer = null;
    protected final AMXDebugHelper mDebug = new AMXDebugHelper("__DynamicInterceptor__");
    protected final Map<String, DynamicInterceptorHook> mHooks;

    public DynamicInterceptor() {
        this.mDebug.setEchoToStdOut(false);
        this.debug("DynamicInterceptor.DynamicInterceptor");
        this.mHooks = Collections.synchronizedMap(new HashMap());
    }

    public synchronized void addHook(String jmxDomain, DynamicInterceptorHook hook) {
        if (this.mHooks.containsKey(jmxDomain)) {
            throw new IllegalStateException();
        }
        this.debug("Added hook for JMX domain ", jmxDomain, " using hook of class ", hook.getClass().getName());
        this.mHooks.put(jmxDomain, hook);
    }

    protected final void debug(Object ... args) {
        this.mDebug.println(args);
    }

    public MBeanServer getDelegateMBeanServer() {
        return this.mDelegateMBeanServer;
    }

    protected DynamicInterceptorHook getHook(ObjectName objectName) {
        return this.mHooks.get(objectName.getDomain());
    }

    public void setDelegateMBeanServer(MBeanServer server) {
        this.debug("DynamicInterceptor.setDelegateMBeanServer: " + server.getClass().getName());
        if (this.mDelegateMBeanServer != null) {
            throw new IllegalStateException();
        }
        this.mDelegateMBeanServer = server;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        this.debug("DynamicInterceptor.invoke(): ", objectName, ".", operationName, "{", params, "}", "{", signature, "}");
        Object result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        result = hook != null ? hook.invoke(objectName, operationName, params, signature) : this.getDelegateMBeanServer().invoke(objectName, operationName, params, signature);
        return result;
    }

    public final Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        Object result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        result = hook != null ? hook.getAttribute(objectName, attributeName) : this.getDelegateMBeanServer().getAttribute(objectName, attributeName);
        this.debug("DynamicInterceptor.getAttribute: ", objectName, attributeName, result);
        return result;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        this.debug("DynamicInterceptor.setAttribute: ", objectName, attribute);
        DynamicInterceptorHook hook = this.getHook(objectName);
        if (hook != null) {
            hook.setAttribute(objectName, attribute);
        } else {
            this.getDelegateMBeanServer().setAttribute(objectName, attribute);
        }
    }

    public final AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        AttributeList result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        result = hook != null ? hook.getAttributes(objectName, attrNames) : this.getDelegateMBeanServer().getAttributes(objectName, attrNames);
        this.debug("DynamicInterceptor.getAttributes: ", objectName, attrNames, result);
        return result;
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.debug("DynamicInterceptor.setAttributes: ", objectName, attributeList);
        AttributeList result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        result = hook != null ? hook.setAttributes(objectName, attributeList) : this.getDelegateMBeanServer().setAttributes(objectName, attributeList);
        return result;
    }

    public final ObjectInstance registerMBean(Object obj, ObjectName objectName) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        this.debug("DynamicInterceptor.registerMBean: ", objectName, obj.getClass().getName());
        return this.getDelegateMBeanServer().registerMBean(obj, objectName);
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.debug("DynamicInterceptor.unregisterMBean: ", objectName);
        this.getDelegateMBeanServer().unregisterMBean(objectName);
    }

    public final Integer getMBeanCount() {
        this.debug("DynamicInterceptor.getMBeanCount: ");
        return this.getDelegateMBeanServer().getMBeanCount();
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp expr) {
        this.debug("DynamicInterceptor.queryMBeans: ", objectName, expr);
        return this.getDelegateMBeanServer().queryMBeans(objectName, expr);
    }

    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.debug("DynamicInterceptor.getMBeanInfo: ", objectName);
        MBeanInfo result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        result = hook != null ? hook.getMBeanInfo(objectName) : this.getDelegateMBeanServer().getMBeanInfo(objectName);
        return result;
    }

    public final boolean isRegistered(ObjectName objectName) {
        boolean isRegistered = this.getDelegateMBeanServer().isRegistered(objectName);
        return isRegistered;
    }

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.addNotificationListener: ", objectName, notificationListener.getClass().getName());
        this.getDelegateMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.addNotificationListener: ", objectName, objectName1);
        this.getDelegateMBeanServer().addNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.debug("DynamicInterceptor.createMBean: ", str, objectName);
        return this.getDelegateMBeanServer().createMBean(str, objectName);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.debug("DynamicInterceptor.createMBean: ", str, objectName, objectName2);
        return this.getDelegateMBeanServer().createMBean(str, objectName, objectName2);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.debug("DynamicInterceptor.createMBean: ", str, objectName, obj, str3);
        return this.getDelegateMBeanServer().createMBean(str, objectName, obj, str3);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.debug("DynamicInterceptor.createMBean: ", str, objectName, objectName2, obj, str4);
        return this.getDelegateMBeanServer().createMBean(str, objectName, objectName2, obj, str4);
    }

    public final ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        this.debug("DynamicInterceptor.deserialize: ", str, values);
        return this.getDelegateMBeanServer().deserialize(str, values);
    }

    public final ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        this.debug("DynamicInterceptor.deserialize: ", objectName, values);
        return this.getDelegateMBeanServer().deserialize(objectName, values);
    }

    public final ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.debug("DynamicInterceptor.deserialize: ", str, objectName, values);
        return this.getDelegateMBeanServer().deserialize(str, objectName, values);
    }

    public final String getDefaultDomain() {
        this.debug("DynamicInterceptor.getDefaultDomain: ");
        return this.getDelegateMBeanServer().getDefaultDomain();
    }

    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.getDefaultDomain: getObjectInstance", objectName);
        return this.getDelegateMBeanServer().getObjectInstance(objectName);
    }

    public final Object instantiate(String str) throws ReflectionException, MBeanException {
        this.debug("DynamicInterceptor.instantiate: ", str);
        return this.getDelegateMBeanServer().instantiate(str);
    }

    public final Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.debug("DynamicInterceptor.instantiate: ", str, objectName);
        return this.getDelegateMBeanServer().instantiate(str, objectName);
    }

    public final Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        this.debug("DynamicInterceptor.instantiate: ", str, obj, str2);
        return this.getDelegateMBeanServer().instantiate(str, obj, str2);
    }

    public final Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.debug("DynamicInterceptor.instantiate: ", str, objectName, obj, str3);
        return this.getDelegateMBeanServer().instantiate(str, objectName, obj, str3);
    }

    public final boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.isInstanceOf: ", objectName, str);
        return this.getDelegateMBeanServer().isInstanceOf(objectName, str);
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        this.debug("DynamicInterceptor.queryNames: ", objectName, queryExp);
        return this.getDelegateMBeanServer().queryNames(objectName, queryExp);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        this.debug("DynamicInterceptor.removeNotificationListener: ", objectName, objectName1);
        this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.debug("DynamicInterceptor.removeNotificationListener: ", objectName, notificationListener);
        this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.debug("DynamicInterceptor.removeNotificationListener: ", objectName, notificationListener, notificationFilter, obj);
        this.getDelegateMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        this.debug("DynamicInterceptor.removeNotificationListener: ", objectName, objectName1, notificationFilter, obj);
        this.getDelegateMBeanServer().removeNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.getClassLoader: ", objectName);
        ClassLoader result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        if (hook != null) {
            this.debug("calling hook");
            result = hook.getClassLoader(objectName);
        } else {
            result = this.getDelegateMBeanServer().getClassLoader(objectName);
        }
        return result;
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        this.debug("DynamicInterceptor.getClassLoaderFor: ", objectName);
        ClassLoader result = null;
        DynamicInterceptorHook hook = this.getHook(objectName);
        if (hook != null) {
            this.debug("calling hook");
            result = hook.getClassLoaderFor(objectName);
        } else {
            result = this.getDelegateMBeanServer().getClassLoaderFor(objectName);
        }
        return result;
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        this.debug("DynamicInterceptor.getClassLoaderRepository");
        return this.getDelegateMBeanServer().getClassLoaderRepository();
    }

    public final String[] getDomains() {
        this.debug("DynamicInterceptor.getDomains");
        return this.getDelegateMBeanServer().getDomains();
    }
}

