/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInitInfo;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.AroundInvokeNode;
import com.sun.enterprise.deployment.node.ejb.EjbInitNode;
import com.sun.enterprise.deployment.node.ejb.EjbRemoveNode;
import com.sun.enterprise.deployment.node.ejb.InterfaceBasedEjbNode;
import java.util.Map;
import org.w3c.dom.Node;

public class EjbSessionNode
extends InterfaceBasedEjbNode {
    private EjbSessionDescriptor descriptor;

    public EjbSessionNode() {
        this.registerElementHandler(new XMLElement("around-invoke"), AroundInvokeNode.class, "addAroundInvokeDescriptor");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("post-activate"), LifecycleCallbackNode.class, "addPostActivateDescriptor");
        this.registerElementHandler(new XMLElement("pre-passivate"), LifecycleCallbackNode.class, "addPrePassivateDescriptor");
        this.registerElementHandler(new XMLElement("timeout-method"), MethodNode.class, "setEjbTimeoutMethod");
        this.registerElementHandler(new XMLElement("init-method"), EjbInitNode.class, "addInitMethod");
        this.registerElementHandler(new XMLElement("remove-method"), EjbRemoveNode.class, "addRemoveMethod");
    }

    public EjbDescriptor getEjbDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbSessionDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptor)this.getParentNode().getDescriptor());
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("session-type", "setSessionType");
        table.put("transaction-type", "setTransactionType");
        return table;
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof EjbSessionDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)descriptor;
        Node ejbNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(ejbNode, descriptor);
        this.writeCommonHeaderEjbDescriptor(ejbNode, ejbDesc);
        EjbSessionNode.appendTextChild(ejbNode, "session-type", ejbDesc.getSessionType());
        MethodNode methodNode = new MethodNode();
        if (ejbDesc.isTimedObject()) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "timeout-method", ejbDesc.getEjbTimeoutMethod());
        }
        if (ejbDesc.hasInitMethods()) {
            EjbInitNode initNode = new EjbInitNode();
            for (EjbInitInfo ejbInitInfo : ejbDesc.getInitMethods()) {
                initNode.writeDescriptor(ejbNode, "init-method", ejbInitInfo);
            }
        }
        if (ejbDesc.hasRemoveMethods()) {
            EjbRemoveNode removeNode = new EjbRemoveNode();
            for (EjbRemovalInfo ejbRemovalInfo : ejbDesc.getAllRemovalInfo()) {
                removeNode.writeDescriptor(ejbNode, "remove-method", ejbRemovalInfo);
            }
        }
        EjbSessionNode.appendTextChild(ejbNode, "transaction-type", ejbDesc.getTransactionType());
        this.writeAroundInvokeDescriptors(ejbNode, ejbDesc.getAroundInvokeDescriptors().iterator());
        this.writeEnvEntryDescriptors(ejbNode, ejbDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(ejbNode, ejbDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(ejbNode, ejbDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(ejbNode, ejbDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(ejbNode, ejbDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(ejbNode, ejbDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(ejbNode, ejbDesc.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(ejbNode, ejbDesc.getPreDestroyDescriptors().iterator());
        this.writePostActivateDescriptors(ejbNode, ejbDesc.getPostActivateDescriptors().iterator());
        this.writePrePassivateDescriptors(ejbNode, ejbDesc.getPrePassivateDescriptors().iterator());
        this.writeRoleReferenceDescriptors(ejbNode, ejbDesc.getRoleReferences().iterator());
        this.writeSecurityIdentityDescriptor(ejbNode, ejbDesc);
        return ejbNode;
    }
}

