/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.ModuleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationNode
extends BundleNode
implements RootXMLNode {
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/application_1_2.dtd";
    public static final String SCHEMA_ID_14 = "application_1_4.xsd";
    public static final String SCHEMA_ID = "application_5.xsd";
    public static final String SPEC_VERSION = "5";
    private static final List<String> systemIDs = ApplicationNode.initSystemIDs();
    public static final XMLElement tag = new XMLElement("application");
    private Application descriptor;

    private static final List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_14);
        return Collections.unmodifiableList(systemIDs);
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public ApplicationNode() {
        this.registerElementHandler(new XMLElement("module"), ModuleNode.class, "addModule");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addAppRole");
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        Application application = (Application)this.getDescriptor();
        if (element.getQName().equals("library-directory")) {
            application.setLibraryDirectory(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbBundleDescriptor) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("In  " + this.toString() + " adding descriptor " + newDescriptor);
            }
            this.descriptor.addEjbBundleDescriptor((EjbBundleDescriptor)newDescriptor);
        } else if (newDescriptor instanceof WebBundleDescriptor) {
            DOLUtils.getDefaultLogger().fine("In  " + this.toString() + " adding web descriptor " + newDescriptor);
            this.descriptor.addWebBundleDescriptor((WebBundleDescriptor)newDescriptor);
        }
    }

    @Override
    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (Application)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (!(descriptor instanceof Application)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        Application application = (Application)descriptor;
        Node appNode = super.writeDescriptor(parent, application);
        ModuleNode moduleNode = new ModuleNode();
        Iterator modules = application.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor next = (ModuleDescriptor)modules.next();
            moduleNode.writeDescriptor(appNode, "module", next);
        }
        if (application.getLibraryDirectoryRawValue() != null) {
            ApplicationNode.appendTextChild(appNode, "library-directory", application.getLibraryDirectoryRawValue());
        }
        return appNode;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

