/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployedFilesManager;
import com.sun.enterprise.deployment.autodeploy.DirectoryScanner;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDeployDirectoryScanner
implements DirectoryScanner {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static StringManager localStrings = StringManager.getManager(AutoDeployDirectoryScanner.class);

    @Override
    public void deployedEntity(File autodeployDir, File deployedEntity) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.setDeployedFileInfo(deployedEntity);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    @Override
    public void undeployedEntity(File autodeployDir, File undeployedEntity) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.deleteDeployedFileInfo(undeployedEntity);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    @Override
    public boolean hasNewDeployableEntity(File autodeployDir) {
        boolean newFilesExist = false;
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            if (adfm.getFilesForDeployment(this.getListOfFiles(autodeployDir)).length > 0) {
                newFilesExist = true;
            }
        }
        catch (Exception e) {
            this.printException(e);
            return false;
        }
        return newFilesExist;
    }

    @Override
    public File[] getAllFilesForUndeployment(File autodeployDir) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            return adfm.getFilesForUndeployment(this.getListOfFiles(autodeployDir, true));
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
    }

    @Override
    public File[] getAllDeployableModules(File autodeployDir, boolean includeSubDir) {
        AutoDeployedFilesManager adfm = null;
        try {
            adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
        return adfm.getFilesForDeployment(this.getListOfFiles(autodeployDir, includeSubDir));
    }

    protected void printException(Exception e) {
        sLogger.log(Level.SEVERE, e.getMessage(), e);
        e.printStackTrace();
    }

    protected File[] getListOfFiles(File dir) {
        return this.getListOfFiles(dir, false);
    }

    protected File[] getListOfFiles(File dir, boolean includeSubDir) {
        return AutoDeployDirectoryScanner.getListOfFilesAsSet(dir, includeSubDir).toArray(new File[0]);
    }

    static Set<File> getListOfFilesAsSet(File dir, boolean includeSubDir) {
        File[] dirFiles;
        HashSet<File> result = new HashSet<File>();
        for (File dirFile : dirFiles = dir.listFiles()) {
            String name = dirFile.getName();
            String fileType = name.substring(name.lastIndexOf(".") + 1);
            if (fileType != null && !fileType.equals("") && (fileType.equals("ear") || fileType.equals("war") || fileType.equals("jar") || fileType.equals("rar"))) {
                result.add(dirFile);
                continue;
            }
            if (dirFile.isDirectory()) {
                if (!includeSubDir || dirFile.getName().equals(".autodeploystatus")) continue;
                result.addAll(AutoDeployDirectoryScanner.getListOfFilesAsSet(dirFile, true));
                continue;
            }
            if (fileType == null || fileType.equals("") || !fileType.equals("zip") && !fileType.equals("class")) continue;
            result.add(dirFile);
        }
        return result;
    }
}

