/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class PluggableArchivistsHelper
implements PluggableArchivists {
    private Archivist[] archivists = new Archivist[0];
    private static StringManager localStrings = StringManager.getManager(PluggableArchivistsHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivist getArchivistForArchive(String path) throws IOException {
        AbstractArchive archive;
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException(path);
        }
        if (f.isDirectory()) {
            archive = new FileArchive();
            ((FileArchive)archive).open(path);
        } else {
            archive = new InputJarArchive();
            ((InputJarArchive)archive).open(path);
        }
        Archivist archivist = null;
        try {
            archivist = this.getArchivistForArchive(archive);
        }
        finally {
            archive.close();
        }
        return archivist;
    }

    public Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException {
        return this.getArchivistForArchive(jarFileOrDirectory.getAbsolutePath());
    }

    public Archivist getArchivistForArchive(AbstractArchive archive) throws IOException {
        Archivist a = this.handles(archive);
        if (a != null) {
            try {
                Archivist archivist = (Archivist)a.getClass().newInstance();
                archivist.setPluggableArchivists(this);
                return archivist;
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{a.getClass(), archive});
                e.printStackTrace();
            }
        } else {
            String msg = localStrings.getString("enterprise.deployment.unknown.application.type", archive.getArchiveUri());
            throw new IOException(msg);
        }
        return null;
    }

    private synchronized Archivist handles(AbstractArchive archive) throws IOException {
        for (Archivist a : this.archivists) {
            if (!a.hasStandardDeploymentDescriptor(archive) && !a.hasRuntimeDeploymentDescriptor(archive)) continue;
            return a;
        }
        String uri = archive.getArchiveUri();
        File file = new File(uri);
        if (!file.isDirectory() && !uri.endsWith(".jar")) {
            Archivist[] arr$ = this.archivists;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Archivist a = arr$[i$];
                if (!uri.endsWith(a.getArchiveExtension())) continue;
                return a;
            }
        }
        for (Archivist a : this.archivists) {
            if (!a.postHandles(archive)) continue;
            return a;
        }
        return null;
    }

    public synchronized Archivist getArchivistForType(ModuleType type) {
        for (int i = 0; i < this.archivists.length; ++i) {
            if (!this.archivists[i].getModuleType().equals(type)) continue;
            try {
                Archivist archivist = (Archivist)this.archivists[i].getClass().newInstance();
                archivist.setPluggableArchivists(this);
                return archivist;
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{this.archivists[i].getClass(), type});
                e.printStackTrace();
            }
        }
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{null, type});
        return null;
    }

    public synchronized void registerArchivist(Archivist archivist) {
        for (int i = 0; i < this.archivists.length; ++i) {
            if (!this.archivists[i].getModuleType().equals(archivist.getModuleType())) continue;
            this.archivists[i] = archivist;
            return;
        }
        Archivist[] newArchivists = new Archivist[this.archivists.length + 1];
        System.arraycopy(this.archivists, 0, newArchivists, 0, this.archivists.length);
        newArchivists[this.archivists.length] = archivist;
        this.archivists = newArchivists;
    }

    public Archivist[] getRegisteredArchivists() {
        Archivist[] newArchivists = new Archivist[this.archivists.length + 1];
        System.arraycopy(this.archivists, 0, newArchivists, 0, this.archivists.length);
        return newArchivists;
    }
}

