/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.meta;

import com.sun.enterprise.admin.server.core.jmx.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfoBuilder {
    public static final String kSetterPrefix = "set";
    public static final String kGetterPrefix = "get";
    private Class mClass = null;
    private MBeanOperationInfo[] mOperations = null;
    private MBeanAttributeInfo[] mAttributes = null;
    private MBeanConstructorInfo[] mConstructors = null;
    private MBeanNotificationInfo[] mNotifications = null;
    private MBeanInfo mMBeanInfo = null;

    public MBeanInfoBuilder(Class aClass) throws IntrospectionException {
        if (aClass == null) {
            throw new IllegalArgumentException();
        }
        this.mClass = aClass;
        this.createOperations();
        this.createConstructors();
        this.createAttributes();
        this.createMBeanInfo();
        this.createNotifications();
    }

    public MBeanInfoBuilder(String aClassName) {
    }

    public MBeanInfoBuilder(String aClassName, ClassLoader cl) {
    }

    public MBeanOperationInfo[] getMBeanOperations() {
        return this.mOperations;
    }

    public MBeanConstructorInfo[] getMBeanConstructors() {
        return this.mConstructors;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    public MBeanAttributeInfo[] getMBeanAttributes() {
        return this.mAttributes;
    }

    private void createOperations() {
        Vector<String> excludeList = new Vector<String>();
        excludeList.add("java.lang.Object");
        excludeList.add("com.sun.enterprise.admin.server.core.mbean.config.AdminBase");
        Introspector reflector = new Introspector(this.mClass);
        Method[] methods = reflector.getCallableInstanceMethods(excludeList);
        Vector<MBeanOperationInfo> oprVector = new Vector<MBeanOperationInfo>();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            boolean isGetter = name.startsWith(kGetterPrefix);
            boolean isSetter = name.startsWith(kSetterPrefix);
            if (isGetter || isSetter) continue;
            oprVector.add(new MBeanOperationInfo(name, methods[i]));
        }
        this.mOperations = new MBeanOperationInfo[oprVector.size()];
        oprVector.toArray(this.mOperations);
    }

    private void createConstructors() {
        Constructor<?>[] ctors = this.mClass.getConstructors();
        this.mConstructors = new MBeanConstructorInfo[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            MBeanConstructorInfo ctorInfo;
            String ctorDesc = ctors[i].getName();
            this.mConstructors[i] = ctorInfo = new MBeanConstructorInfo(ctorDesc, ctors[i]);
        }
    }

    private void createNotifications() {
    }

    private void createMBeanInfo() {
        this.mMBeanInfo = new MBeanInfo(this.mClass.getName(), this.mClass.getName(), this.mAttributes, this.mConstructors, this.mOperations, this.mNotifications);
    }

    private void createAttributes() throws IntrospectionException {
        Vector<MBeanAttributeInfo> attrVector = new Vector<MBeanAttributeInfo>();
        Method[] declMethods = new Introspector(this.mClass).getDeclaredConcretePublicMethods();
        Method[] getters = this.getGetters(declMethods);
        Method[] setters = this.getSetters(declMethods);
        for (int i = 0; i < getters.length; ++i) {
            MBeanAttributeInfo attr = null;
            String methodName = getters[i].getName();
            String attrName = this.getAttributeNameFromGetter(methodName);
            Method getter = this.findAttrIn(attrName, getters);
            Method setter = this.findAttrIn(attrName, setters);
            boolean isReadable = getter != null;
            boolean isWritable = setter != null;
            boolean isIs = false;
            attr = new MBeanAttributeInfo(attrName, null, attrName, isReadable, isWritable, isIs);
            attrVector.add(attr);
        }
        this.mAttributes = new MBeanAttributeInfo[attrVector.size()];
        attrVector.toArray(this.mAttributes);
    }

    private Method[] getGetters(Method[] methods) {
        Vector<Method> getters = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith(kGetterPrefix)) continue;
            getters.add(methods[i]);
        }
        Method[] getterMethods = new Method[getters.size()];
        return getters.toArray(getterMethods);
    }

    private Method[] getSetters(Method[] methods) {
        Vector<Method> setters = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith(kSetterPrefix)) continue;
            setters.add(methods[i]);
        }
        Method[] setterMethods = new Method[setters.size()];
        return setters.toArray(setterMethods);
    }

    private String getAttributeNameFromGetter(String getterName) {
        int getStartsAt = getterName.indexOf(kGetterPrefix);
        int attributeStartsAt = getStartsAt + kGetterPrefix.length();
        return getterName.substring(attributeStartsAt);
    }

    private Method findAttrIn(String attrName, Method[] methods) {
        Method matcher = null;
        boolean found = false;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.endsWith(attrName)) continue;
            matcher = methods[i];
            break;
        }
        return matcher;
    }
}

