/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.auth;

import com.sun.enterprise.admin.server.core.jmx.auth.LoginDriver;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ASLoginDriverImpl
implements LoginDriver {
    private static final String ASADMIN_GROUP = "asadmin";
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager _strings = StringManager.getManager(ASLoginDriverImpl.class);

    public Subject login(String user, String password, String realm) {
        LoginContextDriver.login(user, password, realm);
        this.authorize(user, password, realm);
        return null;
    }

    private void authorize(String user, String password, String realmName) {
        boolean isAuthorized = false;
        try {
            boolean isValid = Realm.isValidRealm(realmName);
            if (!isValid) {
                realmName = Realm.getDefaultRealm();
            }
            Realm realm = Realm.getInstance(realmName);
            Enumeration groups = realm.getGroupNames(user);
            while (groups != null && groups.hasMoreElements()) {
                String groupName = (String)groups.nextElement();
                if (!ASADMIN_GROUP.equals(groupName)) continue;
                isAuthorized = true;
                break;
            }
        }
        catch (Exception ee) {
            _logger.log(Level.WARNING, "core.auth_failed", realmName);
            _logger.log(Level.INFO, "core.auth_fail_exception", ee);
            SecurityException se = new SecurityException(_strings.getString("admin.auth.failed"));
            se.initCause(ee);
            throw se;
        }
        if (!isAuthorized) {
            throw new SecurityException(_strings.getString("admin.auth.failed.nogroup"));
        }
    }
}

