/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.server.core.CustomMBeanRegistration;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.management.MBeanServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomMBeanRegistrationHelper {
    private final MBeanServer mbs;
    private final ConfigContext cc;
    private final String myName;
    private final CustomMBeanRegistration cmr;

    CustomMBeanRegistrationHelper(MBeanServer mbs, ConfigContext cc) throws Exception {
        this.mbs = mbs;
        this.cc = cc;
        this.myName = System.getProperty("com.sun.aas.instanceName");
        this.cmr = this.mbeanRegistrationFactory();
    }

    void registerMBeans() throws Exception {
        List<Mbean> m2r = this.getMBeans2Register();
        this.cmr.registerMBeans(m2r);
    }

    private CustomMBeanRegistration mbeanRegistrationFactory() throws Exception {
        String CUSTOM_REGRISTRATION_IMPL_CLASS = "com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl";
        Class<?> c = Class.forName("com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl");
        Class[] pts = new Class[]{MBeanServer.class};
        Constructor<?> ctor = c.getConstructor(pts);
        Object[] aps = new Object[]{this.mbs};
        return (CustomMBeanRegistration)ctor.newInstance(aps);
    }

    private List<Mbean> getMBeans2Register() throws Exception {
        return ServerBeansFactory.getFullyEnabledUserDefinedMBeans(this.cc, this.myName);
    }
}

