/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom.loading;

import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.util.OS;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public final class MBeanClassLoader
extends ClassLoader {
    private URL url;
    private ClassLoader parent;

    public MBeanClassLoader() throws CustomMBeanException {
        super(MBeanClassLoader.class.getClassLoader());
        this.init();
    }

    public MBeanClassLoader(ClassLoader delegatee) throws CustomMBeanException {
        super(delegatee);
        this.init();
    }

    private void init() throws CustomMBeanException {
        try {
            File mbf = this.getDefaultMBeanDirectory();
            this.url = mbf.toURL();
        }
        catch (MalformedURLException m) {
            String msg = CMBStrings.get("cmb.classloader.init", m.getLocalizedMessage());
            throw new CustomMBeanException(msg, m);
        }
    }

    private File getDefaultMBeanDirectory() {
        File appsFolder = new File(System.getProperty("com.sun.aas.instanceRoot"), "applications");
        return new File(appsFolder, "mbeans");
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] cd = this.getClassData(className);
        if (cd == null) {
            throw new ClassNotFoundException(CMBStrings.get("findClassFailed", className));
        }
        return this.defineClass(className, cd, 0, cd.length);
    }

    protected URL findResource(String name) {
        File searchResource = new File(this.url.getFile(), name);
        URL result = null;
        if (searchResource.exists()) {
            try {
                return searchResource.toURL();
            }
            catch (MalformedURLException mfe) {
                // empty catch block
            }
        }
        return result;
    }

    private byte[] getClassData(String cn) {
        byte[] cd = null;
        try {
            cd = this.isURLFile() ? this.getClassDataFromFile(this.url.getFile(), cn) : this.getClassDataFromURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private boolean isURLFile() {
        return "file".equals(this.url.getProtocol());
    }

    private byte[] getClassDataFromFile(String base, String cn) throws IOException, FileNotFoundException {
        String path = base + '/' + cn.replace('.', '/') + ".class";
        path = this.prunePath(path);
        FileInputStream fis = new FileInputStream(path);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] cd = null;
        try {
            byte[] buf = new byte[1024];
            int br = bis.read(buf, 0, buf.length);
            while (br != -1) {
                bos.write(buf, 0, br);
                br = bis.read(buf, 0, buf.length);
            }
            cd = bos.toByteArray();
            return cd;
        }
        catch (FileNotFoundException fe) {
            throw fe;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (Throwable t) {}
            return cd;
        }
    }

    private String prunePath(String path) {
        if (OS.isWindows() && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    private byte[] getClassDataFromURL() {
        throw new UnsupportedOperationException(CMBStrings.get("InternalError", "getClassDataFromURL() -- not implemented yet"));
    }
}

