/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.JMSDestinationInfo;
import com.sun.enterprise.admin.common.JMSStatus;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.JMSAdminException;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.configbeans.ResourceReferenceHelper;
import com.sun.enterprise.admin.mbeanapi.IResourcesMBean;
import com.sun.enterprise.admin.mbeans.JMSDestination;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionDefinitionUtils;
import com.sun.enterprise.connectors.util.JmsRaMapping;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourcesXMLParser;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.JMSAdminFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesMBean
extends BaseConfigMBean
implements IResourcesMBean {
    private static final String CUSTOM_RESOURCE = "custom-resource";
    private static final String JDBC_CONNECTION_POOL = "jdbc-connection-pool";
    private static final String CONNECTOR_RESOURCE = "connector-resource";
    private static final String ADMIN_OBJECT_RESOURCE = "admin-object-resource";
    private static final String JDBC_RESOURCE = "jdbc-resource";
    private static final String RESOURCE_ADAPTER_CONFIG = "resource-adapter-config";
    private static final String MAIL_RESOURCE = "mail-resource";
    private static final String EXTERNAL_JNDI_RESOURCE = "external-jndi-resource";
    private static final String CONNECTOR_CONNECTION_POOL = "connector-connection-pool";
    private static final String PERSISTENCE_MANAGER_FACTORY_RESOURCE = "persistence-manager-factory-resource";
    private static final String CONNECTOR_SECURITY_MAP = "security-map";
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager localStrings = StringManager.getManager(ResourcesMBean.class);
    private static final String GET = "get";
    private static final String BYNAME = "ByName";
    private static final String BYJNDINAME = "ByJndiName";
    private static final String PMF_SUFFIX = "PM";
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "javax.jms.ConnectionFactory";
    private static final String RESOURCES = "resources";
    private static final String POOL_NAME = "pool-name";
    private static final String POOL_TYPE = "connector-connection-pool";
    private static final String CONFIG = "config";
    private static final String CREATE_SECURITY_MAP = "createSecurityMap";
    private static final String DEST_NAME = "destName";
    private static final String DEST_TYPE = "destType";
    private static final String NAME = "Name";
    private static final String IMQ_DESTINATION_NAME = "imqDestinationName";
    private static final TargetType[] VALID_CREATE_DELETE_TYPES = new TargetType[]{TargetType.CONFIG, TargetType.SERVER, TargetType.DOMAIN, TargetType.CLUSTER, TargetType.STANDALONE_SERVER, TargetType.UNCLUSTERED_SERVER, TargetType.STANDALONE_CLUSTER, TargetType.DAS};
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.CONFIG, TargetType.SERVER, TargetType.DOMAIN, TargetType.CLUSTER, TargetType.STANDALONE_SERVER, TargetType.UNCLUSTERED_SERVER, TargetType.STANDALONE_CLUSTER, TargetType.DAS};

    private ResourceReferenceHelper getResourceReferenceHelper() {
        return new ResourceReferenceHelper(this.getConfigContext());
    }

    public String[] getSystemConnectorsAllowingPoolCreation() {
        return ConnectorRuntime.getRuntime().getSystemConnectorsAllowingPoolCreation();
    }

    @Override
    public ObjectName createCustomResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(CUSTOM_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createExternalJndiResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(EXTERNAL_JNDI_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createPersistenceManagerFactoryResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(PERSISTENCE_MANAGER_FACTORY_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createPMFResourceWithJDBCResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        String poolName = null;
        String jndiName = null;
        int indx = 0;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            if (ResourcesMBean.isAttrNameMatch(attr, POOL_NAME)) {
                poolName = (String)attr.getValue();
                indx = i;
            }
            if (!ResourcesMBean.isAttrNameMatch(attr, "jndi-name")) continue;
            jndiName = (String)attr.getValue();
        }
        if (poolName != null && !poolName.equals("")) {
            jndiName = jndiName + PMF_SUFFIX;
            AttributeList jdbcAttrList = new AttributeList();
            jdbcAttrList.add(new Attribute("jndi_name", jndiName));
            jdbcAttrList.add(new Attribute("pool_name", poolName));
            this.createResource(JDBC_RESOURCE, jdbcAttrList, null, tgtName);
            attrList.remove(indx);
            attrList.add(new Attribute("jdbc_resource_jndi_name", jndiName));
        }
        return this.createResource(PERSISTENCE_MANAGER_FACTORY_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createJmsConnectionFactory(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createJmsResource(attrList, props, tgtName);
    }

    @Override
    public ObjectName createJmsDestinationResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createJmsResource(attrList, props, tgtName);
    }

    public String getJmsRaMappedName(String name) {
        return ConnectorRuntime.getRuntime().getJmsRaMapping().getMappedName(name);
    }

    @Override
    public ObjectName createJmsResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        sLogger.info("createJmsResource -------------------");
        ObjectName mbean = null;
        Properties properties = new Properties();
        Target target = this.getResourceTarget(tgtName);
        JmsRaMapping ramap = ConnectorRuntime.getRuntime().getJmsRaMapping();
        if (props != null) {
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String raKey = ramap.getMappedName(key);
                if (raKey == null) {
                    raKey = key;
                }
                properties.put(raKey, (String)props.get(key));
            }
        }
        String raName = "jmsra";
        String resourceType = null;
        String jndiName = null;
        String description = null;
        Object enabled = null;
        String steadyPoolSize = null;
        String maxPoolSize = null;
        String poolResizeQuantity = null;
        String idleTimeoutInSecs = null;
        String maxWaitTimeInMillis = null;
        String failAllConnections = null;
        String transactionSupport = null;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            if (ResourcesMBean.isAttrNameMatch(attr, "res-type")) {
                resourceType = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "jndi-name")) {
                jndiName = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "enabled")) {
                enabled = attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "description")) {
                description = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "steady-pool-size")) {
                steadyPoolSize = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "max-pool-size")) {
                maxPoolSize = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "pool-resize-quantity")) {
                poolResizeQuantity = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "idle-timeout-in-seconds")) {
                idleTimeoutInSecs = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "max-wait-time-in-millis")) {
                maxWaitTimeInMillis = (String)attr.getValue();
                continue;
            }
            if (ResourcesMBean.isAttrNameMatch(attr, "transaction-support")) {
                transactionSupport = (String)attr.getValue();
                continue;
            }
            if (!ResourcesMBean.isAttrNameMatch(attr, "fail-all-connections")) continue;
            failAllConnections = (String)attr.getValue();
        }
        if (resourceType == null) {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_res_type"));
        }
        ObjectName resObjName = this.m_registry.getMbeanObjectName(RESOURCES, new String[]{this.getDomainName()});
        if (resourceType.equals(TOPIC_CF) || resourceType.equals(QUEUE_CF) || resourceType.equals(UNIFIED_CF)) {
            String defPoolName = ConnectorRuntime.getRuntime().getDefaultPoolName(jndiName);
            ObjectName connPool = null;
            try {
                connPool = (ObjectName)this.getMBeanServer().invoke(resObjName, "getConnectorConnectionPoolByName", new Object[]{defPoolName, tgtName}, new String[]{"java.lang.String", "java.lang.String"});
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (connPool == null) {
                AttributeList cpAttrList = new AttributeList();
                cpAttrList.add(new Attribute("name", defPoolName));
                cpAttrList.add(new Attribute("resource_adapter_name", raName));
                cpAttrList.add(new Attribute("connection_definition_name", resourceType));
                cpAttrList.add(new Attribute("max_pool_size", maxPoolSize == null ? "250" : maxPoolSize));
                cpAttrList.add(new Attribute("steady_pool_size", steadyPoolSize == null ? "1" : steadyPoolSize));
                if (poolResizeQuantity != null) {
                    cpAttrList.add(new Attribute("pool_resize_quantity", poolResizeQuantity));
                }
                if (idleTimeoutInSecs != null) {
                    cpAttrList.add(new Attribute("idle_timeout_in_seconds", idleTimeoutInSecs));
                }
                if (maxWaitTimeInMillis != null) {
                    cpAttrList.add(new Attribute("max_wait_time_in_millis", maxWaitTimeInMillis));
                }
                if (failAllConnections != null) {
                    cpAttrList.add(new Attribute("fail-all-connections", failAllConnections));
                }
                if (transactionSupport != null) {
                    cpAttrList.add(new Attribute("transaction-support", transactionSupport));
                }
                this.getMBeanServer().invoke(resObjName, "createConnectorConnectionPool", new Object[]{cpAttrList, properties, tgtName}, new String[]{AttributeList.class.getName(), Properties.class.getName(), "java.lang.String"});
            }
            AttributeList crAttrList = new AttributeList();
            crAttrList.add(new Attribute("jndi_name", jndiName));
            crAttrList.add(new Attribute("pool_name", defPoolName));
            if (enabled != null) {
                crAttrList.add(new Attribute("enabled", enabled));
            }
            if (description != null) {
                crAttrList.add(new Attribute("description", description));
            }
            try {
                mbean = (ObjectName)this.getMBeanServer().invoke(resObjName, "createConnectorResource", new Object[]{crAttrList, null, tgtName}, new String[]{AttributeList.class.getName(), Properties.class.getName(), "java.lang.String"});
            }
            catch (MBeanException me) {
                me.printStackTrace();
                if (connPool == null) {
                    this.getMBeanServer().invoke(resObjName, "deleteConnectorConnectionPool", new Object[]{defPoolName, tgtName}, new String[]{"java.lang.String", "java.lang.String"});
                }
                throw me;
            }
        }
        if (resourceType.equals(TOPIC) || resourceType.equals(QUEUE)) {
            properties = this.validateDestinationResourceProps(properties, jndiName);
            AttributeList aoAttrList = new AttributeList();
            aoAttrList.add(new Attribute("jndi_name", jndiName));
            aoAttrList.add(new Attribute("res_type", resourceType));
            aoAttrList.add(new Attribute("res_adapter", raName));
            if (enabled != null) {
                aoAttrList.add(new Attribute("enabled", enabled));
            }
            if (description != null) {
                aoAttrList.add(new Attribute("description", description));
            }
            sLogger.info("props = " + properties);
            mbean = (ObjectName)this.getMBeanServer().invoke(resObjName, "createAdminObjectResource", new Object[]{aoAttrList, properties, tgtName}, new String[]{AttributeList.class.getName(), Properties.class.getName(), "java.lang.String"});
        } else {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_res_type", resourceType));
        }
        return mbean;
    }

    private Properties validateDestinationResourceProps(Properties props, String jndiName) throws Exception {
        sLogger.fine("ResourcesMBean: validateDest(props=" + props + " jndiName=" + jndiName + ")");
        String providedDestinationName = this.getProvidedDestinationName(props);
        sLogger.fine("provided destination name =  " + providedDestinationName);
        if (providedDestinationName != null) {
            if (!this.isSyntaxValid(providedDestinationName)) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.destination_name_invalid", jndiName, providedDestinationName));
            }
        } else {
            String newDestName = this.computeDestinationName(jndiName);
            sLogger.log(Level.WARNING, "admin.mbeans.rmb.destination_name_missing", new Object[]{jndiName, newDestName});
            props.put(NAME, newDestName);
            sLogger.fine("Computed destination name" + newDestName + " and updated props");
        }
        return props;
    }

    private String getProvidedDestinationName(Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)props.get(key);
            if (!NAME.equals(key) && !IMQ_DESTINATION_NAME.equals(key) || value == null || value.length() == 0) continue;
            return value;
        }
        return null;
    }

    private boolean isSyntaxValid(String name) {
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String computeDestinationName(String providedJndiName) {
        char[] jndiName = providedJndiName.toCharArray();
        char[] finalName = new char[jndiName.length];
        finalName[0] = Character.isJavaIdentifierStart(jndiName[0]) ? jndiName[0] : 95;
        for (int i = 1; i < jndiName.length; ++i) {
            finalName[i] = Character.isJavaIdentifierPart(jndiName[i]) ? jndiName[i] : 95;
        }
        return new String(finalName);
    }

    @Override
    public ObjectName createJdbcConnectionPool(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(JDBC_CONNECTION_POOL, attrList, props, tgtName);
    }

    @Override
    public ObjectName createConnectorConnectionPool(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource("connector-connection-pool", attrList, props, tgtName);
    }

    @Override
    public ObjectName createConnectorResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(CONNECTOR_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createAdminObjectResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        String raName = null;
        String resType = null;
        boolean validResType = false;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            if (ResourcesMBean.isAttrNameMatch(attr, "res-adapter")) {
                raName = (String)attr.getValue();
            }
            if (!ResourcesMBean.isAttrNameMatch(attr, "res-type")) continue;
            resType = (String)attr.getValue();
        }
        if (this.isValidRAName(raName)) {
            String[] resTypes = ConnectorRuntime.getRuntime().getAdminObjectInterfaceNames(raName);
            if (resTypes == null || resTypes.length <= 0) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.null_ao_intf", raName));
            }
            for (int i = 0; i < resTypes.length; ++i) {
                if (!resTypes[i].equals(resType)) continue;
                validResType = true;
                break;
            }
            if (!validResType) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_res_type", resType));
            }
            return this.createResource(ADMIN_OBJECT_RESOURCE, attrList, props, tgtName);
        }
        return null;
    }

    @Override
    public ObjectName createJdbcResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        TargetType[] VALID_CREATE_DELETE_TYPES_JDBCRES = new TargetType[]{TargetType.CLUSTER, TargetType.UNCLUSTERED_SERVER, TargetType.DAS, TargetType.DOMAIN};
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_CREATE_DELETE_TYPES_JDBCRES, tgtName, this.getConfigContext());
        return this.createResource(JDBC_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createMailResource(AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(MAIL_RESOURCE, attrList, props, tgtName);
    }

    @Override
    public ObjectName createResourceAdapterConfig(AttributeList attrList, Properties props, String tgtName) throws Exception {
        ObjectName on = this.createResource(RESOURCE_ADAPTER_CONFIG, attrList, props, tgtName);
        return on;
    }

    private ObjectName createResource(String resourceType, AttributeList attrList, Properties props, String tgtName) throws Exception {
        return this.createResource(resourceType, attrList, props, tgtName, true);
    }

    private ObjectName createResource(String resourceType, AttributeList attrList, Properties props, String tgtName, boolean createResourceRefs) throws Exception {
        if (resourceType.equals("connector-connection-pool")) {
            this.validateCnctorConnPoolAttrList(attrList);
        }
        ObjectName mbean = null;
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_CREATE_DELETE_TYPES, tgtName, this.getConfigContext());
        boolean hasReferences = this.isResourceReferenceValid(resourceType, target.getType());
        boolean enabled = true;
        String resName = this.getResourceName(resourceType, attrList);
        int idxEnabled = -1;
        if (attrList != null) {
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute attr = (Attribute)attrList.get(i);
                if (!attr.getName().equals("enabled")) continue;
                enabled = Boolean.valueOf(attr.getValue().toString());
                idxEnabled = i;
            }
        }
        Attribute saveEnabledAtttr = null;
        if (!enabled && hasReferences) {
            saveEnabledAtttr = (Attribute)attrList.get(idxEnabled);
            attrList.set(idxEnabled, new Attribute("enabled", "true"));
        }
        mbean = (ObjectName)super.invoke("create" + ConfigMBeanHelper.convertTagName(resourceType), new Object[]{attrList}, new String[]{AttributeList.class.getName()});
        if (!enabled && hasReferences) {
            attrList.set(idxEnabled, saveEnabledAtttr);
        }
        if (props != null) {
            this.setProperties(mbean, props);
        }
        if (!hasReferences) {
            return mbean;
        }
        if ((target.getType() == TargetType.SERVER || target.getType() == TargetType.CLUSTER || target.getType() == TargetType.DAS) && resName != null && !resName.equals("") && createResourceRefs) {
            this.getResourceReferenceHelper().createResourceReference(target.getName(), enabled, resName);
        }
        return mbean;
    }

    private boolean isResourceReferenceValid(String resourceType, TargetType targetType) {
        boolean hasReferences = !resourceType.equals("connector-connection-pool") && !resourceType.equals(JDBC_CONNECTION_POOL) && !resourceType.equals(RESOURCE_ADAPTER_CONFIG) && !resourceType.equals(CONNECTOR_SECURITY_MAP) && targetType != TargetType.DOMAIN;
        return hasReferences;
    }

    private String getResourceName(String resourceType, AttributeList attrList) {
        block4: {
            if (attrList == null) break block4;
            if (resourceType.equals(RESOURCE_ADAPTER_CONFIG)) {
                for (int i = 0; i < attrList.size(); ++i) {
                    Attribute attr = (Attribute)attrList.get(i);
                    if (!attr.getName().equals("resource-adapter-name")) continue;
                    return (String)attr.getValue();
                }
            } else {
                for (int i = 0; i < attrList.size(); ++i) {
                    Attribute attr = (Attribute)attrList.get(i);
                    if (!attr.getName().equals("name") && !attr.getName().equals("jndi_name") && !attr.getName().equals("jndi-name")) continue;
                    return (String)attr.getValue();
                }
            }
        }
        return "";
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName) throws ConfigException {
        this.getResourceReferenceHelper().createResourceReference(targetName, enabled, referenceName);
    }

    public void createResourceReference(String targetName, boolean enabled, Resource resource) throws ConfigException {
        this.createResourceReference(targetName, enabled, this.getResourceName(resource.getType(), resource.getAttributes()));
    }

    public void createResourceReference(List<Resource> res, List<String> tgtNames, Boolean isEnabled) throws Exception {
        Iterator<Resource> resources = res.iterator();
        while (resources.hasNext()) {
            this.createAResourceReference(resources.next(), tgtNames, isEnabled);
        }
    }

    private void createAResourceReference(Resource res, List<String> tgtNames, Boolean isEnabled) throws Exception {
        for (String target : tgtNames) {
            this.createAResourceReference(res, target, isEnabled);
        }
    }

    private void createAResourceReference(Resource res, String target, Boolean isEnabled) throws Exception {
        TargetType targetType = this.getResourceTarget(target).getType();
        String resourceType = res.getType();
        if (this.isResourceReferenceValid(resourceType, targetType)) {
            this.createResourceReference(target, (boolean)isEnabled, this.getResourceName(res.getType(), res.getAttributes()));
        }
    }

    public void deleteResourceReference(String targetName, Resource resource) throws Exception {
        Target target = this.getResourceTarget(targetName);
        this.deleteResourceRef(this.getResourceName(resource.getType(), resource.getAttributes()), target, targetName);
    }

    public void deleteResourceReference(List<Resource> res, List<String> targetNames) throws Exception {
        int size = res.size();
        for (int i = size - 1; i >= 0; --i) {
            Resource resource = res.get(i);
            try {
                this.deleteAResourceRef(resource, targetNames);
                continue;
            }
            catch (Exception ex) {
                String s = localStrings.getString("unable.delete.resource.ref", resource.toString());
                sLogger.log(Level.WARNING, s);
            }
        }
    }

    private void deleteAResourceRef(Resource resource, List<String> targetNames) throws Exception {
        for (String tgt : targetNames) {
            Target target = this.getResourceTarget(tgt);
            if (!this.isResourceReferenceValid(resource.getType(), target.getType())) continue;
            this.deleteResourceRef(this.getResourceName(resource.getType(), resource.getAttributes()), target, tgt);
        }
    }

    private void setProperties(ObjectName objName, Properties props) throws Exception {
        if (props != null) {
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Attribute property = new Attribute(key, props.get(key));
                this.getMBeanServer().invoke(objName, "setProperty", new Object[]{property}, new String[]{Attribute.class.getName()});
            }
        }
    }

    private boolean isValidRAName(String raName) throws Exception {
        boolean retVal = false;
        if (raName == null || raName.equals("")) {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_res_adapter"));
        }
        if (raName.equals("jmsra") || raName.equals("jaxr-ra")) {
            retVal = true;
        } else {
            ObjectName applnObjName = this.m_registry.getMbeanObjectName("applications", new String[]{this.getDomainName()});
            int indx = raName.indexOf("#");
            if (indx != -1) {
                String appName = raName.substring(0, indx);
                ObjectName j2eeAppObjName = (ObjectName)this.getMBeanServer().invoke(applnObjName, "getJ2eeApplicationByName", new Object[]{appName}, new String[]{"java.lang.String"});
                if (j2eeAppObjName == null) {
                    throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_ra_app_not_found", appName));
                }
                retVal = true;
            } else {
                ObjectName connectorModuleObjName = (ObjectName)this.getMBeanServer().invoke(applnObjName, "getConnectorModuleByName", new Object[]{raName}, new String[]{"java.lang.String"});
                if (connectorModuleObjName == null) {
                    throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_ra_cm_not_found", raName));
                }
                retVal = true;
            }
        }
        return retVal;
    }

    private void validateCnctorConnPoolAttrList(AttributeList list) throws Exception {
        String raName = this.getAttributeValueFromList("resource_adapter_name", list);
        String connDef = this.getAttributeValueFromList("connection_definition_name", list);
        if (this.isValidRAName(raName) && !this.isValidConnectionDefinition(connDef, raName)) {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_ra_connectdef_not_found", connDef));
        }
    }

    private boolean isValidConnectionDefinition(String connectionDef, String raName) throws Exception {
        String[] names = ConnectorRuntime.getRuntime().getConnectionDefinitionNames(raName);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(connectionDef)) continue;
            return true;
        }
        return false;
    }

    private String getAttributeValueFromList(String name, AttributeList list) {
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            if (!ResourcesMBean.isAttrNameMatch(attr, name)) continue;
            return (String)attr.getValue();
        }
        return "";
    }

    @Override
    public ObjectName getCustomResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(CUSTOM_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getJdbcResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(JDBC_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getJdbcConnectionPoolByName(String key, String tgtName) throws Exception {
        return this.getResourceByName(JDBC_CONNECTION_POOL, key, tgtName);
    }

    @Override
    public ObjectName getExternalJndiResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(EXTERNAL_JNDI_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getMailResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(MAIL_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getConnectorResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(CONNECTOR_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getResourceAdapterConfigByResourceAdapterName(String key, String tgtName) throws Exception {
        return this.getResourceByName(RESOURCE_ADAPTER_CONFIG, key, tgtName);
    }

    @Override
    public ObjectName getAdminObjectResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(ADMIN_OBJECT_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getPersistenceManagerFactoryResourceByJndiName(String key, String tgtName) throws Exception {
        return this.getResourceByName(PERSISTENCE_MANAGER_FACTORY_RESOURCE, key, tgtName);
    }

    @Override
    public ObjectName getConnectorConnectionPoolByName(String key, String tgtName) throws Exception {
        return this.getResourceByName("connector-connection-pool", key, tgtName);
    }

    private ObjectName getResourceByName(String resType, String key, String tgtName) throws Exception {
        ObjectName mbean = null;
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, tgtName, this.getConfigContext());
        String opName = "";
        opName = resType.equals(RESOURCE_ADAPTER_CONFIG) ? GET + ConfigMBeanHelper.convertTagName(resType) + "By" + ConfigMBeanHelper.convertTagName("resource-adapter-name") : (resType.equals(JDBC_CONNECTION_POOL) || resType.equals("connector-connection-pool") ? GET + ConfigMBeanHelper.convertTagName(resType) + BYNAME : GET + ConfigMBeanHelper.convertTagName(resType) + BYJNDINAME);
        mbean = (ObjectName)super.invoke(opName, new Object[]{key}, new String[]{key.getClass().getName()});
        return mbean;
    }

    @Override
    public ObjectName[] getCustomResource(String tgtName) throws Exception {
        return this.getResource(CUSTOM_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getPersistenceManagerFactoryResource(String tgtName) throws Exception {
        return this.getResource(PERSISTENCE_MANAGER_FACTORY_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getJmsResource(String tgtName) throws Exception {
        return this.getJmsResource(null, tgtName);
    }

    @Override
    public ObjectName[] getJmsConnectionFactory(String tgtName) throws Exception {
        ObjectName[] QRes = null;
        ObjectName[] TRes = null;
        ObjectName[] uRes = null;
        ObjectName[] retVal = null;
        QRes = this.getJmsResource(QUEUE_CF, tgtName);
        TRes = this.getJmsResource(TOPIC_CF, tgtName);
        uRes = this.getJmsResource(UNIFIED_CF, tgtName);
        int i = 0;
        if (QRes != null) {
            i = QRes.length;
        }
        if (TRes != null) {
            i += TRes.length;
        }
        if (uRes != null) {
            i += uRes.length;
        }
        if (i > 0) {
            ArrayList<ObjectName> ret = new ArrayList<ObjectName>();
            if (QRes != null) {
                ret.addAll(Arrays.asList(QRes));
            }
            if (TRes != null) {
                ret.addAll(Arrays.asList(TRes));
            }
            if (uRes != null) {
                ret.addAll(Arrays.asList(uRes));
            }
            if (ret.size() > 0) {
                retVal = new ObjectName[ret.size()];
                ret.toArray(retVal);
            }
        }
        return retVal;
    }

    @Override
    public ObjectName[] getJmsDestinationResource(String tgtName) throws Exception {
        ObjectName[] QRes = null;
        ObjectName[] TRes = null;
        ObjectName[] retVal = null;
        QRes = this.getJmsResource(QUEUE, tgtName);
        TRes = this.getJmsResource(TOPIC, tgtName);
        int i = 0;
        if (QRes != null) {
            i = QRes.length;
        }
        if (TRes != null) {
            i += TRes.length;
        }
        if (i > 0) {
            ArrayList<ObjectName> ret = new ArrayList<ObjectName>();
            if (QRes != null) {
                ret.addAll(Arrays.asList(QRes));
            }
            if (TRes != null) {
                ret.addAll(Arrays.asList(TRes));
            }
            if (ret.size() > 0) {
                retVal = new ObjectName[ret.size()];
                ret.toArray(retVal);
            }
        }
        return retVal;
    }

    @Override
    public ObjectName[] getJmsResource(String resType, String tgtName) throws Exception {
        Target target = this.getResourceTarget(tgtName);
        ObjectName[] QRes = null;
        ObjectName[] TRes = null;
        ObjectName[] QCFRes = null;
        ObjectName[] TCFRes = null;
        ObjectName[] uCFRes = null;
        ObjectName[] retVal = null;
        if (resType == null || resType.equals("null")) {
            QRes = this.getJmsResourceForResType(QUEUE);
            TRes = this.getJmsResourceForResType(TOPIC);
            QCFRes = this.getJmsResourceForResType(QUEUE_CF);
            TCFRes = this.getJmsResourceForResType(TOPIC_CF);
            uCFRes = this.getJmsResourceForResType(UNIFIED_CF);
            int i = 0;
            if (QRes != null) {
                i = QRes.length;
            }
            if (TRes != null) {
                i += TRes.length;
            }
            if (QCFRes != null) {
                i += QCFRes.length;
            }
            if (TCFRes != null) {
                i += TCFRes.length;
            }
            if (uCFRes != null) {
                i += uCFRes.length;
            }
            if (i > 0) {
                ArrayList<ObjectName> ret = new ArrayList<ObjectName>();
                if (QRes != null) {
                    ret.addAll(Arrays.asList(QRes));
                }
                if (TRes != null) {
                    ret.addAll(Arrays.asList(TRes));
                }
                if (QCFRes != null) {
                    ret.addAll(Arrays.asList(QCFRes));
                }
                if (TCFRes != null) {
                    ret.addAll(Arrays.asList(TCFRes));
                }
                if (uCFRes != null) {
                    ret.addAll(Arrays.asList(uCFRes));
                }
                if (ret.size() > 0) {
                    retVal = new ObjectName[ret.size()];
                    ret.toArray(retVal);
                }
            }
        } else {
            if (!(resType.equals(QUEUE) || resType.equals(TOPIC) || resType.equals(QUEUE_CF) || resType.equals(TOPIC_CF) || resType.equals(UNIFIED_CF))) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.invalid_res_type", resType));
            }
            retVal = this.getJmsResourceForResType(resType);
        }
        if (tgtName != null && tgtName.trim().equals("")) {
            return retVal;
        }
        return this.filterForTarget(retVal, target);
    }

    private ObjectName[] getJmsResourceForResType(String resType) throws MBeanException {
        ObjectName[] retVal;
        block12: {
            retVal = null;
            ArrayList<ObjectName> al = new ArrayList<ObjectName>();
            try {
                if (resType.equals(QUEUE) || resType.equals(TOPIC)) {
                    ObjectName o = this.m_registry.getMbeanObjectName(RESOURCES, new String[]{this.getDomainName()});
                    ObjectName[] adminObjNames = (ObjectName[])this.getMBeanServer().invoke(o, "getAdminObjectResource", null, null);
                    if (adminObjNames != null) {
                        for (int i = 0; i < adminObjNames.length; ++i) {
                            String adminResAdapter;
                            String adminResType = (String)this.getMBeanServer().getAttribute(adminObjNames[i], "res_type");
                            if (adminResType == null || (!adminResType.equals(QUEUE) || !resType.equals(QUEUE)) && (!adminResType.equals(TOPIC) || !resType.equals(TOPIC)) || (adminResAdapter = (String)this.getMBeanServer().getAttribute(adminObjNames[i], "res_adapter")) == null || !adminResAdapter.equals("jmsra")) continue;
                            al.add(adminObjNames[i]);
                        }
                        if (!al.isEmpty()) {
                            retVal = new ObjectName[al.size()];
                            al.toArray(retVal);
                        }
                    }
                    break block12;
                }
                ObjectName o = this.m_registry.getMbeanObjectName(RESOURCES, new String[]{this.getDomainName()});
                ObjectName[] CRObjNames = (ObjectName[])this.getMBeanServer().invoke(o, "getConnectorResource", null, null);
                if (CRObjNames == null) break block12;
                for (int i = 0; i < CRObjNames.length; ++i) {
                    String resAdapter;
                    String cdn;
                    String poolName = (String)this.getMBeanServer().getAttribute(CRObjNames[i], "pool_name");
                    if (poolName == null) continue;
                    ObjectName CCPObjName = null;
                    try {
                        CCPObjName = (ObjectName)this.getMBeanServer().invoke(o, "getConnectorConnectionPoolByName", new Object[]{poolName}, new String[]{"java.lang.String"});
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    if (CCPObjName == null || (cdn = (String)this.getMBeanServer().getAttribute(CCPObjName, "connection_definition_name")) == null || !cdn.equals(resType) && !cdn.equals(resType) || (resAdapter = (String)this.getMBeanServer().getAttribute(CCPObjName, "resource_adapter_name")) == null || !resAdapter.equals("jmsra")) continue;
                    al.add(CRObjNames[i]);
                }
                if (!al.isEmpty()) {
                    retVal = new ObjectName[al.size()];
                    al.toArray(retVal);
                }
            }
            catch (InstanceNotFoundException infe) {
            }
            catch (ReflectionException re) {
            }
            catch (AttributeNotFoundException anf) {
                // empty catch block
            }
        }
        return retVal;
    }

    public ObjectName[] filterForTarget(ObjectName[] mbean, Target target) {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        try {
            if (target.getType() == TargetType.SERVER || target.getType() == TargetType.CLUSTER || target.getType() == TargetType.DAS) {
                ResourceRef[] refs = target.getResourceRefs();
                String objectProps = null;
                block2: for (int i = 0; i < mbean.length; ++i) {
                    for (int j = 0; j < refs.length; ++j) {
                        objectProps = mbean[i].getKeyPropertyListString();
                        if (objectProps.indexOf(refs[j].getRef()) <= 0) continue;
                        result.add(mbean[i]);
                        continue block2;
                    }
                }
                return result.toArray(new ObjectName[result.size()]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return mbean;
    }

    @Override
    public ObjectName[] getJdbcConnectionPool(String tgtName) throws Exception {
        return this.getResource(JDBC_CONNECTION_POOL, tgtName);
    }

    @Override
    public ObjectName[] getConnectorResource(String tgtName) throws Exception {
        return this.getResource(CONNECTOR_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getAdminObjectResource(String tgtName) throws Exception {
        return this.getResource(ADMIN_OBJECT_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getConnectorConnectionPool(String tgtName) throws Exception {
        return this.getResource("connector-connection-pool", tgtName);
    }

    @Override
    public ObjectName[] getJdbcResource(String tgtName) throws Exception {
        return this.getResource(JDBC_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getResourceAdapterConfig(String tgtName) throws Exception {
        return this.getResource(RESOURCE_ADAPTER_CONFIG, tgtName);
    }

    @Override
    public String getResourceAdapterConfig(String resAdapterConfig, Boolean verbose, String tgtName) throws Exception {
        String retVal = null;
        StringBuffer sb = new StringBuffer();
        if (resAdapterConfig != null && !resAdapterConfig.equals("") && !resAdapterConfig.equals("null")) {
            ObjectName rac = null;
            try {
                rac = (ObjectName)super.invoke("getResourceAdapterConfigByResourceAdapterName", new Object[]{resAdapterConfig}, new String[]{"java.lang.String"});
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (rac == null) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.null_rac"));
            }
            retVal = verbose != false ? this.getFormattedProperties(rac) : rac.getKeyProperty("resource-adapter-name");
        } else {
            ObjectName[] rac = this.getResource(RESOURCE_ADAPTER_CONFIG, tgtName);
            if (verbose.booleanValue() && rac != null && rac.length > 0) {
                for (int i = 0; i < rac.length; ++i) {
                    sb.append(this.getFormattedProperties(rac[i]));
                    sb.append("\n");
                }
            } else if (!verbose.booleanValue() && rac != null && rac.length > 0) {
                for (int i = 0; i < rac.length; ++i) {
                    sb.append(rac[i].getKeyProperty("resource-adapter-name"));
                    sb.append("\n");
                }
            } else {
                sb.append("No resource-adapter-config found.");
            }
            retVal = sb.toString();
        }
        return retVal;
    }

    private String getFormattedProperties(ObjectName objName) throws Exception {
        StringBuffer retVal = new StringBuffer();
        if (objName == null) {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_rac"));
        }
        retVal.append(objName.getKeyProperty("resource-adapter-name"));
        AttributeList props = (AttributeList)this.getMBeanServer().invoke(objName, "getProperties", null, null);
        if (!props.isEmpty()) {
            for (int i = 0; i < props.size(); ++i) {
                Attribute attrib = (Attribute)props.get(i);
                if (i == 0) {
                    retVal.append("\n");
                }
                retVal.append("\t");
                retVal.append(attrib.getName());
                retVal.append("=");
                retVal.append(attrib.getValue());
                retVal.append("\n");
            }
        }
        return retVal.toString();
    }

    @Override
    public ObjectName[] getMailResource(String tgtName) throws Exception {
        return this.getResource(MAIL_RESOURCE, tgtName);
    }

    @Override
    public ObjectName[] getExternalJndiResource(String tgtName) throws Exception {
        return this.getResource(EXTERNAL_JNDI_RESOURCE, tgtName);
    }

    private ObjectName[] getResource(String resType, String tgtName) throws Exception {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, tgtName, this.getConfigContext());
        ObjectName[] mbean = (ObjectName[])super.invoke(GET + ConfigMBeanHelper.convertTagName(resType), null, null);
        if ("connector-connection-pool".equals(resType) || JDBC_CONNECTION_POOL.equals(resType) || RESOURCE_ADAPTER_CONFIG.equals(resType) || target.getType() == TargetType.DOMAIN) {
            return mbean;
        }
        if (target.getType() == TargetType.SERVER || target.getType() == TargetType.CLUSTER || target.getType() == TargetType.DAS) {
            ResourceRef[] refs = target.getResourceRefs();
            String objectProps = null;
            block0: for (int i = 0; i < mbean.length; ++i) {
                for (int j = 0; j < refs.length; ++j) {
                    objectProps = mbean[i].getKeyPropertyListString();
                    if (objectProps.indexOf(refs[j].getRef()) <= 0) continue;
                    result.add(mbean[i]);
                    continue block0;
                }
            }
        }
        return result.toArray(new ObjectName[result.size()]);
    }

    @Override
    public void deleteCustomResource(String name, String tgtName) throws Exception {
        this.deleteResource(CUSTOM_RESOURCE, name, tgtName);
    }

    @Override
    public void deleteJdbcConnectionPool(String name, String tgtName) throws Exception {
        this.deleteJdbcConnectionPool(name, false, tgtName);
    }

    @Override
    public void deleteJdbcConnectionPool(String name, Boolean cascade, String tgtName) throws Exception {
        this.deleteConnectionPool(JDBC_RESOURCE, name, cascade, tgtName);
    }

    void deleteResourceRefFromTargets(String ref) throws Exception {
        ConfigContext ctx = this.getConfigContext();
        String targets = ResourceHelper.getResourceReferenceesAsString(ctx, ref);
        StringTokenizer strTok = new StringTokenizer(targets, ",");
        while (strTok.hasMoreTokens()) {
            String target = strTok.nextToken();
            if (ServerHelper.isAServer(ctx, target) && ServerHelper.isServerClustered(ctx, target)) continue;
            this.getResourceReferenceHelper().deleteResourceReference(target, ref);
        }
    }

    private void deleteConnectionPool(String resType, String name, Boolean cascade, String tgtName) throws Exception {
        String pmfOp;
        ObjectName[] pmfObjNames;
        boolean crFound = false;
        boolean pmfFound = false;
        Target target = this.getResourceTarget(tgtName);
        String[] resArr = null;
        String[] pmfArr = null;
        String opName = GET + ConfigMBeanHelper.convertTagName(resType);
        ObjectName[] resObjNames = (ObjectName[])super.invoke(opName, new Object[]{tgtName}, new String[]{"java.lang.String"});
        if (resObjNames != null && resObjNames.length > 0) {
            int k = 0;
            resArr = new String[resObjNames.length];
            for (int i = 0; i < resObjNames.length; ++i) {
                String poolName = (String)this.getMBeanServer().getAttribute(resObjNames[i], "pool_name");
                if (!poolName.equals(name)) continue;
                String jndiName = (String)this.getMBeanServer().getAttribute(resObjNames[i], "jndi_name");
                resArr[k++] = jndiName;
                crFound = true;
            }
        }
        if (resType.equalsIgnoreCase(JDBC_RESOURCE) && crFound && (pmfObjNames = (ObjectName[])super.invoke(pmfOp = GET + ConfigMBeanHelper.convertTagName(PERSISTENCE_MANAGER_FACTORY_RESOURCE), new Object[]{tgtName}, new String[]{"java.lang.String"})) != null && pmfObjNames.length > 0) {
            int k = 0;
            pmfArr = new String[pmfObjNames.length];
            block1: for (int i = 0; i < pmfObjNames.length; ++i) {
                String jrjnName = (String)this.getMBeanServer().getAttribute(pmfObjNames[i], "jdbc_resource_jndi_name");
                for (int j = 0; j < resArr.length && resArr[j] != null; ++j) {
                    if (!jrjnName.equals(resArr[j])) continue;
                    String pmfJndiName = (String)this.getMBeanServer().getAttribute(pmfObjNames[i], "jndi_name");
                    pmfArr[k++] = pmfJndiName;
                    pmfFound = true;
                    continue block1;
                }
            }
        }
        if (!cascade.booleanValue() && (crFound || pmfFound)) {
            if (resType.equalsIgnoreCase(JDBC_RESOURCE)) {
                throw new Exception(localStrings.getString("admin.mbeans.rmb.jdbc_res_pmf_ref_exists"));
            }
            throw new Exception(localStrings.getString("admin.mbeans.rmb.conn_res_ref_exists"));
        }
        if (cascade.booleanValue()) {
            boolean isDeleted;
            int i;
            if (pmfFound && pmfArr != null) {
                for (i = 0; i < pmfArr.length && pmfArr[i] != null; ++i) {
                    this.deleteResourceRefFromTargets((String)pmfArr[i]);
                    isDeleted = this.destroyResource(PERSISTENCE_MANAGER_FACTORY_RESOURCE, (String)pmfArr[i]);
                    if (isDeleted) continue;
                    throw new Exception(localStrings.getString("admin.mbeans.rmb.pmf_not_deleted", pmfArr[i]));
                }
            }
            if (resArr != null) {
                for (i = 0; i < resArr.length && resArr[i] != null; ++i) {
                    this.deleteResourceRefFromTargets(resArr[i]);
                    isDeleted = this.destroyResource(resType, resArr[i]);
                    if (isDeleted) continue;
                    if (resType.equalsIgnoreCase(JDBC_RESOURCE)) {
                        throw new Exception(localStrings.getString("admin.mbeans.rmb.jdbc_res_not_deleted", resArr[i]));
                    }
                    throw new Exception(localStrings.getString("admin.mbeans.rmb.conn_res_not_deleted", resArr[i]));
                }
            }
        }
        if (resType.equalsIgnoreCase(JDBC_RESOURCE)) {
            this.destroyResource(JDBC_CONNECTION_POOL, name);
        } else {
            this.destroyResource("connector-connection-pool", name);
        }
    }

    @Override
    public void deletePersistenceManagerFactoryResource(String name, String tgtName) throws Exception {
        this.deleteResource(PERSISTENCE_MANAGER_FACTORY_RESOURCE, name, tgtName);
        Resources resources = (Resources)this.getBaseConfigBean();
        if (resources.getJdbcResourceByJndiName(name + PMF_SUFFIX) != null) {
            this.deleteResource(JDBC_RESOURCE, name + PMF_SUFFIX, tgtName);
        }
    }

    @Override
    public void deleteJmsConenctionFactory(String name, String tgtName) throws Exception {
        this.deleteJmsResource(name, tgtName);
    }

    @Override
    public void deleteJmsDestinationResource(String name, String tgtName) throws Exception {
        this.deleteJmsResource(name, tgtName);
    }

    @Override
    public void deleteJmsResource(String name, String tgtName) throws Exception {
        Target target = this.getResourceTarget(tgtName);
        ObjectName connResource = null;
        try {
            connResource = (ObjectName)super.invoke("getConnectorResourceByJndiName", new Object[]{name}, new String[]{"java.lang.String"});
        }
        catch (Exception ee) {
            // empty catch block
        }
        if (connResource == null) {
            super.invoke("deleteAdminObjectResource", new Object[]{name, tgtName}, new String[]{"java.lang.String", "java.lang.String"});
        } else {
            String defPoolName = ConnectorRuntime.getRuntime().getDefaultPoolName(name);
            String poolName = (String)this.getMBeanServer().getAttribute(connResource, "pool_name");
            if (poolName != null && poolName.equals(defPoolName)) {
                this.deleteResourceRef(name, target, tgtName);
                this.destroyResource(CONNECTOR_RESOURCE, name);
                ObjectName connPool = this.getObjectNameForResType("connector-connection-pool", poolName);
                if (connPool != null) {
                    this.destroyResource("connector-connection-pool", poolName);
                }
            } else {
                ObjectName connResMBean = this.getObjectNameForResType(CONNECTOR_RESOURCE, name);
                super.invoke("removeConnectorResourceByJndiName", new Object[]{name}, new String[]{"java.lang.String"});
            }
        }
    }

    @Override
    public void deleteConnectorResource(String name, String tgtName) throws Exception {
        this.deleteResource(CONNECTOR_RESOURCE, name, tgtName);
    }

    @Override
    public void deleteAdminObjectResource(String name, String tgtName) throws Exception {
        this.deleteResource(ADMIN_OBJECT_RESOURCE, name, tgtName);
    }

    @Override
    public void deleteConnectorConnectionPool(String name, String tgtName) throws Exception {
        this.deleteConnectorConnectionPool(name, false, tgtName);
    }

    @Override
    public void deleteConnectorConnectionPool(String name, Boolean cascade, String tgtName) throws Exception {
        this.deleteConnectionPool(CONNECTOR_RESOURCE, name, cascade, tgtName);
    }

    @Override
    public void deleteJdbcResource(String name, String tgtName) throws Exception {
        this.deleteResource(JDBC_RESOURCE, name, tgtName);
    }

    @Override
    public void deleteResourceAdapterConfig(String name, String tgtName) throws Exception {
        this.deleteResource(RESOURCE_ADAPTER_CONFIG, name, tgtName);
    }

    @Override
    public void deleteMailResource(String name, String tgtName) throws Exception {
        this.deleteResource(MAIL_RESOURCE, name, tgtName);
    }

    @Override
    public void deleteExternalJndiResource(String name, String tgtName) throws Exception {
        this.deleteResource(EXTERNAL_JNDI_RESOURCE, name, tgtName);
    }

    private Target getResourceTarget(String tgtName) throws Exception {
        return TargetBuilder.INSTANCE.createTarget(VALID_CREATE_DELETE_TYPES, tgtName, this.getConfigContext());
    }

    private void deleteResource(String resType, String name, String tgtName) throws Exception {
        String operation = null;
        String suffix = null;
        suffix = resType.equals(RESOURCE_ADAPTER_CONFIG) ? "ByResourceAdapterName" : (resType.equals(JDBC_CONNECTION_POOL) || resType.equals("connector-connection-pool") ? BYNAME : BYJNDINAME);
        operation = "remove" + ConfigMBeanHelper.convertTagName(resType) + suffix;
        if (!(RESOURCE_ADAPTER_CONFIG.equals(resType) || JDBC_CONNECTION_POOL.equals(resType) || "connector-connection-pool".equals(resType))) {
            Target target = this.getResourceTarget(tgtName);
            this.deleteResourceRef(name, target, tgtName);
        }
        super.invoke(operation, new Object[]{name}, new String[]{"java.lang.String"});
    }

    public void deleteResource(List<Resource> res) throws Exception {
        int size = res.size();
        for (int i = size - 1; i >= 0; --i) {
            Resource resource = res.get(i);
            if (resource.getType().equals(CONNECTOR_SECURITY_MAP)) continue;
            try {
                this.deleteAResource(resource);
                continue;
            }
            catch (Exception ex) {
                String s = localStrings.getString("unable.delete.resource", resource.toString());
                sLogger.log(Level.WARNING, s);
            }
        }
    }

    private void deleteAResource(Resource resource) throws Exception {
        this.destroyResource(resource.getType(), this.getResourceName(resource.getType(), resource.getAttributes()));
    }

    private boolean destroyResource(String resType, String name) throws Exception {
        String operation = null;
        String suffix = null;
        boolean isDeleted = false;
        suffix = resType.equals(RESOURCE_ADAPTER_CONFIG) ? "ByResourceAdapterName" : (resType.equals(JDBC_CONNECTION_POOL) || resType.equals("connector-connection-pool") ? BYNAME : BYJNDINAME);
        operation = "remove" + ConfigMBeanHelper.convertTagName(resType) + suffix;
        try {
            super.invoke(operation, new Object[]{name}, new String[]{"java.lang.String"});
            isDeleted = true;
        }
        catch (ReflectionException re) {
            // empty catch block
        }
        return isDeleted;
    }

    private ObjectName getObjectNameForResType(String resType, String name) throws Exception {
        return this.m_registry.getMbeanObjectName(resType, new String[]{this.getDomainName(), name});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteResourceRef(String resRef, Target target, String tgtName) throws Exception {
        String resType = this.getResourceReferenceHelper().getResourceType(resRef);
        if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            if (!ServerHelper.serverReferencesResource(this.getConfigContext(), tgtName, resRef)) {
                throw new ConfigException(localStrings.getString("serverResourceRefDoesNotExist", tgtName, resRef));
            }
            if (!ResourceHelper.isResourceReferencedByServerOnly(this.getConfigContext(), resRef, tgtName)) throw new ConfigException(localStrings.getString("resourceHasMultipleRefs", tgtName, resRef, ResourceHelper.getResourceReferenceesAsString(this.getConfigContext(), resRef)));
            this.getResourceReferenceHelper().deleteResourceReference(tgtName, resRef);
        } else if (target.getType() == TargetType.CLUSTER) {
            if (!ClusterHelper.clusterReferencesResource(this.getConfigContext(), tgtName, resRef)) {
                throw new ConfigException(localStrings.getString("clusterResourceRefDoesNotExist", tgtName, resRef));
            }
            if (!ResourceHelper.isResourceReferencedByClusterOnly(this.getConfigContext(), resRef, tgtName)) throw new ConfigException(localStrings.getString("resourceHasMultipleRefs", tgtName, resRef, ResourceHelper.getResourceReferenceesAsString(this.getConfigContext(), resRef)));
            this.getResourceReferenceHelper().deleteResourceReference(tgtName, resRef);
        }
        if (!ResourceHelper.isResourceReferenced(this.getConfigContext(), resRef)) return;
        throw new ConfigException(localStrings.getString("resourceIsReferenced", resRef, ResourceHelper.getResourceReferenceesAsString(this.getConfigContext(), resRef)));
    }

    @Override
    public ArrayList createResource(String resourceXMLFile, String tgtName) throws Exception {
        boolean retVal = false;
        ArrayList<String> results = new ArrayList<String>();
        ResourcesXMLParser resourcesParser = new ResourcesXMLParser(resourceXMLFile);
        List resources = resourcesParser.getResourcesList();
        for (Resource resource : ResourcesXMLParser.getNonConnectorResourcesList(resources, false)) {
            String s = "";
            try {
                s = this.createAResource(resource, tgtName, true);
            }
            catch (Exception e) {
                s = e.getMessage();
            }
            results.add(s);
        }
        for (Resource resource : ResourcesXMLParser.getConnectorResourcesList(resources, false)) {
            String s = "";
            try {
                s = this.createAResource(resource, tgtName, true);
            }
            catch (Exception e) {
                s = e.getMessage();
            }
            results.add(s);
        }
        return results;
    }

    public void createResource(List<Resource> res, Boolean isEnabled) throws Exception {
        for (Resource resource : res) {
            this.createAResource(resource, null, false);
        }
    }

    public void createResourceAndResourceReference(List<Resource> resources, List<String> targetNameList, Boolean enabled) throws Exception {
        for (Resource resource : resources) {
            for (String target : targetNameList) {
                this.createAResource(resource, target, false);
                this.createAResourceReference(resource, target, enabled);
            }
        }
    }

    public void deleteResourceAndResourceReference(List<Resource> resources, List<String> targetNameList) throws Exception {
        int size = resources.size();
        for (int i = size - 1; i >= 0; --i) {
            String s;
            Resource resource = resources.get(i);
            if (resource.getType().equals(CONNECTOR_SECURITY_MAP)) continue;
            try {
                this.deleteAResourceRef(resource, targetNameList);
            }
            catch (Exception ex) {
                s = localStrings.getString("unable.delete.resource.ref", resource.toString());
                sLogger.log(Level.WARNING, s);
                continue;
            }
            try {
                this.deleteAResource(resource);
                continue;
            }
            catch (Exception ex) {
                s = localStrings.getString("unable.delete.resource", resource.toString());
                sLogger.log(Level.WARNING, s);
            }
        }
    }

    private String createAResource(Resource resource, String tgtName, boolean createResourceRefs) throws Exception {
        String resourceType = resource.getType();
        if (resourceType.equals(CONNECTOR_SECURITY_MAP)) {
            String s;
            AttributeList mapAttributes = resource.getAttributes();
            String poolName = null;
            String username = null;
            String password = null;
            if (mapAttributes != null) {
                int s2 = mapAttributes.size();
                for (int i = 0; i < s2; ++i) {
                    Attribute attribute = (Attribute)mapAttributes.get(i);
                    String n = attribute.getName();
                    if (attribute.getName().equalsIgnoreCase(POOL_NAME)) {
                        poolName = (String)attribute.getValue();
                    }
                    if (attribute.getName().equalsIgnoreCase("user-name")) {
                        username = (String)attribute.getValue();
                    }
                    if (!attribute.getName().equalsIgnoreCase("password")) continue;
                    password = (String)attribute.getValue();
                }
            }
            mapAttributes.add(new Attribute(POOL_NAME, poolName));
            ObjectName poolObj = this.m_registry.getMbeanObjectName("connector-connection-pool", new String[]{this.getDomainName(), poolName, CONFIG});
            try {
                ObjectName map = (ObjectName)this.getMBeanServer().invoke(poolObj, CREATE_SECURITY_MAP, new Object[]{mapAttributes, username, password, tgtName}, new String[]{AttributeList.class.getName(), "java.lang.String", "java.lang.String", "java.lang.String"});
                s = localStrings.getString("admin.mbeans.rmb.res_type_added", resourceType);
                sLogger.log(Level.INFO, s);
                return s;
            }
            catch (Exception e) {
                e.printStackTrace();
                s = localStrings.getString("admin.mbeans.rmb.res_type_not_added", resourceType, e.getMessage());
                sLogger.log(Level.INFO, s);
                throw new Exception(s, e);
            }
        }
        AttributeList attr = resource.getAttributes();
        String desc = resource.getDescription();
        if (desc != null) {
            attr.add(new Attribute("description", desc));
        }
        Properties props = resource.getProperties();
        try {
            ObjectName objName = this.createResource(resource.getType(), attr, props, tgtName, createResourceRefs);
            String s = localStrings.getString("admin.mbeans.rmb.res_type_added", resourceType);
            sLogger.log(Level.INFO, s);
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = localStrings.getString("admin.mbeans.rmb.res_type_not_added", resourceType, e.getMessage());
            sLogger.log(Level.INFO, s);
            throw new Exception(s, e);
        }
    }

    public Map getConnectionDefinitionPropertiesAndDefaults(String dataSource) {
        try {
            return new HashMap(ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults(dataSource.trim()));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Map getResourceAdapterBeanProperties(String location) {
        try {
            return new HashMap(ConnectorRuntime.getRuntime().getResourceAdapterBeanProperties(location));
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public String[] getConnectionDefinitionNames(String rarName) throws Exception {
        return ConnectorRuntime.getRuntime().getConnectionDefinitionNames(rarName);
    }

    @Override
    public Properties getResourceAdapterConfigProps(AttributeList attrList) throws Exception {
        String rarName = null;
        if (attrList != null) {
            int s = attrList.size();
            for (int i = 0; i < s; ++i) {
                Attribute attribute = (Attribute)attrList.get(i);
                String n = attribute.getName();
                if (!ResourcesMBean.isAttrNameMatch(attribute, "resource-adapter-name")) continue;
                rarName = (String)attribute.getValue();
            }
        } else {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_attrib_list"));
        }
        return ConnectorRuntime.getRuntime().getResourceAdapterConfigProps(rarName);
    }

    @Override
    public Properties getMCFConfigProps(AttributeList attrList) throws Exception {
        String rarName = null;
        String connDefName = null;
        if (attrList != null) {
            int s = attrList.size();
            for (int i = 0; i < s; ++i) {
                Attribute attribute = (Attribute)attrList.get(i);
                String n = attribute.getName();
                if (ResourcesMBean.isAttrNameMatch(attribute, "resource-adapter-name")) {
                    rarName = (String)attribute.getValue();
                }
                if (!ResourcesMBean.isAttrNameMatch(attribute, "connection-definition-name")) continue;
                connDefName = (String)attribute.getValue();
            }
        } else {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_attrib_list_mcf"));
        }
        return ConnectorRuntime.getRuntime().getMCFConfigProps(rarName, connDefName);
    }

    @Override
    public Properties getAdminObjectConfigProps(AttributeList attrList) throws Exception {
        String rarName = null;
        String adminObjIntf = null;
        if (attrList != null) {
            int s = attrList.size();
            for (int i = 0; i < s; ++i) {
                Attribute attribute = (Attribute)attrList.get(i);
                String n = attribute.getName();
                if (ResourcesMBean.isAttrNameMatch(attribute, "resource-adapter-name")) {
                    rarName = (String)attribute.getValue();
                }
                if (!ResourcesMBean.isAttrNameMatch(attribute, "admin-object-interface")) continue;
                adminObjIntf = (String)attribute.getValue();
            }
        } else {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_attrib_list_ao"));
        }
        return ConnectorRuntime.getRuntime().getAdminObjectConfigProps(rarName, adminObjIntf);
    }

    @Override
    public String[] getAdminObjectInterfaceNames(String rarName) throws Exception {
        if (rarName == null) {
            throw new Exception(localStrings.getString("admin.mbeans.rmb.null_raname_ao"));
        }
        return ConnectorRuntime.getRuntime().getAdminObjectInterfaceNames(rarName);
    }

    @Override
    public Boolean pingConnectionPool(String poolName, String tgtName) throws Exception {
        boolean retVal = false;
        TargetType[] validTargets = new TargetType[]{TargetType.CLUSTER, TargetType.DOMAIN, TargetType.SERVER, TargetType.DAS};
        Target target = TargetBuilder.INSTANCE.createTarget(validTargets, tgtName, this.getConfigContext());
        retVal = ConnectorRuntime.getRuntime().testConnectionPool(poolName);
        return retVal;
    }

    @Override
    protected MBeanServer getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    @Override
    public JMSStatus JMSPing() throws JMSAdminException {
        try {
            JMSAdmin jmsAdmin = this.getJMSAdmin();
            jmsAdmin.pingProvider();
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "JMSPing", e);
            this.handleException(e);
        }
        JMSStatus js = new JMSStatus();
        return js;
    }

    @Override
    public JMSStatus JMSPing(String username, String password, int port) throws JMSAdminException {
        try {
            JMSAdmin jmsAdmin = this.getJMSAdmin();
            jmsAdmin.pingProvider(username, password, port);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "JMSPing", e);
            this.handleException(e);
        }
        JMSStatus js = new JMSStatus();
        return js;
    }

    public String JMSPing(String targetName) throws JMSAdminException {
        try {
            Target target = this.getResourceTarget(targetName);
            if (JMSDestination.useJMX(target)) {
                JMSDestination jmsd = new JMSDestination();
                return jmsd.JMSPing(target.getName());
            }
            JMSAdmin jmsAdmin = this.getJMSAdmin(targetName);
            jmsAdmin.pingProvider();
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "JMSPing", e);
            this.handleException(e);
        }
        return "RUNNING";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJMSDestination(String destName, String destType, Properties destProps, String tgtName) throws JMSAdminException {
        sLogger.entering(this.getClass().getName(), "createJMSDestination", new Object[]{destName, destType, destProps, tgtName});
        this.validateJMSDestName(destName);
        this.validateJMSDestType(destType);
        int newDestType = 0;
        JMSAdmin jmsAdmin = null;
        boolean connected = false;
        try {
            Target target;
            if (destType.equals("queue")) {
                if (destProps == null) {
                    destProps = new Properties();
                }
                String maxConsumersProperty = IASJmsUtil.getMaxActiveConsumersProperty();
                String maxConsumersAttribute = IASJmsUtil.getMaxActiveConsumersAttribute();
                String maxConsumersValue = IASJmsUtil.getDefaultMaxActiveConsumers();
                if (!destProps.containsKey(maxConsumersProperty) && !destProps.containsKey(maxConsumersAttribute)) {
                    destProps.put(maxConsumersAttribute, maxConsumersValue);
                }
            }
            if (JMSDestination.useJMX(target = this.getResourceTarget(tgtName))) {
                JMSDestination jmsd = new JMSDestination();
                jmsd.createJMSDestination(destName, destType, destProps, tgtName);
                return;
            }
            jmsAdmin = this.getJMSAdmin(tgtName);
            jmsAdmin.connectToProvider();
            connected = true;
            if (destType.equals("topic")) {
                newDestType = 1;
            } else if (destType.equals("queue")) {
                newDestType = 0;
            }
            jmsAdmin.createProviderDestination(destName, newDestType, (Map)destProps);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (connected) {
                try {
                    jmsAdmin.disconnectFromProvider();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteJMSDestination(String destName, String destType, String tgtName) throws JMSAdminException {
        sLogger.entering(this.getClass().getName(), "deleteJMSDestination", new Object[]{destName, destType});
        this.validateJMSDestName(destName);
        this.validateJMSDestType(destType);
        int newDestType = 0;
        JMSAdmin jmsAdmin = null;
        boolean connected = false;
        try {
            Target target = this.getResourceTarget(tgtName);
            if (JMSDestination.useJMX(target)) {
                JMSDestination jmsd = new JMSDestination();
                jmsd.deleteJMSDestination(destName, destType, tgtName);
                return;
            }
            jmsAdmin = this.getJMSAdmin(tgtName);
            jmsAdmin.connectToProvider();
            connected = true;
            if (destType.equals("topic")) {
                newDestType = 1;
            } else if (destType.equals("queue")) {
                newDestType = 0;
            }
            jmsAdmin.deleteProviderDestination(destName, newDestType);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "deleteJMSDestination", e);
            this.handleException(e);
        }
        finally {
            if (connected) {
                try {
                    jmsAdmin.disconnectFromProvider();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    @Override
    public void flushJMSDestination(String destName, String destType, String tgtName) throws JMSAdminException {
        try {
            Target target = this.getResourceTarget(tgtName);
            if (JMSDestination.useJMX(target)) {
                JMSDestination jmsd = new JMSDestination();
                if (this.isClustered(tgtName)) {
                    boolean success = true;
                    Server[] servers = target.getServers();
                    for (int server = 0; server < servers.length; ++server) {
                        try {
                            jmsd.purgeJMSDestination(destName, destType, servers[server].getName());
                            continue;
                        }
                        catch (Exception e) {
                            success = false;
                            sLogger.log(Level.SEVERE, localStrings.getString("admin.mbeans.rmb.error_purging_jms_dest") + servers[server].getName());
                        }
                    }
                    if (!success) {
                        throw new Exception(localStrings.getString("admin.mbeans.rmb.error_purging_jms_dest"));
                    }
                } else {
                    jmsd.purgeJMSDestination(destName, destType, tgtName);
                }
            } else {
                sLogger.log(Level.WARNING, "Flush JMS destination not supported in the JMS SPI");
            }
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "flushJMSDestination", e);
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSDestinationInfo[] listJMSDestinations(String destType, String tgtName) throws JMSAdminException {
        JMSDestinationInfo[] destInfoArray = null;
        JMSAdmin jmsAdmin = null;
        boolean connected = false;
        sLogger.entering(this.getClass().getName(), "listJMSDestinations", destType);
        try {
            Target target = this.getResourceTarget(tgtName);
            if (JMSDestination.useJMX(target)) {
                JMSDestination jmsd = new JMSDestination();
                JMSDestinationInfo[] jMSDestinationInfoArray = jmsd.listJMSDestinations(tgtName, destType);
                return jMSDestinationInfoArray;
            }
            String[][] s = new String[][]{null, null};
            jmsAdmin = this.getJMSAdmin(tgtName);
            jmsAdmin.connectToProvider();
            connected = true;
            s = jmsAdmin.getProviderDestinations();
            destInfoArray = destType == null ? this.listAllDestinations(s) : (destType.equals("topic") || destType.equals("queue") ? this.listDestinationsByType(destType, s) : this.listAllDestinations(s));
            JMSDestinationInfo[] jMSDestinationInfoArray = destInfoArray;
            return jMSDestinationInfoArray;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "listJMSDestinations", e);
            this.handleException(e);
        }
        finally {
            if (connected) {
                try {
                    jmsAdmin.disconnectFromProvider();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
        return null;
    }

    private void validateJMSDestName(String destName) {
        if (destName == null || destName.length() <= 0) {
            throw new IllegalArgumentException(localStrings.getString("admin.mbeans.rmb.invalid_jms_destname", destName));
        }
    }

    private void validateJMSDestType(String destType) {
        if (destType == null || destType.length() <= 0) {
            throw new IllegalArgumentException(localStrings.getString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
        if (!destType.equals("queue") && !destType.equals("topic")) {
            throw new IllegalArgumentException(localStrings.getString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
    }

    @Override
    public void createPhysicalDestination(AttributeList attrList, Properties props, String target) throws JMSAdminException, MBeanException {
        String destType = null;
        String destName = null;
        if (attrList == null) {
            throw new IllegalArgumentException();
        }
        int size = attrList.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = (Attribute)attrList.get(i);
            if (attribute.getName().equalsIgnoreCase(DEST_TYPE)) {
                destType = (String)attribute.getValue();
            }
            if (!attribute.getName().equalsIgnoreCase(DEST_NAME)) continue;
            destName = (String)attribute.getValue();
        }
        this.createJMSDestination(destName, destType, props, target);
    }

    @Override
    public void deletePhysicalDestination(String destName, String destType, String target) throws JMSAdminException, MBeanException {
        this.deleteJMSDestination(destName, destType, target);
    }

    @Override
    public ObjectName[] listPhysicalDestinations(String target) throws JMSAdminException, MBeanException {
        ObjectName[] objectNames = null;
        JMSDestinationInfo[] destInfos = this.listJMSDestinations(null, target);
        int infoLength = 0;
        if (destInfos != null && destInfos.length > 0) {
            infoLength = destInfos.length;
        }
        if (infoLength == 0) {
            return null;
        }
        objectNames = new ObjectName[infoLength];
        for (int i = 0; i < infoLength; ++i) {
            String destName = destInfos[i].getDestinationName();
            String destType = destInfos[i].getDestinationType();
            try {
                ObjectName objectName;
                objectNames[i] = objectName = new ObjectName(this.getDomainName() + ":" + DEST_NAME + "=" + destName + "," + DEST_TYPE + "=" + destType);
                continue;
            }
            catch (MalformedObjectNameException e) {
                sLogger.warning(e.toString());
            }
        }
        return objectNames;
    }

    @Override
    public String[] getMessageListenerTypes(String raName) throws Exception {
        return ConnectorRuntime.getRuntime().getMessageListenerTypes(raName);
    }

    @Override
    public Properties getActivationConfProps(String raName, String msgLsnrType) throws Exception {
        return ConnectorRuntime.getRuntime().getMessageListenerConfigProps(raName, msgLsnrType);
    }

    @Override
    public Properties getActivationConfPropTypes(String raName, String msgLsnrType) throws Exception {
        return ConnectorRuntime.getRuntime().getMessageListenerConfigPropTypes(raName, msgLsnrType);
    }

    private synchronized JMSAdmin getJMSAdmin() throws Exception {
        JMSAdmin _jmsAdmin = null;
        ConfigContext serverContext = this.getConfigContext();
        JMSAdminFactory jmsaf = IASJmsUtil.getJMSAdminFactory();
        JmsService jmsService = (JmsService)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/configs/config[@name='server-config']/jms-service");
        String localhost = InetAddress.getLocalHost().getHostName();
        JmsHost hostElement = jmsService.getJmsHost(0);
        String portStr = hostElement.getPort();
        String username = hostElement.getAdminUserName();
        String password = hostElement.getAdminPassword();
        String jmsAdminURL = localhost + (portStr == null ? "" : ":" + portStr);
        _jmsAdmin = jmsaf.getJMSAdmin(jmsAdminURL, username, password);
        return _jmsAdmin;
    }

    private JMSAdmin getJMSAdmin(String targetName) throws Exception {
        TargetType[] vaildTargetTypes = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS, TargetType.CONFIG};
        Target target = TargetBuilder.INSTANCE.createTarget(vaildTargetTypes, targetName, this.getConfigContext());
        assert (target != null);
        Config config = target.getConfigs()[0];
        JmsService jmsService = config.getJmsService();
        JmsHost host = jmsService.getJmsHostByName(jmsService.getDefaultJmsHost());
        if (host == null) {
            host = jmsService.getJmsHost(0);
        }
        String hostName = host.getHost();
        String port = host.getPort();
        String adminUser = host.getAdminUserName();
        String adminPassword = host.getAdminPassword();
        String url = hostName + (port == null ? "" : ":" + port);
        if (adminUser == null) {
            return IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url);
        }
        return IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url, adminUser, adminPassword);
    }

    private JMSDestinationInfo[] listAllDestinations(String[][] s) {
        Vector<JMSDestinationInfo> dests = new Vector<JMSDestinationInfo>();
        for (int i = 0; i < s[1].length; ++i) {
            String destName = s[0][i];
            String destType = s[1][i].equals(Integer.valueOf(0).toString()) ? "queue" : (s[1][i].equals(Integer.valueOf(1).toString()) ? "topic" : "");
            JMSDestinationInfo destInfo = new JMSDestinationInfo(destName, destType);
            dests.addElement(destInfo);
        }
        if (dests.size() > 0) {
            Object[] objArray = dests.toArray();
            int size = dests.size();
            JMSDestinationInfo[] jmsDestArray = new JMSDestinationInfo[size];
            for (int i = 0; i < size; ++i) {
                jmsDestArray[i] = (JMSDestinationInfo)objArray[i];
            }
            return jmsDestArray;
        }
        return null;
    }

    private JMSDestinationInfo[] listDestinationsByType(String destType, String[][] s) {
        Vector<JMSDestinationInfo> dests = new Vector<JMSDestinationInfo>();
        String lookFor = null;
        lookFor = destType.equals("topic") ? Integer.valueOf(1).toString() : Integer.valueOf(0).toString();
        boolean j = false;
        for (int i = 0; i < s[1].length; ++i) {
            if (!s[1][i].equals(lookFor)) continue;
            String destName = s[0][i];
            String type = s[1][i].equals(Integer.valueOf(0).toString()) ? "queue" : (s[1][i].equals(Integer.valueOf(1).toString()) ? "topic" : "");
            JMSDestinationInfo destInfo = new JMSDestinationInfo(destName, type);
            dests.addElement(destInfo);
        }
        if (dests.size() > 0) {
            Object[] objArray = dests.toArray();
            int size = dests.size();
            JMSDestinationInfo[] jmsDestArray = new JMSDestinationInfo[size];
            for (int i = 0; i < size; ++i) {
                jmsDestArray[i] = (JMSDestinationInfo)objArray[i];
            }
            return jmsDestArray;
        }
        return null;
    }

    private void handleException(Exception e) throws JMSAdminException {
        if (e instanceof JMSAdminException) {
            throw (JMSAdminException)e;
        }
        String msg = e.getMessage();
        JMSAdminException jae = msg == null ? new JMSAdminException() : new JMSAdminException(msg);
        throw jae;
    }

    private static boolean isAttrNameMatch(Attribute attr, String name) {
        return attr.getName().replace('_', '-').equals(name.replace('_', '-'));
    }

    private boolean isClustered(String tgt) throws ConfigException {
        TargetType[] vaildTargetTypes = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS, TargetType.CONFIG};
        Target target = TargetBuilder.INSTANCE.createTarget(vaildTargetTypes, tgt, this.getConfigContext());
        assert (target != null);
        return target.getType() == TargetType.CLUSTER;
    }
}

