/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.mbeans.ExceptionHandler;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;

public class PasswordAliasConfigMBean
extends BaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(PasswordAliasConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(PasswordAliasConfigMBean.getLogger());
        }
        return _handler;
    }

    private PasswordAdapter getPasswordAdapter() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        String masterPassword = IdentityManager.getMasterPassword();
        return new PasswordAdapter(masterPassword.toCharArray());
    }

    public void addPasswordAlias(String aliasName, String password) throws ConfigException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            if (p.aliasExists(aliasName)) {
                throw new ConfigException(_strMgr.getString("passwordAliasExists", aliasName));
            }
            p.setPasswordForAlias(aliasName, password.getBytes());
        }
        catch (Exception ex) {
            throw PasswordAliasConfigMBean.getExceptionHandler().handleConfigException(ex, "addPasswordAliasException", aliasName);
        }
    }

    public void removePasswordAlias(String aliasName) throws ConfigException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            if (!p.aliasExists(aliasName)) {
                throw new ConfigException(_strMgr.getString("passwordAliasDoesNotExist", aliasName));
            }
            p.removeAlias(aliasName);
        }
        catch (Exception ex) {
            throw PasswordAliasConfigMBean.getExceptionHandler().handleConfigException(ex, "removePasswordAliasException", aliasName);
        }
    }

    public void updatePasswordAlias(String aliasName, String password) throws ConfigException {
        try {
            PasswordAdapter p = this.getPasswordAdapter();
            if (!p.aliasExists(aliasName)) {
                throw new ConfigException(_strMgr.getString("passwordAliasDoesNotExist", aliasName));
            }
            p.setPasswordForAlias(aliasName, password.getBytes());
        }
        catch (Exception ex) {
            throw PasswordAliasConfigMBean.getExceptionHandler().handleConfigException(ex, "updatePasswordAliasException", aliasName);
        }
    }

    public String[] getPasswordAliases() throws ConfigException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<String> en = this.getPasswordAdapter().getAliases();
            while (en.hasMoreElements()) {
                result.add(en.nextElement());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw PasswordAliasConfigMBean.getExceptionHandler().handleConfigException(ex, "listPasswordAliasException", "");
        }
    }
}

